var dailyGridVsSolarChart;
var dailyChartBalance;
var dailyChartYield;
var dailySavingsChart;
var dailyEarningsChart;

var groupedBy = "";
var startDate;
var endDate;
$(document).ready(function() {
    // load default first data (last 30 days - daily)
    const today = new Date();
    const thirtyDaysAgo = new Date(today);
    thirtyDaysAgo.setDate(today.getDate() - 30);

    const formatDate = (date) => {
        const year = date.getFullYear();
        const month = String(date.getMonth() + 1).padStart(2, '0');
        const day = String(date.getDate()).padStart(2, '0');
        return `${year}-${month}-${day}`;
    };

    const toDate = formatDate(today);
    const fromDate = formatDate(thirtyDaysAgo);
    startDate = fromDate;
    endDate = toDate;
    LoadCharts(fromDate, toDate, groupedBy);
    console.log("Loading Charts with dates: " + fromDate + " - " + toDate);
    $("#dayButton").click(function() {
        groupedBy = "";
        LoadCharts(startDate, endDate, groupedBy)
    });
    $("#monthButton").click(function() {
        groupedBy = "month";
        LoadCharts(startDate, endDate, groupedBy)
    });
    $("#yearButton").click(function() {
        groupedBy = "year";
        LoadCharts(startDate, endDate, groupedBy)
    });
});

function updateChartData(chart, newData) {
    // Update labels
    chart.data.labels = newData.labels;
    // Update datasets
    chart.data.datasets.forEach((dataset, index) => {
        dataset.data = newData.datasets[index].data;
    });
    // Update the chart
    chart.update();
}

function LoadCharts(fromDate, toDate, groupedBy) {
    var solarConsumptionArray = [];
    var gridConsumptionArray = [];
    var totalDcEnergyArray = [];
    var acEnergyArray = [];
    var gridFeedinArray = [];
    var energyPriceArray = [];
    var energyPriceSellArray = [];
    var balanceArray = [];
    var savingsArray = [];
    var fixedSavingsArray = [];
    var earningsArray = [];
    var spotEarningsArray = [];
    var spotSavingsArray = [];
    var dayArray = [];
    var url = "";
    if (groupedBy === "month") {
        url = "&groupBy=month"
    }
    if (groupedBy === "year") {
        url = "&groupBy=year"
    }
    $.ajax({
        type: "GET",
        contentType: "application/json",
        url: "/getdailyrecords?startDate=" + fromDate + "&endDate=" + toDate + url,
        dataType: 'json',
        cache: false,
        timeout: 600000,
        success: function(response) {
            console.log("Sending query to url: " + "/getdailyrecords?startDate=" + fromDate + "&endDate=" + toDate + url);
            var len = response.length;
            for (var i = 0; i < len; i++) {
                solarConsumptionArray.push(parseFloat(response[i].selfConsumed).toFixed(2).replace(/[.,]00$/, ""));
                gridConsumptionArray.push(parseFloat(response[i].gridConsumption).toFixed(2).replace(/[.,]00$/, ""));
                totalDcEnergyArray.push(parseFloat(response[i].panelEnergy).toFixed(2).replace(/[.,]00$/, ""));
                acEnergyArray.push(parseFloat(response[i].acEnergy).toFixed(2).replace(/[.,]00$/, ""));
                gridFeedinArray.push(parseFloat(response[i].gridFeedin).toFixed(2).replace(/[.,]00$/, ""));
                energyPriceArray.push(parseFloat(response[i].energyPricePerKwh).toFixed(2).replace(/[.,]00$/, ""));
                energyPriceSellArray.push(parseFloat(response[i].energyPricePerKwhSell).toFixed(2).replace(/[.,]00$/, ""));
                balanceArray.push(parseFloat(response[i].balance));

                fixedSavingsArray.push(parseFloat((totalDcEnergyArray[i] - gridFeedinArray[i]) * energyPriceArray[i] * 0.93).toFixed(2).replace(/[.,]00$/, ""));
                spotEarningsArray.push(parseFloat(response[i].todaySpotEarningsLocalCurrency).toFixed(2).replace(/[.,]00$/, ""));
                spotSavingsArray.push(parseFloat(response[i].todaySpotSavingsLocalCurrency).toFixed(2).replace(/[.,]00$/, ""));
                // we need to decide if we want to calculate the earnings based on the priceperkwh or spotprice
                if (spotEarningsArray[i] > 0) {
                    earningsArray.push(parseFloat(spotEarningsArray[i]).toFixed(2).replace(/[.,]00$/, ""));
                } else {
                    earningsArray.push(parseFloat(energyPriceSellArray[i] * gridFeedinArray[i]).toFixed(2).replace(/[.,]00$/, ""));
                }
                if (spotSavingsArray[i] > 0) {
                    savingsArray.push(parseFloat(spotSavingsArray[i]).toFixed(2).replace(/[.,]00$/, ""));
                } else {
                    savingsArray.push(parseFloat(fixedSavingsArray[i]).toFixed(2).replace(/[.,]00$/, ""));
                }

                if (groupedBy === "month") {
                    dayArray.push(response[i].month);
                }
                if (groupedBy === "year") {
                    dayArray.push(response[i].year);
                }
                if (groupedBy === "") {
                    dayArray.push(response[i].date);
                }
            }

            const ctx = document.getElementById('dailyChart_balance').getContext('2d');
            const backgroundColors = balanceArray.map((value) => getGradient(value, ctx));

            // data for daily grid vs solar chart
            const data_daily_grid_vs_solar = {
                labels: dayArray,
                datasets: [{
                        label: 'Solar consumption',
                        data: solarConsumptionArray,
                        backgroundColor: "#7CFC00",
                    },
                    {
                        label: 'Grid consumption',
                        data: gridConsumptionArray,
                        backgroundColor: "#B22222",
                    }
                ]
            };
            // data for daily balance chart
            const data_balance = {
                labels: dayArray,
                datasets: [{
                    label: 'Daily balance',
                    data: balanceArray,
                    backgroundColor: backgroundColors,
                    fill: false,
                    showLine: true,
                    borderColor: '#00ff15'
                }]
            };
            // data for total yield chart
            const data_yield = {
                labels: dayArray,
                datasets: [{
                        label: 'DC yield',
                        data: totalDcEnergyArray,
                        backgroundColor: "#7CFC00",
                    },
                    {
                        label: 'AC energy',
                        data: acEnergyArray,
                        backgroundColor: "#B22222",
                    },
                    {
                        label: 'Grid feed-in',
                        data: gridFeedinArray,
                        backgroundColor: "#035afc",
                    }]
            };
            // data for savings chart
            const data_savings = {
                labels: dayArray,
                datasets: [{
                    label: 'Daily savings',
                    data: savingsArray,
                    backgroundColor: '#1f7335',
                    fill: false,
                    showLine: true,
                    borderColor: '#00ff15'
                }]
            };

            // data for earnings chart
            const data_earnings = {
                labels: dayArray,
                datasets: [{
                    label: 'Daily earnings',
                    data: earningsArray,
                    backgroundColor: '#1f7335',
                    fill: false,
                    showLine: true,
                    borderColor: '#00ff15'
                }]
            };

            const config_daily_grid_vs_solar = {
                type: 'bar',
                data: data_daily_grid_vs_solar,
                options: {
                    plugins: {
                        title: {
                            display: true,
                            text: 'Daily chart'
                        },
                        tooltip: {
                            callbacks: {
                                title: function(tooltipItems) {
                                    return tooltipItems[0].label;
                                },
                                label: function(context) {
                                    const dataIndex = context.dataIndex;
                                    const dataset = context.dataset;
                                    const value = dataset.data[dataIndex];
                                    return `${dataset.label}: ${value} kWh`;
                                }
                            }
                        }
                    },
                    responsive: true,
                    scales: {
                        x: {
                            stacked: true,
                        },
                        y: {
                            stacked: true,
                            ticks: {
                                callback: function(value, index, values) {
                                    return value + " kWh";
                                }
                            }
                        }
                    }
                }
            };

            // configuration for daily balance chart
            const config_balance = {
                type: 'bar',
                data: data_balance,
                options: {
                    plugins: {
                        title: {
                            display: true,
                            text: 'Balance chart'
                        },
                        tooltip: {
                            callbacks: {
                                label: function(context) {
                                    var value = context.dataset.data[context.dataIndex];
                                    return "Balance: " + value + '%';
                                }
                            }
                        }
                    },
                    responsive: true,
                    scales: {
                        x: {
                            stacked: true,
                        },
                        y: {
                            stacked: true,
                            ticks: {
                                callback: function(value, index, values) {
                                    return value + "%";
                                }
                            }
                        }
                    }
                }
            };

            // definition of Daily Yield chart
            const config_daily_yield = {
                type: 'bar',
                data: data_yield,
                options: {
                    plugins: {
                        title: {
                            display: true,
                            text: 'Daily yield chart'
                        },
                        tooltip: {
                            callbacks: {
                                title: function(tooltipItems) {
                                    return tooltipItems[0].label;
                                },
                                label: function(context) {
                                    const dataIndex = context.dataIndex;
                                    const dataset = context.dataset;
                                    const value = dataset.data[dataIndex];
                                    return `${dataset.label}: ${value} kWh`;
                                }
                            }
                        }
                    },
                    responsive: true,
                    scales: {
                        x: {
                            stacked: false,
                        },
                        y: {
                            stacked: false,
                            ticks: {
                                callback: function(value, index, values) {
                                    return value + " kWh";
                                }
                            }
                        }
                    }
                }
            };

            // configuration for daily savings chart
            const config_savings = {
                type: 'bar',
                data: data_savings,
                options: {
                    plugins: {
                        title: {
                            display: true,
                            text: 'Savings chart'
                        },
                        tooltip: {
                            callbacks: {
                                label: function(context) {
                                    var value = context.dataset.data[context.dataIndex];
                                    return "Saving: " + value + ',-';
                                }
                            }
                        }
                    },
                    responsive: true,
                    scales: {
                        x: {
                            stacked: true,
                        },
                        y: {
                            stacked: true,
                            ticks: {
                                callback: function(value, index, values) {
                                    return value + ",-";
                                }
                            }
                        }
                    }
                }
            };

            // configuration for daily earnings chart
            const config_earnings = {
                type: 'bar',
                data: data_earnings,
                options: {
                    plugins: {
                        title: {
                            display: true,
                            text: 'Earnings chart'
                        },
                        tooltip: {
                            callbacks: {
                                label: function(context) {
                                    var value = context.dataset.data[context.dataIndex];
                                    return "Earning: " + value + ',-';
                                }
                            }
                        }
                    },
                    responsive: true,
                    scales: {
                        x: {
                            stacked: true,
                        },
                        y: {
                            stacked: true,
                            ticks: {
                                callback: function(value, index, values) {
                                    return value + ",-";
                                }
                            }
                        }
                    }
                }
            };

            const dailyChart = document.getElementById('dailyChart');
            const dailyChart_balance = document.getElementById('dailyChart_balance');
            const dailyYieldChart_element = document.getElementById('dailyYieldChart');
            const dailySavingsChart_element = document.getElementById('dailySavingsChart');
            const dailyEarningsChart_element = document.getElementById('dailyEarningsChart');

            if (dailyGridVsSolarChart == null) {
                dailyGridVsSolarChart = new Chart(dailyChart, config_daily_grid_vs_solar);
            } else {
                updateChartData(dailyGridVsSolarChart, data_daily_grid_vs_solar);
            }

            if (dailyChartBalance == null) {
                dailyChartBalance = new Chart(dailyChart_balance, config_balance);
            } else {
                updateChartData(dailyChartBalance, data_balance);
            }

            if (dailyChartYield == null) {
                dailyChartYield = new Chart(dailyYieldChart_element, config_daily_yield);
            } else {
                updateChartData(dailyChartYield, data_yield);
            }

            if (dailySavingsChart == null) {
                dailySavingsChart = new Chart(dailySavingsChart_element, config_savings);
            } else {
                updateChartData(dailySavingsChart, data_savings);
            }
            if (dailyEarningsChart == null) {
                dailyEarningsChart = new Chart(dailyEarningsChart_element, config_earnings);
            } else {
                updateChartData(dailyEarningsChart, data_earnings);
            }
        }
    });


}
function getGradient(value, ctx) {
  let gradient;

  if (value < 30) {
    gradient = ctx.createLinearGradient(0, 0, 0, 400);
    gradient.addColorStop(0, 'rgba(133, 0, 13, 1)');
    gradient.addColorStop(1, 'rgba(133, 0, 13, 0.4)');
  } else if (value < 70) {
    gradient = ctx.createLinearGradient(0, 0, 0, 400);
    gradient.addColorStop(0, 'rgba(240, 252, 0, 1)');
    gradient.addColorStop(1, 'rgba(240, 252, 0, 0.4)');
  } else {
    gradient = ctx.createLinearGradient(0, 0, 0, 400);
    gradient.addColorStop(0, 'rgba(45, 227, 0, 1)');
    gradient.addColorStop(1, 'rgba(45, 227, 13, 0.4)');
  }

  return gradient;
}