$( document ).ready(function() {
  var opts = {
    angle: 0, // The span of the gauge arc
    lineWidth: 0.22, // The line thickness
    radiusScale: 0.5, // Relative radius
    pointer: {
      length: 0.7, // // Relative to gauge radius
      strokeWidth: 0.06, // The thickness
      color: '#ffffff' // Fill color
    },
    limitMax: false,     // If false, max value increases automatically if value > maxValue
    limitMin: false,     // If true, the min value of the gauge will be fixed
    strokeColor: '#242936',
    generateGradient: true,
    highDpiSupport: true,     // High resolution support
    percentColors: [[0.0, "#00ff22"], [0.25, "#e8e515"], [0.50, "#f9c802"], [0.75, "#ff9900"], [1.0, "#ff0000"]], // !!!!
  };

  var opts_grid = {
    angle: 0, // The span of the gauge arc
    lineWidth: 0.22, // The line thickness
    radiusScale: 0.5, // Relative radius
    pointer: {
      length: 0.7, // // Relative to gauge radius
      strokeWidth: 0.06, // The thickness
      color: '#ffffff' // Fill color
    },
    limitMax: 2 * power_installed,     // If false, max value increases automatically if value > maxValue
    limitMin: 0,     // If true, the min value of the gauge will be fixed
    strokeColor: '#242936',
    generateGradient: true,
    highDpiSupport: true,     // High resolution support
    staticZones: [
      {strokeStyle: "#ff0000", min: 0, max: (power_installed - 400)},
      {strokeStyle: "#0008ff", min: (power_installed - 400), max: (power_installed + 400)},
      {strokeStyle: "#00a128", min: (power_installed + 400), max: (2 * power_installed)}
    ],
    //percentColors: [[0.0, "#7d0008" ], [0.25, "#ff5100" ], [0.50, "#34aeeb"], [0.75, "#00ffd9"], [1.0, "#00ff08"]], // !!!!
  };

// solar power gauge
  var target_solar_gauge = document.getElementById('solar_gauge'); // your canvas element
  var solar_gauge = new Gauge(target_solar_gauge).setOptions(opts); // create sexy gauge!
  solar_gauge.maxValue = power_installed; // set max gauge value
  solar_gauge.setMinValue(0);  // Prefer setter over gauge.minValue = 0
  solar_gauge.animationSpeed = 1; // set animation speed (32 is default value)
  solar_gauge.set(0); // set actual value

// consumption gauge
  var target_consumption_gauge = document.getElementById('consumption_gauge'); // your canvas element
  var consumption_gauge = new Gauge(target_consumption_gauge).setOptions(opts); // create sexy gauge!
  consumption_gauge.maxValue = 6000; // set max gauge value
  consumption_gauge.setMinValue(0);  // Prefer setter over gauge.minValue = 0
  consumption_gauge.animationSpeed = 1; // set animation speed (32 is default value)
  consumption_gauge.set(0); // set actual value

// grid gauge
  var target_grid_gauge = document.getElementById('grid_gauge'); // your canvas element
  var grid_gauge = new Gauge(target_grid_gauge).setOptions(opts_grid); // create sexy gauge!
  grid_gauge.maxValue = 2 * power_installed; // set max gauge value
  grid_gauge.setMinValue(0);  // Prefer setter over gauge.minValue = 0
  grid_gauge.animationSpeed = 1; // set animation speed (32 is default value)
  grid_gauge.set(0); // set actual value

// solar power gauge
  var target_wallbox_gauge = document.getElementById('wallbox_gauge'); // your canvas element
  var wallbox_gauge = new Gauge(target_wallbox_gauge).setOptions(opts); // create sexy gauge!
  wallbox_gauge.maxValue = power_installed; // set max gauge value
  wallbox_gauge.setMinValue(0);  // Prefer setter over gauge.minValue = 0
  wallbox_gauge.animationSpeed = 1; // set animation speed (32 is default value)
  wallbox_gauge.set(0); // set actual value
});
