$(document).ready(function() {
    $( "#scanipbutton" ).click(function() {
        $("#scanipinput").val('Scanning... (might take few minutes)');
        $( "#scanipinput" ).addClass('blinking');
        ScanSolaxIP();
    });

    // Add event listener for export configuration button
    $("#exportdb").click(function () {
        exportConfiguration();
    });

    // Add event listener for import configuration button
    $("#importdb").click(function () {
        openFileSelectDialog();
    });
});

function ScanSolaxIP() {
    $("#scanipbutton").prop("disabled", true);
    $.ajax({
        type: "GET",
        contentType: "application/json",
        url: "/scansolaxip",
        dataType: 'text',
        cache: false,
        timeout: 600000000,
        success: function(response) {
            var ip = response;
            if (response == "") {
                ip = "NOT FOUND: Please enter IP manually.";
                $("#scanipbutton").prop("disabled", true);
            }
            $( "#scanipinput" ).removeClass("blinking");
            $( "#scanipinput" ).val(ip);
            $("#scanipbutton").prop("disabled", true);
        }
    });
}

window.onload = function() {
    var select = document.querySelector('#connection_type_select');
    var modbusDiv = document.getElementById('modbus');
    var modbusTcpDiv = document.getElementById('modbustcp');
    var apiDiv = document.getElementById('api');
    var inverterTypeDiv = document.getElementById('inverter_type_div');
    if (select != null && select.value == 'modbus') {
        modbusDiv.style.display = 'block';
        modbusTcpDiv.style.display = 'none';
        apiDiv.style.display = 'none';
        inverterTypeDiv.style.display = 'block';
    } else if (select != null && select.value == 'api') {
        modbusDiv.style.display = 'none';
        apiDiv.style.display = 'block';
        modbusTcpDiv.style.display = 'none';
        inverterTypeDiv.style.display = 'none';
    } else if (select != null && select.value == 'modbustcp') {
        modbusTcpDiv.style.display = 'block';
        modbusDiv.style.display = 'none';
        apiDiv.style.display = 'none';
        inverterTypeDiv.style.display = 'block';
    }

    if (select != null) {
        select.addEventListener('change', function () {
            if (this.value == 'modbus') {
                modbusDiv.style.display = 'block';
                apiDiv.style.display = 'none';
                modbusTcpDiv.style.display = 'none';
                inverterTypeDiv.style.display = 'block';
            } else if (this.value == 'api') {
                modbusDiv.style.display = 'none';
                apiDiv.style.display = 'block';
                modbusTcpDiv.style.display = 'none';
                inverterTypeDiv.style.display = 'none';
            } else if (this.value == 'modbustcp') {
                modbusDiv.style.display = 'none';
                apiDiv.style.display = 'none';
                modbusTcpDiv.style.display = 'block';
                inverterTypeDiv.style.display = 'block';
            }
        });
    }
}

/**
 * Export configuration as JSON file
 */
function exportConfiguration() {
    // Show loading state
    $("#exportdb").prop("disabled", true);
    $("#exportdb").text("Exporting...");

    // Create a temporary link element to trigger download
    var link = document.createElement('a');
    link.href = '/exportdb';
    link.download = ''; // Browser will use the filename from Content-Disposition header

    // Handle the download
    link.onclick = function () {
        setTimeout(function () {
            $("#exportdb").prop("disabled", false);
            $("#exportdb").text("Export Configuration");
        }, 1000);
    };

    // Trigger download
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
}

// Explicitly add to global scope
window.exportConfiguration = exportConfiguration;

/**
 * Open file selection dialog for configuration import
 */
function openFileSelectDialog() {
    var fileInput = document.getElementById('fileInput');
    if (!fileInput) {
        // Create file input if it doesn't exist
        fileInput = document.createElement('input');
        fileInput.type = 'file';
        fileInput.id = 'fileInput';
        fileInput.accept = '.json';
        fileInput.style.display = 'none';
        document.body.appendChild(fileInput);
    }
    // Always bind the correct handler to avoid legacy import by mistake
    fileInput.onchange = importConfigurationFile;
    fileInput.click();
}

/**
 * Import configuration from selected file
 */
function importConfigurationFile(event) {
    var file = event.target.files[0];
    if (!file) {
        return;
    }

    if (!file.name.endsWith('.json')) {
        alert('Please select a JSON configuration file');
        return;
    }

    if (!confirm('This will replace all your current configuration. Are you sure you want to continue?')) {
        return;
    }

    // Show loading state
    $("#importdb").prop("disabled", true);
    $("#importdb").text("Importing...");

    var formData = new FormData();
    formData.append('file', file);
    formData.append('clearExisting', 'true');

    $.ajax({
        type: "POST",
        url: "/importdb",
        data: formData,
        processData: false,
        contentType: false,
        cache: false,
        timeout: 600000,
        success: function(response) {
            $("#importdb").prop("disabled", false);
            $("#importdb").text("Import Configuration");

            if (response === "ok") {
                alert("Configuration imported successfully! Please reload the page to see changes.");
                // Optional: reload the page after import
                setTimeout(function () {
                    window.location.reload();
                }, 2000);
            } else {
                alert("Import failed: " + response);
            }
        },
        error: function (xhr, status, error) {
            $("#importdb").prop("disabled", false);
            $("#importdb").text("Import Configuration");
            alert("Import failed: " + (xhr.responseText || error));
        }
    });

    // Clear the file input for next use
    event.target.value = '';
}

/**
 * Legacy function for backward compatibility
 */
function importDatabaseBackup(event) {
    if (!confirm('This will replace all your current configuration with the most recent export. Continue?')) {
        return;
    }

    $.ajax({
        type: "GET",
        contentType: "application/json",
        url: "/importdb",
        dataType: 'text',
        cache: false,
        timeout: 600000,
        success: function(response) {
            if (response === "ok") {
                alert("Configuration imported successfully!");
                setTimeout(function () {
                    window.location.reload();
                }, 2000);
            } else {
                alert("Import failed: " + response);
            }
        }
    });
}
