/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.smartinverterautomations;

import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.domain.InfoData;
import cz.snyll.sunny.domain.SmartInverterAutomation;
import cz.snyll.sunny.services.EventEntryManagerService;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.smartinverterautomations.SmartInverterAutomationService;
import java.lang.invoke.CallSite;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ChargeAutomationManager {
    private static final Logger log = LoggerFactory.getLogger(ChargeAutomationManager.class);
    private final InfoDataManagerService infoDataManagerService;
    private final EventEntryManagerService eventEntryManagerService;
    private final int DISCHARGING_THRESHOLD = 10;
    private final int CHARGING_THRESHOLD = 5;

    @Autowired
    public ChargeAutomationManager(InfoDataManagerService infoDataManagerService, EventEntryManagerService eventEntryManagerService) {
        this.infoDataManagerService = infoDataManagerService;
        this.eventEntryManagerService = eventEntryManagerService;
    }

    public SmartInverterAutomationService.BatteryState getBatteryState(SmartInverterAutomation smartInverterAutomation, int currentBatteryPercentage, int chargeTo, int dischargeTo, SmartInverterAutomationService.InverterState inverterState) {
        SmartInverterAutomationService.BatteryState batteryState = inverterState.getBatteryState();
        SmartInverterAutomationService.BatteryState chargingState = SmartInverterAutomationService.BatteryState.NO_ACTION;
        SmartInverterAutomationService.BatteryState dischargingState = SmartInverterAutomationService.BatteryState.NO_ACTION;
        if (smartInverterAutomation.isChargeEnabled()) {
            chargingState = this.handleCharging(smartInverterAutomation, currentBatteryPercentage, chargeTo, batteryState);
        }
        if (smartInverterAutomation.isForceDischargeEnabled()) {
            dischargingState = this.handleDischarging(smartInverterAutomation, currentBatteryPercentage, dischargeTo, batteryState);
        }
        if (chargingState == SmartInverterAutomationService.BatteryState.CHARGE) {
            return SmartInverterAutomationService.BatteryState.CHARGE;
        }
        if (dischargingState == SmartInverterAutomationService.BatteryState.DISCHARGE) {
            return SmartInverterAutomationService.BatteryState.DISCHARGE;
        }
        return SmartInverterAutomationService.BatteryState.NO_ACTION;
    }

    private SmartInverterAutomationService.BatteryState handleCharging(SmartInverterAutomation smartInverterAutomation, int currentBatteryPercentage, int chargeTo, SmartInverterAutomationService.BatteryState batteryState) {
        try {
            log.info("SMART INVERTER AUTOMATION: === CHARGING EVALUATION START ===");
            log.info("SMART INVERTER AUTOMATION: Current time: {}, Start time: {}, End time: {}", new Object[]{LocalTime.now(), smartInverterAutomation.getChargeStartTime(), smartInverterAutomation.getChargeEndTime()});
            if (!this.isWithinTimeRange(smartInverterAutomation.getChargeStartTime(), smartInverterAutomation.getChargeEndTime())) {
                log.info("SMART INVERTER AUTOMATION: Outside time range, returning NO_ACTION");
                return SmartInverterAutomationService.BatteryState.NO_ACTION;
            }
            log.info("SMART INVERTER AUTOMATION: Within time range. Current battery: {}%, Charge to: {}%, Current state: {}", new Object[]{currentBatteryPercentage, chargeTo, batteryState});
            if (batteryState == SmartInverterAutomationService.BatteryState.CHARGE) {
                if (currentBatteryPercentage >= chargeTo) {
                    log.info("SMART INVERTER AUTOMATION: Already charging and reached target {}%, stopping", (Object)chargeTo);
                    return SmartInverterAutomationService.BatteryState.NO_ACTION;
                }
                log.info("SMART INVERTER AUTOMATION: Already charging and below target, continuing to charge");
            } else {
                if (currentBatteryPercentage >= chargeTo - 5) {
                    log.info("SMART INVERTER AUTOMATION: Not charging yet, but battery at {}% >= (target {} - threshold {}), not starting", new Object[]{currentBatteryPercentage, chargeTo, 5});
                    return SmartInverterAutomationService.BatteryState.NO_ACTION;
                }
                log.info("SMART INVERTER AUTOMATION: Battery below threshold, looking for cheapest intervals");
            }
            log.info("SMART INVERTER AUTOMATION: Searching for {} intervals with max price {}", (Object)smartInverterAutomation.getChargeX15MinIntervals(), (Object)Float.valueOf(smartInverterAutomation.getChargeLimitPrice()));
            LocalDateTime chargeStartTime = this.getCheapest15MinIntervalsFromInfoData(smartInverterAutomation.getChargeX15MinIntervals(), smartInverterAutomation.getChargeStartTime(), smartInverterAutomation.getChargeEndTime(), smartInverterAutomation.getChargeLimitPrice());
            if (chargeStartTime == null) {
                log.info("SMART INVERTER AUTOMATION: No charge start time found (price too high or not enough data), returning NO_ACTION");
                this.eventEntryManagerService.raiseEvent("SMART INVERTER AUTOMATION: No charge start time found for automation: " + smartInverterAutomation.getAutomationName(), EventEntry.EventType.INFO);
                return SmartInverterAutomationService.BatteryState.NO_ACTION;
            }
            LocalDateTime now = LocalDateTime.now();
            int durationMinutes = smartInverterAutomation.getChargeX15MinIntervals() * 15;
            LocalDateTime chargeEndTime = chargeStartTime.plusMinutes(durationMinutes);
            log.info("SMART INVERTER AUTOMATION: Optimal charging window: {} to {} (duration: {} minutes)", new Object[]{chargeStartTime, chargeEndTime, durationMinutes});
            log.info("SMART INVERTER AUTOMATION: Current time: {}, Is after start? {}, Is before end? {}", new Object[]{now, now.isAfter(chargeStartTime), now.isBefore(chargeEndTime)});
            if (now.isAfter(chargeStartTime) && now.isBefore(chargeEndTime)) {
                log.info("SMART INVERTER AUTOMATION: WITHIN CHARGING WINDOW - SHOULD CHARGE NOW");
                return SmartInverterAutomationService.BatteryState.CHARGE;
            }
            log.info("SMART INVERTER AUTOMATION: Outside charging window, not charging yet");
        }
        catch (Exception e) {
            log.error("SMART INVERTER AUTOMATION: {} - Error while handling battery state", (Object)smartInverterAutomation.getAutomationName(), (Object)e);
        }
        return SmartInverterAutomationService.BatteryState.NO_ACTION;
    }

    private SmartInverterAutomationService.BatteryState handleDischarging(SmartInverterAutomation smartInverterAutomation, int currentBatteryPercentage, int dischargeTo, SmartInverterAutomationService.BatteryState batteryState) {
        try {
            if (!this.isWithinTimeRange(smartInverterAutomation.getForceDischargeStartTime(), smartInverterAutomation.getForceDischargeEndTime())) {
                return SmartInverterAutomationService.BatteryState.NO_ACTION;
            }
            if (batteryState == SmartInverterAutomationService.BatteryState.DISCHARGE ? currentBatteryPercentage <= dischargeTo : currentBatteryPercentage <= dischargeTo + 10) {
                return SmartInverterAutomationService.BatteryState.NO_ACTION;
            }
            LocalDateTime dischargeStartTime = this.getHighest15MinIntervalsFromInfoData(smartInverterAutomation.getDischargeX15MinIntervals(), smartInverterAutomation.getForceDischargeStartTime(), smartInverterAutomation.getForceDischargeEndTime(), smartInverterAutomation.getForceDischargePrice());
            if (dischargeStartTime == null) {
                log.info("SMART INVERTER AUTOMATION: No discharge start time found, returning NO_ACTION");
                this.eventEntryManagerService.raiseEvent("SMART INVERTER AUTOMATION: No discharge start time found for automation: " + smartInverterAutomation.getAutomationName(), EventEntry.EventType.INFO);
                return SmartInverterAutomationService.BatteryState.NO_ACTION;
            }
            LocalDateTime now = LocalDateTime.now();
            int durationMinutes = smartInverterAutomation.getDischargeX15MinIntervals() * 15;
            if (now.isAfter(dischargeStartTime) && now.isBefore(dischargeStartTime.plusMinutes(durationMinutes))) {
                return SmartInverterAutomationService.BatteryState.DISCHARGE;
            }
        }
        catch (Exception e) {
            log.error("SMART INVERTER AUTOMATION: {} - Error while handling battery state", (Object)smartInverterAutomation.getAutomationName(), (Object)e);
        }
        return SmartInverterAutomationService.BatteryState.NO_ACTION;
    }

    private boolean isWithinTimeRange(LocalTime startTime, LocalTime endTime) {
        LocalTime now = LocalTime.now();
        return !now.isBefore(startTime) && !now.isAfter(endTime);
    }

    private LocalDateTime getConsecutive15MinIntervalsFromInfoData(int intervals, LocalTime startTime, LocalTime endTime, float threshold, boolean findMax) {
        if (LocalTime.now().isBefore(startTime)) {
            log.info("SMART INVERTER AUTOMATION: Current time {} is before start time {}, returning null", (Object)LocalTime.now(), (Object)startTime);
            return null;
        }
        int startIntervalIndex = startTime.getHour() * 4 + startTime.getMinute() / 15 + 1;
        int endIntervalIndex = endTime.getHour() * 4 + endTime.getMinute() / 15;
        if (endTime.getMinute() != 0 || endTime.getHour() <= 0) {
            endIntervalIndex = endTime.getHour() * 4 + endTime.getMinute() / 15 + 1;
        }
        log.info("SMART INVERTER AUTOMATION: Time range {}:{} to {}:{} = intervals {} to {}", new Object[]{startTime.getHour(), startTime.getMinute(), endTime.getHour(), endTime.getMinute(), startIntervalIndex, endIntervalIndex});
        HashMap<CallSite, Float> allPrices = new HashMap<CallSite, Float>();
        for (int i = startIntervalIndex; i <= endIntervalIndex; ++i) {
            String key = "energy_spot_price_today_15min_local_" + i;
            InfoData priceData = this.infoDataManagerService.findByDataKey(key);
            if (priceData != null && priceData.isValid()) {
                try {
                    float price = Float.parseFloat(priceData.getDataValue());
                    allPrices.put((CallSite)((Object)key), Float.valueOf(price));
                    log.debug("SMART INVERTER AUTOMATION: Adding 15-min interval {} with price {}", (Object)i, (Object)Float.valueOf(price));
                }
                catch (NumberFormatException e) {
                    log.warn("SMART INVERTER AUTOMATION: Could not parse price for interval {}", (Object)i);
                }
                continue;
            }
            log.warn("SMART INVERTER AUTOMATION: No valid price data found for 15-min interval {}", (Object)i);
        }
        log.info("SMART INVERTER AUTOMATION: Loaded {} 15-minute interval prices from {} to {}", new Object[]{allPrices.size(), startIntervalIndex, endIntervalIndex});
        if (allPrices.size() < intervals) {
            log.warn("SMART INVERTER AUTOMATION: Not enough 15-min interval data available. Need {} intervals, have {}", (Object)intervals, (Object)allPrices.size());
            return null;
        }
        List bestIntervals = ChargeAutomationManager.findConsecutive15MinIntervals(allPrices, (int)intervals, (double)threshold, (boolean)findMax);
        if (findMax) {
            log.info("SMART INVERTER AUTOMATION: Highest price 15-min intervals: {}", (Object)bestIntervals);
        } else {
            log.info("SMART INVERTER AUTOMATION: Cheapest 15-min intervals: {}", (Object)bestIntervals);
        }
        if (!bestIntervals.isEmpty()) {
            int firstInterval = (Integer)bestIntervals.get(0);
            int lastInterval = (Integer)bestIntervals.get(bestIntervals.size() - 1);
            int startHour = (firstInterval - 1) / 4;
            int startMinute = (firstInterval - 1) % 4 * 15;
            int endHour = lastInterval / 4;
            int endMinute = lastInterval % 4 * 15;
            LocalDateTime result = LocalDateTime.now().withHour(startHour).withMinute(startMinute).withSecond(0).withNano(0);
            LocalDateTime calculatedEndTime = LocalDateTime.now().withHour(endHour).withMinute(endMinute).withSecond(0).withNano(0);
            log.info("SMART INVERTER AUTOMATION: Best window: intervals {} to {} = {}:{} to {}:{} (LocalDateTime: {} to {})", new Object[]{firstInterval, lastInterval, startHour, startMinute, endHour, endMinute, result, calculatedEndTime});
            return result;
        }
        log.info("SMART INVERTER AUTOMATION: No intervals found meeting threshold {}", (Object)Float.valueOf(threshold));
        return null;
    }

    private LocalDateTime getCheapest15MinIntervalsFromInfoData(int intervals, LocalTime startTime, LocalTime endTime, float maxPrice) {
        return this.getConsecutive15MinIntervalsFromInfoData(intervals, startTime, endTime, maxPrice, false);
    }

    private LocalDateTime getHighest15MinIntervalsFromInfoData(int intervals, LocalTime startTime, LocalTime endTime, float minPrice) {
        return this.getConsecutive15MinIntervalsFromInfoData(intervals, startTime, endTime, minPrice, true);
    }

    private static List<Integer> findConsecutive15MinIntervals(Map<String, Float> priceMap, int intervals, double threshold, boolean findMax) {
        ArrayList<Map.Entry> intervalPrices = new ArrayList<Map.Entry>();
        Pattern pattern = Pattern.compile(".*_(\\d+)$");
        if (priceMap.size() < intervals) {
            intervals = priceMap.size();
        }
        for (Map.Entry<String, Float> entry : priceMap.entrySet()) {
            Matcher matcher = pattern.matcher(entry.getKey());
            if (!matcher.matches()) continue;
            int intervalIndex = Integer.parseInt(matcher.group(1));
            intervalPrices.add(new AbstractMap.SimpleEntry<Integer, Float>(intervalIndex, entry.getValue()));
        }
        intervalPrices.sort(Comparator.comparingInt(Map.Entry::getKey));
        double bestAverage = findMax ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
        ArrayList<Integer> bestWindow = new ArrayList<Integer>();
        for (int i = 0; i <= intervalPrices.size() - intervals; ++i) {
            boolean isConsecutive = true;
            double sum = 0.0;
            int startInterval = (Integer)((Map.Entry)intervalPrices.get(i)).getKey();
            ArrayList<Integer> currentWindow = new ArrayList<Integer>();
            for (int j = 0; j < intervals; ++j) {
                Map.Entry entry = (Map.Entry)intervalPrices.get(i + j);
                int currentInterval = (Integer)entry.getKey();
                if (currentInterval != startInterval + j) {
                    isConsecutive = false;
                    break;
                }
                sum += (double)((Float)entry.getValue()).floatValue();
                currentWindow.add(currentInterval);
            }
            if (!isConsecutive) continue;
            double average = sum / (double)intervals;
            if (findMax) {
                log.debug("SMART INVERTER AUTOMATION: Window {} to {} - Average: {} (threshold: {}, current best: {})", new Object[]{startInterval, startInterval + intervals - 1, String.format("%.4f", average), threshold, String.format("%.4f", bestAverage)});
            } else {
                log.debug("SMART INVERTER AUTOMATION: Window {} to {} - Average: {} (threshold: {}, current best: {})", new Object[]{startInterval, startInterval + intervals - 1, String.format("%.4f", average), threshold, String.format("%.4f", bestAverage)});
            }
            if (findMax && average > bestAverage) {
                bestAverage = average;
                bestWindow = currentWindow;
                log.info("SMART INVERTER AUTOMATION: New best HIGH window found: intervals {}, average price: {}", bestWindow, (Object)String.format("%.4f", bestAverage));
                continue;
            }
            if (findMax || !(average < bestAverage)) continue;
            bestAverage = average;
            bestWindow = currentWindow;
            log.info("SMART INVERTER AUTOMATION: New best LOW window found: intervals {}, average price: {}", bestWindow, (Object)String.format("%.4f", bestAverage));
        }
        if (findMax && bestAverage < threshold || !findMax && bestAverage > threshold) {
            log.info("SMART INVERTER AUTOMATION: Best average {} does not meet threshold {} (findMax: {}), returning empty", new Object[]{String.format("%.4f", bestAverage), threshold, findMax});
            return new ArrayList<Integer>();
        }
        log.info("SMART INVERTER AUTOMATION: Final result - Best window: {}, Average price: {}, Threshold: {}", new Object[]{bestWindow, String.format("%.4f", bestAverage), threshold});
        return bestWindow;
    }
}

