/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.modbus;

import com.ghgande.j2mod.modbus.facade.ModbusTCPMaster;
import com.ghgande.j2mod.modbus.io.ModbusTransaction;
import com.ghgande.j2mod.modbus.net.SerialConnection;
import com.ghgande.j2mod.modbus.procimg.InputRegister;
import com.ghgande.j2mod.modbus.procimg.Register;
import com.ghgande.j2mod.modbus.procimg.SimpleRegister;
import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.domain.inverter.Inverter;
import cz.snyll.sunny.domain.inverter.ModbusTCPDetails;
import cz.snyll.sunny.services.EventEntryManagerService;
import cz.snyll.sunny.services.modbus.ModbusServiceInterface;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class ModbusTCPService
implements ModbusServiceInterface {
    private static final Logger log = LoggerFactory.getLogger(ModbusTCPService.class);
    private static final int INPUT_REGISTERS_MAX = 300;
    private static final int HOLDING_REGISTERS_MAX = 200;
    private static final int REGISTERS_PER_REQUEST = 100;
    private static final int SLEEP_BETWEEN_READS_MS = 1000;
    private static final int RETRY_DELAY_MS = 5000;
    private final EventEntryManagerService eventEntryManagerService;
    private Inverter inverter;
    private ModbusTCPMaster tcpMasterConnection;

    @Autowired
    public ModbusTCPService(EventEntryManagerService eventEntryManagerService) {
        this.eventEntryManagerService = eventEntryManagerService;
    }

    public void initializeModbusService() {
        try {
            ModbusTCPDetails modbusTCPDetails = (ModbusTCPDetails)this.inverter.getConnectionDetails();
            int tcpPort = modbusTCPDetails.getPort();
            String tcpIpAddress = modbusTCPDetails.getIp();
            log.info("Opening Modbus TCP connection to {}:{}", (Object)tcpIpAddress, (Object)tcpPort);
            if (this.tcpMasterConnection != null && this.tcpMasterConnection.isConnected()) {
                this.tcpMasterConnection.disconnect();
            }
            this.tcpMasterConnection = this.openConnection(tcpIpAddress, tcpPort);
        }
        catch (Exception e) {
            log.error("Error when opening Modbus TCP connection: {}", (Object)e.getMessage());
            this.eventEntryManagerService.raiseEvent("MODBUS: Error when opening TCP connection - " + e.getMessage(), EventEntry.EventType.ERROR, 60);
        }
    }

    public ModbusTCPMaster openConnection(String tcpIpAddress, int tcpPort) throws Exception {
        ModbusTCPMaster master = new ModbusTCPMaster(tcpIpAddress, tcpPort);
        master.connect();
        return master;
    }

    public void refreshConnection() {
        try {
            log.debug("Refreshing Modbus TCP connection.");
            if (this.tcpMasterConnection != null) {
                this.tcpMasterConnection.disconnect();
                this.tcpMasterConnection.connect();
            }
        }
        catch (Exception e) {
            log.error("Error when refreshing Modbus TCP connection: {}", (Object)e.getMessage());
            this.eventEntryManagerService.raiseEvent("MODBUS: Error when refreshing TCP connection - " + e.getMessage(), EventEntry.EventType.ERROR, 60);
        }
    }

    public ModbusTransaction createModbusTransaction(SerialConnection serialConnection, int timeout) {
        return null;
    }

    public synchronized ArrayList<Integer> readAllInputRegisters() {
        ArrayList<Integer> registerValues = new ArrayList<Integer>();
        for (int currentAddress = 0; currentAddress <= 300; currentAddress += 100) {
            try {
                InputRegister[] response;
                log.debug("Reading input registers from {} to {}", (Object)currentAddress, (Object)(currentAddress + 100 - 1));
                for (InputRegister reg : response = this.tcpMasterConnection.readInputRegisters(currentAddress, 100)) {
                    registerValues.add(reg.getValue());
                }
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                log.error("Exception during readAllInputRegisters at address {}: {}", (Object)currentAddress, (Object)e.getMessage());
                this.eventEntryManagerService.raiseEvent("MODBUS: Error reading input registers - " + e.getMessage(), EventEntry.EventType.ERROR, 60);
                this.refreshConnection();
                break;
            }
        }
        return registerValues;
    }

    public synchronized ArrayList<Integer> readAllHoldingRegisters() {
        ArrayList<Integer> registerValues = new ArrayList<Integer>();
        for (int currentAddress = 0; currentAddress <= 200; currentAddress += 100) {
            try {
                Register[] response;
                log.debug("Reading holding registers from {} to {}", (Object)currentAddress, (Object)(currentAddress + 100 - 1));
                for (Register reg : response = this.tcpMasterConnection.readMultipleRegisters(currentAddress, 100)) {
                    registerValues.add(reg.getValue());
                }
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception e) {
                log.error("Exception during readAllHoldingRegisters at address {}: {}", (Object)currentAddress, (Object)e.getMessage());
                this.eventEntryManagerService.raiseEvent("MODBUS: Error reading holding registers - " + e.getMessage(), EventEntry.EventType.ERROR, 60);
                this.refreshConnection();
                break;
            }
        }
        return registerValues;
    }

    public synchronized boolean writeSingleRegister(int registerAddress, int registerValue, boolean testMode, int maxRetries) {
        this.eventEntryManagerService.raiseEvent("WRITE REGISTER: Writing single register: " + registerAddress + " value: " + registerValue, EventEntry.EventType.INFO, 0);
        if (testMode) {
            this.eventEntryManagerService.raiseEvent("WRITE REGISTER: Test mode, not writing register", EventEntry.EventType.WARNING, 0);
            return true;
        }
        SimpleRegister register = new SimpleRegister(registerValue);
        for (int attempt = 1; attempt <= maxRetries + 1; ++attempt) {
            try {
                log.debug("Attempt #{} to write single register: address={}, value={}", new Object[]{attempt, registerAddress, registerValue});
                this.tcpMasterConnection.writeSingleRegister(1, registerAddress, (Register)register);
                this.eventEntryManagerService.raiseEvent("WRITE REGISTER: Written register " + registerAddress + " with value " + registerValue, EventEntry.EventType.SUCCESS, 0);
                return true;
            }
            catch (Exception e) {
                log.error("Error writing single register (attempt #{}): {}", (Object)attempt, (Object)e.getMessage());
                this.eventEntryManagerService.raiseEvent("MODBUS: Error when writing register, retrying... - " + e.getMessage(), EventEntry.EventType.ERROR, 60);
                if (attempt >= maxRetries + 1) continue;
                try {
                    Thread.sleep(5000L);
                    this.refreshConnection();
                    continue;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    return false;
                }
            }
        }
        this.eventEntryManagerService.raiseEvent("writeSingleRegister: " + (maxRetries + 1) + " attempts failed, giving up.", EventEntry.EventType.ERROR, 60);
        return false;
    }

    public synchronized boolean writeMultipleRegisters(int registerAddress, int[] registerValues, boolean testMode, int maxRetries) {
        this.eventEntryManagerService.raiseEvent("WRITE REGISTER: Writing multiple registers at address: " + registerAddress + " values: " + Arrays.toString(registerValues), EventEntry.EventType.INFO, 0);
        if (testMode) {
            this.eventEntryManagerService.raiseEvent("WRITE REGISTER: Test mode, not writing register", EventEntry.EventType.WARNING, 0);
            return true;
        }
        Register[] registers = new Register[registerValues.length];
        for (int i = 0; i < registerValues.length; ++i) {
            registers[i] = new SimpleRegister(registerValues[i]);
        }
        for (int attempt = 1; attempt <= maxRetries + 1; ++attempt) {
            try {
                log.debug("Attempt #{} to write multiple registers: address={}, values={}", new Object[]{attempt, registerAddress, Arrays.toString(registerValues)});
                this.tcpMasterConnection.writeMultipleRegisters(1, registerAddress, registers);
                this.eventEntryManagerService.raiseEvent("WRITE REGISTER: Written registers starting at " + registerAddress + " with values " + Arrays.toString(registerValues), EventEntry.EventType.SUCCESS, 0);
                return true;
            }
            catch (Exception e) {
                log.error("Error writing multiple registers (attempt #{}): {}", (Object)attempt, (Object)e.getMessage());
                this.eventEntryManagerService.raiseEvent("MODBUS: Error when writing multiple registers, retrying... - " + e.getMessage(), EventEntry.EventType.ERROR, 60);
                if (attempt >= maxRetries + 1) continue;
                try {
                    Thread.sleep(5000L);
                    this.refreshConnection();
                    continue;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    return false;
                }
            }
        }
        this.eventEntryManagerService.raiseEvent("writeMultipleRegisters: " + (maxRetries + 1) + " attempts failed, giving up.", EventEntry.EventType.ERROR, 60);
        return false;
    }

    public void setInverter(Inverter inverter) {
        this.inverter = inverter;
    }
}

