/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.modbus;

import cz.snyll.sunny.domain.inverter.ConnectionDetails;
import cz.snyll.sunny.domain.inverter.Inverter;
import cz.snyll.sunny.domain.inverter.ModbusRTUDetails;
import cz.snyll.sunny.domain.inverter.ModbusTCPDetails;
import cz.snyll.sunny.services.modbus.ModbusRTUService;
import cz.snyll.sunny.services.modbus.ModbusServiceInterface;
import cz.snyll.sunny.services.modbus.ModbusTCPService;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class ModbusServiceFactory {
    private final ApplicationContext context;
    private final ConcurrentHashMap<Long, ModbusServiceInterface> serviceCache = new ConcurrentHashMap();

    @Autowired
    public ModbusServiceFactory(ApplicationContext context) {
        this.context = context;
    }

    public ModbusServiceInterface getModbusService(Inverter inverter) {
        if (inverter == null) {
            return null;
        }
        Long inverterId = inverter.getId();
        return this.serviceCache.computeIfAbsent(inverterId, id -> {
            ConnectionDetails connectionDetails = inverter.getConnectionDetails();
            ModbusRTUService modbusService = null;
            if (connectionDetails instanceof ModbusRTUDetails) {
                ModbusRTUService modbusRTUService = (ModbusRTUService)this.context.getBean(ModbusRTUService.class);
                modbusRTUService.setInverter(inverter);
                modbusRTUService.initializeModbusService();
                modbusService = modbusRTUService;
            } else if (connectionDetails instanceof ModbusTCPDetails) {
                ModbusTCPService modbusTCPService = (ModbusTCPService)this.context.getBean(ModbusTCPService.class);
                modbusTCPService.setInverter(inverter);
                modbusTCPService.initializeModbusService();
                modbusService = modbusTCPService;
            }
            return modbusService;
        });
    }

    public void invalidateCache(Long inverterId) {
        this.serviceCache.remove(inverterId);
    }
}

