/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.datasenders;

import com.google.gson.Gson;
import cz.snyll.sunny.convenience.NicePrinter;
import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.domain.InfoData;
import cz.snyll.sunny.services.EventEntryManagerService;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.SunnyConfigurationService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class SunnyHomeOnlineDataSender {
    private final InfoDataManagerService infoDataManagerService;
    private final SunnyConfigurationService sunnyConfigurationService;
    private final EventEntryManagerService eventEntryManagerService;
    private final RestTemplate restTemplate;
    @Value(value="${sunnyhomeonline.url}")
    private String sunnyHomeOnlineUrl;

    public SunnyHomeOnlineDataSender(InfoDataManagerService infoDataManagerService, SunnyConfigurationService sunnyConfigurationService, EventEntryManagerService eventEntryManagerService) {
        this.eventEntryManagerService = eventEntryManagerService;
        this.sunnyConfigurationService = sunnyConfigurationService;
        this.infoDataManagerService = infoDataManagerService;
        SimpleClientHttpRequestFactory clientHttpRequestFactory = new SimpleClientHttpRequestFactory();
        clientHttpRequestFactory.setConnectTimeout(5000);
        clientHttpRequestFactory.setReadTimeout(5000);
        this.restTemplate = new RestTemplate((ClientHttpRequestFactory)clientHttpRequestFactory);
    }

    public void SendSunnyHomeData() {
        NicePrinter.nicePrint((String)"SUNNYHOME ONLINE DATASENDER: Going to send data to sunnyhome.click", (String)this.sunnyConfigurationService.getSetting("debug_mode"));
        if (this.sunnyConfigurationService.getSetting("sunnyhome_click_user").isEmpty() || this.sunnyConfigurationService.getSetting("sunnyhome_click_token").isEmpty()) {
            return;
        }
        NicePrinter.nicePrint((String)"SUNNYHOME ONLINE DATASENDER: Sending data to sunnyhome.click", (String)this.sunnyConfigurationService.getSetting("debug_mode"));
        String sunnyHomeOnlineUser = this.sunnyConfigurationService.getSetting("sunnyhome_click_user");
        String token = this.sunnyConfigurationService.getSetting("sunnyhome_click_token");
        ArrayList<InfoData> infoDataList = new ArrayList<InfoData>();
        List<String> infoDataKeysToSendArray = Arrays.asList("solax_network_voltage_phase_1", "solax_network_voltage_phase_2", "solax_network_voltage_phase_3", "solax_output_current_phase_1", "solax_output_current_phase_2", "solax_output_current_phase_3", "solax_power_now_phase_1", "solax_power_now_phase_2", "solax_power_now_phase_3", "solax_acpower", "solax_panels_voltage_1", "solax_panels_voltage_2", "solax_panels_current_1", "solax_panels_current_2", "solax_solar_panels_power_1", "solax_solar_panels_power_2", "solax_grid_frequency_phase_1", "solax_grid_frequency_phase_2", "solax_grid_frequency_phase_3", "solax_exported_power", "solax_battery_voltage", "solax_battery_current", "solax_battery_power", "solax_power_consumption_now", "solax_inverter_temperature_radiator", "solax_inverter_temperature", "solax_total_energy", "solax_today_yield", "solax_total_battery_discharge_energy", "solax_total_battery_charge_energy", "solax_today_battery_discharge_energy", "solax_today_battery_charge_energy", "solax_total_panels_energy", "solax_today_energy", "solax_today_offgrid_ac_energy", "solax_total_feedin_energy", "solax_total_consumption", "solax_today_feedin_energy", "solax_today_consumption", "solax_battery_remaining_capacity", "solax_battery_temperature", "solax_battery_remaining_energy", "solax_eps_x3_voltage_phase1", "solax_eps_x3_current_phase1", "solax_eps_x3_power_phase1", "solax_eps_x3_voltage_phase2", "solax_eps_x3_current_phase2", "solax_eps_x3_power_phase2", "solax_eps_x3_voltage_phase3", "solax_eps_x3_current_phase3", "solax_eps_x3_power_phase3", "solax_inverter_runmode", "solax_solar_panels_power_total", "solax_grid_consumption", "solax_today_yield_including_offgrid", "solax_today_self_consumed_yield", "solax_wifi_firmware_version", "solax_inverter_dsp_version", "solax_inverter_arm_version", "local_ip_address", "wallbox_workmode", "wallbox_voltage_1", "wallbox_voltage_2", "wallbox_voltage_3", "wallbox_charge_power_1", "wallbox_charge_power_2", "wallbox_charge_power_3", "wallbox_charge_power_total", "wallbox_current_1", "wallbox_current_2", "wallbox_current_3", "wallbox_external_current_1", "wallbox_external_current_2", "wallbox_external_current_3", "wallbox_external_power_1", "wallbox_external_power_2", "wallbox_external_power_3", "wallbox_external_power_total", "wallbox_temperature_plug", "wallbox_temperature_pcb", "wallbox_eq_single", "wallbox_eq_total", "wallbox_charging_duration", "wallbox_type_power", "wallbox_type_phase", "wallbox_type_charger", "wallbox_type_cpstate", "wallbox_occp_offline_mode", "today_spot_earnings_local_currency", "today_spot_savings_local_currency");
        for (InfoData infoEntry : this.infoDataManagerService.findAll()) {
            if (!infoDataKeysToSendArray.contains(infoEntry.getDataKey())) continue;
            infoDataList.add(infoEntry);
        }
        infoDataList.add(new InfoData("spot_prices", this.sunnyConfigurationService.getSetting("spot_prices"), "", 10000));
        infoDataList.add(new InfoData("spot_prices_buy", this.sunnyConfigurationService.getSetting("spot_prices_buy"), "", 10000));
        infoDataList.add(new InfoData("total_panel_power_installed", this.sunnyConfigurationService.getSetting("total_panel_power_installed"), "", 10000));
        infoDataList.add(new InfoData("latitude", this.sunnyConfigurationService.getSetting("latitude"), "", 10000));
        infoDataList.add(new InfoData("longitude", this.sunnyConfigurationService.getSetting("longitude"), "", 10000));
        infoDataList.add(new InfoData("energy_price_per_kwh", this.sunnyConfigurationService.getSetting("energy_price_per_kwh"), "", 10000));
        infoDataList.add(new InfoData("energy_price_per_kwh_sell", this.sunnyConfigurationService.getSetting("energy_price_per_kwh_sell"), "", 10000));
        infoDataList.add(new InfoData("away_mode", this.sunnyConfigurationService.getSetting("away_mode"), "", 10000));
        infoDataList.add(new InfoData("language", this.sunnyConfigurationService.getSetting("language"), "", 10000));
        infoDataList.add(new InfoData("spot_prices_buy", this.sunnyConfigurationService.getSetting("spot_prices_buy"), "", 10000));
        infoDataList.add(new InfoData("energy_currency", this.sunnyConfigurationService.getSetting("energy_currency"), "", 10000));
        infoDataList.add(new InfoData("allowed_users", this.sunnyConfigurationService.getSetting("sunnyhome_click_allowed_users"), "", 10000));
        String json = new Gson().toJson(infoDataList);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(token);
        NicePrinter.nicePrint((String)("SUNNYHOME ONLINE DATASENDER: Sending data to sunnyhome.click: " + json), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
        HttpEntity entity = new HttpEntity((Object)json, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(this.sunnyHomeOnlineUrl + "/data/" + sunnyHomeOnlineUser + "/save_data", HttpMethod.POST, entity, String.class, new Object[0]);
            NicePrinter.nicePrint((String)("SUNNYHOME ONLINE DATASENDER: Response from sunnyhome.click: " + (String)response.getBody()), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
        }
        catch (Exception e) {
            this.eventEntryManagerService.raiseEvent("SUNNYHOME ONLINE DATASENDER: Error while sending data to sunnyhome.click: " + e.getMessage(), EventEntry.EventType.ERROR, 60);
            NicePrinter.nicePrint((String)("SUNNYHOME ONLINE DATASENDER: Error while sending data to sunnyhome.click: " + e.getMessage()), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
        }
    }
}

