/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.datasenders;

import cz.snyll.sunny.convenience.NicePrinter;
import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.services.EventEntryManagerService;
import cz.snyll.sunny.services.SunnyConfigurationService;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class SunnyHomeClickAPIManager {
    private final SunnyConfigurationService sunnyConfigurationService;
    private final EventEntryManagerService eventEntryManagerService;
    private final RestTemplate restTemplate;

    public SunnyHomeClickAPIManager(SunnyConfigurationService sunnyConfigurationService, EventEntryManagerService eventEntryManagerService, RestTemplate restTemplate) {
        this.sunnyConfigurationService = sunnyConfigurationService;
        this.eventEntryManagerService = eventEntryManagerService;
        this.restTemplate = restTemplate;
    }

    public String CallSunnyHomeClickAPI(String token, String url, String jsonBody) {
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setBearerAuth(token);
            NicePrinter.nicePrint((String)("SUNNYHOME ONLINE DATASENDER: Calling API of sunnyhome.click: " + jsonBody), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            HttpEntity entity = new HttpEntity((Object)jsonBody, (MultiValueMap)headers);
            HttpMethod method = jsonBody != null && !jsonBody.isEmpty() ? HttpMethod.POST : HttpMethod.GET;
            ResponseEntity response = this.restTemplate.exchange(url, method, entity, String.class, new Object[0]);
            if (response.getStatusCode() != HttpStatus.OK) {
                this.eventEntryManagerService.raiseEvent("SUNNYHOME ONLINE DATASENDER: Error while calling API of sunnyhome.click: " + (String)response.getBody(), EventEntry.EventType.ERROR);
                return null;
            }
            return (String)response.getBody();
        }
        catch (HttpClientErrorException e) {
            NicePrinter.nicePrint((String)("SUNNYHOME ONLINE DATASENDER: Error while calling API of sunnyhome.click: " + e.getMessage()), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            return null;
        }
    }
}

