/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.datasenders;

import com.influxdb.client.InfluxDBClient;
import com.influxdb.client.InfluxDBClientFactory;
import com.influxdb.client.WriteApiBlocking;
import com.influxdb.client.domain.WritePrecision;
import cz.snyll.sunny.convenience.NicePrinter;
import cz.snyll.sunny.domain.InfoData;
import cz.snyll.sunny.services.SunnyConfigurationService;
import cz.snyll.sunny.services.datasenders.RemoteDataSender;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InfluxDbDataSender
implements RemoteDataSender {
    private String bucket;
    private String org;
    private InfluxDBClient client;
    private final SunnyConfigurationService sunnyConfigurationService;

    @Autowired
    public InfluxDbDataSender(SunnyConfigurationService sunnyConfigurationService) {
        this.sunnyConfigurationService = sunnyConfigurationService;
        String url = sunnyConfigurationService.getSetting("influxdb_url");
        if (url == null || url.isBlank()) {
            return;
        }
        String token = sunnyConfigurationService.getSetting("influxdb_apitoken");
        if (token == null || token.isBlank()) {
            return;
        }
        this.bucket = sunnyConfigurationService.getSetting("influxdb_bucket");
        this.org = sunnyConfigurationService.getSetting("influxdb_org");
        this.client = InfluxDBClientFactory.create((String)url, (char[])token.toCharArray());
    }

    public void sendData(InfoData infoData) {
        if (this.client == null) {
            return;
        }
        try {
            String data = "InfoData,dataKey=" + infoData.getDataKey() + " dataValue=" + infoData.getDataValue();
            NicePrinter.nicePrint((String)("INFLUX: Sending remote data: " + data), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            WriteApiBlocking writeApi = this.client.getWriteApiBlocking();
            writeApi.writeRecord(this.bucket, this.org, WritePrecision.NS, data);
        }
        catch (Exception e) {
            NicePrinter.nicePrint((String)("INFLUXDB: Issue with sending data: " + e.getMessage()), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
        }
    }

    public void sendMultipleData(ArrayList<InfoData> infoData) {
        if (this.client == null) {
            return;
        }
        try {
            ArrayList<CallSite> data = new ArrayList<CallSite>();
            for (InfoData infoData1 : infoData) {
                data.add((CallSite)((Object)("InfoData,dataKey=" + infoData1.getDataKey() + " dataValue=" + infoData1.getDataValue())));
            }
            NicePrinter.nicePrint((String)("INFLUX: Sending remote data: " + data), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            WriteApiBlocking writeApi = this.client.getWriteApiBlocking();
            writeApi.writeRecords(this.bucket, this.org, WritePrecision.NS, data);
        }
        catch (Exception e) {
            NicePrinter.nicePrint((String)("INFLUXDB: Issue with sending data: " + e.getMessage()), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
        }
    }
}

