/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.database;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import cz.snyll.sunny.domain.CustomDashboardData;
import cz.snyll.sunny.domain.DailyRecord;
import cz.snyll.sunny.domain.Device;
import cz.snyll.sunny.domain.DeviceSetting;
import cz.snyll.sunny.domain.DeviceStatus;
import cz.snyll.sunny.domain.Diverter;
import cz.snyll.sunny.domain.EmailNotification;
import cz.snyll.sunny.domain.MainSunnyConfiguration;
import cz.snyll.sunny.domain.SmartInverterAutomation;
import cz.snyll.sunny.domain.Trigger;
import cz.snyll.sunny.domain.inverter.Inverter;
import cz.snyll.sunny.repositories.CustomDashboardDataRepository;
import cz.snyll.sunny.repositories.DailyRecordRepository;
import cz.snyll.sunny.repositories.DeviceRepository;
import cz.snyll.sunny.repositories.DeviceSettingRepository;
import cz.snyll.sunny.repositories.DiverterRepository;
import cz.snyll.sunny.repositories.InverterRepository;
import cz.snyll.sunny.repositories.MainSunnyConfigurationRepository;
import cz.snyll.sunny.repositories.NotificationRepository;
import cz.snyll.sunny.repositories.SmartInverterAutomationRepository;
import cz.snyll.sunny.repositories.TriggerRepository;
import cz.snyll.sunny.services.database.ConfigurationExportImportService;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ConfigurationExportImportService {
    @Autowired
    private DeviceRepository deviceRepository;
    @Autowired
    private DeviceSettingRepository deviceSettingRepository;
    @Autowired
    private TriggerRepository triggerRepository;
    @Autowired
    private DiverterRepository diverterRepository;
    @Autowired
    private InverterRepository inverterRepository;
    @Autowired
    private SmartInverterAutomationRepository smartInverterAutomationRepository;
    @Autowired
    private NotificationRepository notificationRepository;
    @Autowired
    private MainSunnyConfigurationRepository mainConfigRepository;
    @Autowired
    private DailyRecordRepository dailyRecordRepository;
    @Autowired
    private CustomDashboardDataRepository customDashboardDataRepository;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public ConfigurationExportImportService() {
        this.objectMapper.registerModule((Module)new JavaTimeModule());
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Transactional(readOnly=true)
    public String exportConfiguration(String exportFilePath) throws IOException {
        ConfigurationExport export = new ConfigurationExport();
        export.setMainConfiguration(this.toList((Iterable)this.mainConfigRepository.findAll()));
        export.setDevices(this.toList(this.deviceRepository.findAll()));
        export.setDeviceSettings(this.toList(this.deviceSettingRepository.findAll()));
        export.setTriggers(this.toList(this.triggerRepository.findAll()));
        export.setDiverters(this.toList(this.diverterRepository.findAll()));
        export.setInverters(this.toList(this.inverterRepository.findAll()));
        export.setSmartInverterAutomations(this.toList(this.smartInverterAutomationRepository.findAll()));
        export.setEmailNotifications(this.toList(this.notificationRepository.findAll()));
        export.setDailyRecords(this.toList(this.dailyRecordRepository.findAll()));
        export.setCustomDashboardData((List)this.customDashboardDataRepository.findAllByOrderByDataOrder());
        export.setExportTimestamp(LocalDateTime.now());
        export.setExportVersion("1.0");
        File file = new File(exportFilePath);
        this.objectMapper.writerWithDefaultPrettyPrinter().writeValue(file, (Object)export);
        return exportFilePath;
    }

    @Transactional
    public void importConfiguration(String importFilePath, boolean clearExisting) throws IOException {
        File file = new File(importFilePath);
        ConfigurationExport importData = (ConfigurationExport)this.objectMapper.readValue(file, ConfigurationExport.class);
        if (clearExisting) {
            this.clearExistingConfiguration();
        }
        this.importTriggers(importData.getTriggers());
        this.importDeviceSettings(importData.getDeviceSettings());
        this.importDevices(importData.getDevices());
        this.importDiverters(importData.getDiverters());
        this.importInverters(importData.getInverters());
        this.importSmartInverterAutomations(importData.getSmartInverterAutomations());
        this.importEmailNotifications(importData.getEmailNotifications());
        this.importMainConfiguration(importData.getMainConfiguration());
        this.importCustomDashboardData(importData.getCustomDashboardData(), clearExisting);
        this.importDailyRecords(importData.getDailyRecords(), clearExisting);
    }

    @Transactional
    public void clearExistingConfiguration() {
        this.smartInverterAutomationRepository.deleteAll();
        this.notificationRepository.deleteAll();
        this.diverterRepository.deleteAll();
        this.deviceRepository.deleteAll();
        this.deviceSettingRepository.deleteAll();
        this.triggerRepository.deleteAll();
        this.inverterRepository.deleteAll();
        this.mainConfigRepository.deleteAll();
        this.customDashboardDataRepository.deleteAll();
        this.dailyRecordRepository.deleteAll();
    }

    private void importTriggers(List<Trigger> triggers) {
        if (triggers != null) {
            triggers.forEach(trigger -> trigger.setId(null));
            this.triggerRepository.saveAll(triggers);
        }
    }

    private void importDeviceSettings(List<DeviceSetting> deviceSettings) {
        if (deviceSettings != null) {
            deviceSettings.forEach(setting -> {
                setting.setId(null);
                if (setting.getTriggers() != null) {
                    setting.getTriggers().forEach(trigger -> {
                        List existingTriggers = this.toList(this.triggerRepository.findAll());
                        existingTriggers.stream().filter(t -> t.getTriggerName().equals(trigger.getTriggerName()) && t.getInfoDataKey().equals(trigger.getInfoDataKey()) && t.getInfoDataValue() == trigger.getInfoDataValue()).findFirst().ifPresent(existingTrigger -> trigger.setId(existingTrigger.getId()));
                    });
                }
            });
            this.deviceSettingRepository.saveAll(deviceSettings);
        }
    }

    private void importDevices(List<Device> devices) {
        if (devices != null) {
            devices.forEach(device -> {
                device.setId(null);
                if (device.getDeviceStatus() != null) {
                    device.getDeviceStatus().setId(null);
                    device.getDeviceStatus().setDevice(device);
                } else {
                    DeviceStatus defaultStatus = new DeviceStatus();
                    defaultStatus.setCurrentState(DeviceStatus.OperationStatus.OFF);
                    defaultStatus.setCurrentConsumption(0.0f);
                    defaultStatus.setTotalConsumption(0.0f);
                    defaultStatus.setTodayConsumption(0.0f);
                    defaultStatus.setTemperature(0.0f);
                    defaultStatus.setLastDayTotalConsumption(0.0f);
                    defaultStatus.setTodayRuntime(0L);
                    defaultStatus.setCurrentRuntime(0L);
                    defaultStatus.setManualOverride(false);
                    defaultStatus.setLastStateChange(LocalDateTime.now());
                    defaultStatus.setDevice(device);
                    device.setDeviceStatus(defaultStatus);
                }
                if (device.getDeviceSettings() != null) {
                    device.getDeviceSettings().forEach(setting -> {
                        List existingSettings = this.toList(this.deviceSettingRepository.findAll());
                        existingSettings.stream().filter(s -> s.getDeviceSettingName().equals(setting.getDeviceSettingName())).findFirst().ifPresent(existingSetting -> setting.setId(existingSetting.getId()));
                    });
                }
            });
            this.deviceRepository.saveAll(devices);
        }
    }

    private void importDiverters(List<Diverter> diverters) {
        if (diverters != null) {
            diverters.forEach(diverter -> {
                diverter.setId(null);
                if (diverter.getDiverterDevice() != null) {
                    List existingDevices = this.toList(this.deviceRepository.findAll());
                    existingDevices.stream().filter(d -> d.getDeviceName().equals(diverter.getDiverterDevice().getDeviceName())).findFirst().ifPresent(existingDevice -> diverter.setDiverterDevice(existingDevice));
                }
                this.relinkDeviceSettings(diverter.getDeviceSettings());
                this.relinkDeviceSettings(diverter.getDeviceSettingsHard());
            });
            this.diverterRepository.saveAll(diverters);
        }
    }

    private void importInverters(List<Inverter> inverters) {
        if (inverters != null) {
            inverters.forEach(inverter -> {
                inverter.setId(null);
                if (inverter.getConnectionDetails() != null) {
                    inverter.getConnectionDetails().setId(null);
                }
            });
            this.inverterRepository.saveAll(inverters);
        }
    }

    private void importSmartInverterAutomations(List<SmartInverterAutomation> automations) {
        if (automations != null) {
            automations.forEach(automation -> {
                automation.setId(null);
                if (automation.getInvertersApplied() != null) {
                    automation.getInvertersApplied().forEach(inverter -> {
                        List existingInverters = this.toList(this.inverterRepository.findAll());
                        existingInverters.stream().filter(i -> i.getInverterName().equals(inverter.getInverterName()) && i.getInverterSerialNumber().equals(inverter.getInverterSerialNumber())).findFirst().ifPresent(existingInverter -> inverter.setId(existingInverter.getId()));
                    });
                }
                if (automation.getChargeStartTime() == null) {
                    automation.setChargeStartTime(LocalTime.of(0, 0));
                }
                if (automation.getChargeEndTime() == null) {
                    automation.setChargeEndTime(LocalTime.of(23, 59));
                }
                if (automation.getExportLimitStartTime() == null) {
                    automation.setExportLimitStartTime(LocalTime.of(0, 0));
                }
                if (automation.getExportLimitEndTime() == null) {
                    automation.setExportLimitEndTime(LocalTime.of(23, 59));
                }
                if (automation.getForceDischargeStartTime() == null) {
                    automation.setForceDischargeStartTime(LocalTime.of(0, 0));
                }
                if (automation.getForceDischargeEndTime() == null) {
                    automation.setForceDischargeEndTime(LocalTime.of(23, 59));
                }
                this.relinkDeviceSettings(automation.getAutomationConditions());
            });
            this.smartInverterAutomationRepository.saveAll(automations);
        }
    }

    private void importEmailNotifications(List<EmailNotification> notifications) {
        if (notifications != null) {
            notifications.forEach(notification -> {
                notification.setId(null);
                this.relinkDeviceSettings(notification.getNotificationConditions());
            });
            this.notificationRepository.saveAll(notifications);
        }
    }

    private void importMainConfiguration(List<MainSunnyConfiguration> configurations) {
        if (configurations != null) {
            configurations.forEach(config -> config.setId(null));
            this.mainConfigRepository.saveAll(configurations);
        }
    }

    private void importCustomDashboardData(List<CustomDashboardData> dashboardData, boolean clearExisting) {
        if (dashboardData == null) {
            return;
        }
        if (clearExisting) {
            this.customDashboardDataRepository.deleteAll();
        }
        ArrayList existing = this.customDashboardDataRepository.findAllByOrderByDataOrder();
        for (CustomDashboardData item : dashboardData) {
            item.setId(null);
            CustomDashboardData match = existing.stream().filter(e -> this.safeEquals(e.getDataName(), item.getDataName()) && this.safeEquals(e.getDataInfoDataKey(), item.getDataInfoDataKey())).findFirst().orElse(null);
            if (match != null) {
                item.setId(match.getId());
            }
            this.customDashboardDataRepository.save((Object)item);
        }
    }

    private void importDailyRecords(List<DailyRecord> records, boolean clearExisting) {
        if (records == null) {
            return;
        }
        if (clearExisting) {
            this.dailyRecordRepository.deleteAll();
        }
        for (DailyRecord record : records) {
            DailyRecord existing = null;
            if (record.getDate() != null) {
                existing = this.dailyRecordRepository.findByDate(record.getDate());
            }
            if (existing != null) {
                record.setId(existing.getId());
            } else {
                record.setId(0L);
            }
            this.dailyRecordRepository.save((Object)record);
        }
    }

    private boolean safeEquals(String a, String b) {
        return a == null ? b == null : a.equals(b);
    }

    private void relinkDeviceSettings(Set<DeviceSetting> deviceSettings) {
        if (deviceSettings != null) {
            deviceSettings.forEach(setting -> {
                List existingSettings = this.toList(this.deviceSettingRepository.findAll());
                existingSettings.stream().filter(s -> s.getDeviceSettingName().equals(setting.getDeviceSettingName())).findFirst().ifPresent(existingSetting -> setting.setId(existingSetting.getId()));
            });
        }
    }

    private <T> List<T> toList(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList());
    }
}

