/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.collectors.otherinfocollectors;

import cz.snyll.sunny.convenience.NicePrinter;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.SunnyConfigurationService;
import cz.snyll.sunny.services.collectors.DataCollectorAbstractService;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import org.shredzone.commons.suncalc.SunTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class DuskDawnCollector
extends DataCollectorAbstractService {
    private static final Logger log = LoggerFactory.getLogger(DuskDawnCollector.class);
    private final SunnyConfigurationService sunnyConfigurationService;

    @Autowired
    public DuskDawnCollector(InfoDataManagerService infoDataManagerService, SunnyConfigurationService sunnyConfigurationService) {
        super(infoDataManagerService);
        this.sunnyConfigurationService = sunnyConfigurationService;
    }

    @Scheduled(fixedDelay=600000L)
    public void scheduledCollection() {
        this.collectData();
    }

    public HashMap<String, Map.Entry<String, String>> collectData() {
        try {
            double longitude = Double.parseDouble(this.sunnyConfigurationService.getSetting("longitude"));
            double latitude = Double.parseDouble(this.sunnyConfigurationService.getSetting("latitude"));
            ZoneId zoneId = ZoneId.systemDefault();
            ZonedDateTime dateTime = ZonedDateTime.now(zoneId);
            NicePrinter.nicePrint((String)("Calculating dusk and dawn from data: lat=" + latitude + "; long=" + longitude + "; time: " + dateTime.toLocalDateTime().toString()), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            SunTimes sunTimes = (SunTimes)((SunTimes.Parameters)((SunTimes.Parameters)((SunTimes.Parameters)SunTimes.compute().on(dateTime)).at(latitude, longitude)).timezone(zoneId)).fullCycle().execute();
            HashMap<String, Map.Entry<String, String>> dataMap = new HashMap<String, Map.Entry<String, String>>();
            ZonedDateTime localDawn = sunTimes.getRise();
            ZonedDateTime localDusk = sunTimes.getSet();
            if (localDawn != null && localDusk != null) {
                String dawnTimeRounded = localDawn.toLocalTime().truncatedTo(ChronoUnit.SECONDS).toString();
                String duskTimeRounded = localDusk.toLocalTime().truncatedTo(ChronoUnit.SECONDS).toString();
                dataMap.put("today_dusk_time", new AbstractMap.SimpleEntry<String, String>(duskTimeRounded, ""));
                dataMap.put("today_dawn_time", new AbstractMap.SimpleEntry<String, String>(dawnTimeRounded, ""));
            }
            this.saveinfodata(dataMap);
            return dataMap;
        }
        catch (Exception e) {
            NicePrinter.nicePrint((String)"DuskDawnCollector: latitude or longitude is probably not set. Please set it in the settings.", (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            return new HashMap<String, Map.Entry<String, String>>();
        }
    }
}

