/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.collectors.otherinfocollectors;

import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.collectors.DataCollectorAbstractService;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class DeviceLoadCollector
extends DataCollectorAbstractService {
    private final OperatingSystemMXBean osBean;

    protected DeviceLoadCollector(InfoDataManagerService infoDataManagerService) {
        super(infoDataManagerService);
        OperatingSystemMXBean tmpBean = null;
        try {
            tmpBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
        }
        catch (Throwable ex) {
            System.err.println("Warning: Cannot initialize OperatingSystemMXBean: " + ex.getMessage());
        }
        this.osBean = tmpBean;
    }

    public HashMap<String, Map.Entry<String, String>> collectData() {
        HashMap<String, Map.Entry<String, String>> dataMap = new HashMap<String, Map.Entry<String, String>>();
        Runtime runtime = Runtime.getRuntime();
        long totalMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        long usedMemory = totalMemory - freeMemory;
        long maxMemory = runtime.maxMemory();
        dataMap.put("system_total_memory", new AbstractMap.SimpleEntry<String, String>(String.valueOf(Math.round((double)totalMemory / 1024.0 / 1024.0)), "MB"));
        dataMap.put("system_free_memory", new AbstractMap.SimpleEntry<String, String>(String.valueOf(Math.round((double)freeMemory / 1024.0 / 1024.0)), "MB"));
        dataMap.put("system_used_memory", new AbstractMap.SimpleEntry<String, String>(String.valueOf(Math.round((double)usedMemory / 1024.0 / 1024.0)), "MB"));
        dataMap.put("system_max_memory", new AbstractMap.SimpleEntry<String, String>(String.valueOf(Math.round((double)maxMemory / 1024.0 / 1024.0)), "MB"));
        dataMap.put("system_available_cpus", new AbstractMap.SimpleEntry<String, String>(String.valueOf(runtime.availableProcessors()), ""));
        dataMap.put("system_architecture", new AbstractMap.SimpleEntry<String, String>(this.osBean != null ? String.valueOf(this.osBean.getArch()) : "unknown", ""));
        double systemCpuLoad = this.osBean != null ? this.osBean.getSystemLoadAverage() : -1.0;
        systemCpuLoad = (double)Math.round(systemCpuLoad * 100.0 * 10.0) / 10.0;
        String cpuLoadString = systemCpuLoad < 0.0 ? "n/a" : String.valueOf(systemCpuLoad);
        dataMap.put("system_cpu_load", new AbstractMap.SimpleEntry<String, String>(cpuLoadString, "%"));
        this.saveinfodata(dataMap);
        return dataMap;
    }
}

