/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.collectors.otherinfocollectors;

import cz.snyll.sunny.domain.InfoData;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.collectors.DataCollectorAbstractService;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class DataCollectorDayMonth
extends DataCollectorAbstractService {
    InfoDataManagerService infoDataManagerService;

    @Autowired
    public DataCollectorDayMonth(InfoDataManagerService infoDataManagerService) {
        super(infoDataManagerService);
    }

    @Scheduled(cron="* * * * * *")
    public void scheduledCollection() {
        this.collectData();
    }

    public HashMap<String, Map.Entry<String, String>> collectData() {
        LocalDate date = LocalDate.now();
        LocalTime time = LocalTime.now();
        int month = date.getMonthValue();
        int dayOfWeek = date.getDayOfWeek().getValue();
        int dayOfMonth = date.getDayOfMonth();
        int hour = time.getHour();
        int minute = time.getMinute();
        int second = time.getSecond();
        this.saveinfodata(new InfoData("date_day_of_the_month", Integer.toString(dayOfMonth), "", 88000));
        this.saveinfodata(new InfoData("date_day_of_the_week", Integer.toString(dayOfWeek), "", 88000));
        this.saveinfodata(new InfoData("date_month_of_the_year", Integer.toString(month), "", 88000));
        this.saveinfodata(new InfoData("time_hour_of_the_day", Integer.toString(hour), "h", 88000));
        this.saveinfodata(new InfoData("time_minute_of_the_hour", Integer.toString(minute), "m", 88000));
        this.saveinfodata(new InfoData("time_second_of_the_minute", Integer.toString(second), "s", 88000));
        return new HashMap<String, Map.Entry<String, String>>();
    }
}

