/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.collectors.inverterCollectors;

import cz.snyll.sunny.domain.InfoData;
import cz.snyll.sunny.domain.inverter.Inverter;
import cz.snyll.sunny.services.InfoDataManagerService;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SolaxCalculateValues {
    private static final Logger log = LoggerFactory.getLogger(SolaxCalculateValues.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void calculateValues(HashMap<String, Map.Entry<String, String>> dataMap, InfoDataManagerService infoDataManagerService, Inverter inverter) {
        Inverter inverter2 = inverter;
        synchronized (inverter2) {
            SolaxCalculateValues.performCalculations(dataMap, (InfoDataManagerService)infoDataManagerService, (Inverter)inverter);
        }
    }

    private static void performCalculations(HashMap<String, Map.Entry<String, String>> dataMap, InfoDataManagerService infoDataManagerService, Inverter inverter) {
        InfoData wallboxPower;
        float inverterRunMode;
        if (dataMap.get("solax_acpower") == null) {
            float power1 = SolaxCalculateValues.parseFloat((String)((String)((Map.Entry)dataMap.getOrDefault("solax_power_now_phase_1", new AbstractMap.SimpleEntry<String, String>("0", "W"))).getKey()));
            float power2 = SolaxCalculateValues.parseFloat((String)((String)((Map.Entry)dataMap.getOrDefault("solax_power_now_phase_2", new AbstractMap.SimpleEntry<String, String>("0", "W"))).getKey()));
            float power3 = SolaxCalculateValues.parseFloat((String)((String)((Map.Entry)dataMap.getOrDefault("solax_power_now_phase_3", new AbstractMap.SimpleEntry<String, String>("0", "W"))).getKey()));
            dataMap.put("solax_acpower", new AbstractMap.SimpleEntry<String, String>(String.valueOf(power1 + power2 + power3), "W"));
            if (log.isInfoEnabled()) {
                log.debug("Calculating total AC power: Phase 1 = {}, Phase 2 = {}, Phase 3 = {}", new Object[]{Float.valueOf(power1), Float.valueOf(power2), Float.valueOf(power3)});
            }
        }
        if ((inverterRunMode = SolaxCalculateValues.parseFloat((String)((String)((Map.Entry)dataMap.getOrDefault("solax_inverter_runmode", new AbstractMap.SimpleEntry<String, String>("2", ""))).getKey()))) == 7.0f) {
            float consumption1Now = SolaxCalculateValues.parseFloat((String)((String)((Map.Entry)dataMap.getOrDefault("solax_eps_x3_power_phase1", new AbstractMap.SimpleEntry<String, String>("0", "W"))).getKey()));
            float consumption2Now = SolaxCalculateValues.parseFloat((String)((String)((Map.Entry)dataMap.getOrDefault("solax_eps_x3_power_phase2", new AbstractMap.SimpleEntry<String, String>("0", "W"))).getKey()));
            float consumption3Now = SolaxCalculateValues.parseFloat((String)((String)((Map.Entry)dataMap.getOrDefault("solax_eps_x3_power_phase3", new AbstractMap.SimpleEntry<String, String>("0", "W"))).getKey()));
            dataMap.put("solax_acpower", new AbstractMap.SimpleEntry<String, String>(String.valueOf(consumption1Now + consumption2Now + consumption3Now), "W"));
            if (log.isInfoEnabled()) {
                log.debug("Calculating total consumption now: Consumption Phase 1 = {}, Phase 2 = {}, Phase 3 = {}", new Object[]{Float.valueOf(consumption1Now), Float.valueOf(consumption2Now), Float.valueOf(consumption3Now)});
            }
        }
        float pVpower1 = SolaxCalculateValues.parseFloat((String)((String)((Map.Entry)dataMap.getOrDefault("solax_solar_panels_power_1", new AbstractMap.SimpleEntry<String, String>("0", "W"))).getKey()));
        float pVpower2 = SolaxCalculateValues.parseFloat((String)((String)((Map.Entry)dataMap.getOrDefault("solax_solar_panels_power_2", new AbstractMap.SimpleEntry<String, String>("0", "W"))).getKey()));
        float pVpower3 = SolaxCalculateValues.parseFloat((String)((String)((Map.Entry)dataMap.getOrDefault("solax_solar_panels_power_3", new AbstractMap.SimpleEntry<String, String>("0", "W"))).getKey()));
        dataMap.put("solax_solar_panels_power_total", new AbstractMap.SimpleEntry<String, String>(String.valueOf(pVpower1 + pVpower2 + pVpower3), "W"));
        if (log.isInfoEnabled()) {
            log.debug("Calculating total power from panels: Panel 1 = {}, Panel 2 = {}, Panel 3 = {}", new Object[]{Float.valueOf(pVpower1), Float.valueOf(pVpower2), Float.valueOf(pVpower3)});
        }
        float exportedPower = SolaxCalculateValues.parseFloat((String)((String)((Map.Entry)dataMap.getOrDefault("solax_exported_power", new AbstractMap.SimpleEntry<String, String>("0", "W"))).getKey()));
        dataMap.put("solax_grid_consumption", new AbstractMap.SimpleEntry<String, String>(Integer.toString(Math.round(Math.abs(exportedPower))), "W"));
        if (log.isInfoEnabled()) {
            log.debug("Calculating grid consumption from exported power: {}", (Object)Float.valueOf(exportedPower));
        }
        float wbPower = (wallboxPower = infoDataManagerService.findByDataKey("wallbox_charge_power_total")) != null ? SolaxCalculateValues.parseFloat((String)wallboxPower.getDataValue()) : 0.0f;
        float meter2Power = SolaxCalculateValues.parseFloat((String)((String)((Map.Entry)dataMap.getOrDefault("solax_meter2_power", new AbstractMap.SimpleEntry<String, String>("0", "W"))).getKey()));
        float acPower = SolaxCalculateValues.parseFloat((String)((String)((Map.Entry)dataMap.getOrDefault("solax_acpower", new AbstractMap.SimpleEntry<String, String>("0", "W"))).getKey()));
        float consumptionCounted = acPower + meter2Power - wbPower - exportedPower;
        if (consumptionCounted + wbPower < wbPower) {
            consumptionCounted += wbPower;
        }
        dataMap.put("solax_power_consumption_now", new AbstractMap.SimpleEntry<String, String>(Float.toString(consumptionCounted), "W"));
        if (log.isInfoEnabled()) {
            log.debug("Wallbox power value used in consumption calculations: {}", (Object)Float.valueOf(wbPower));
            log.debug("Meter 2 power adjustments: Meter 2 Power = {}, Adjusted Consumption = {}", (Object)Float.valueOf(meter2Power), (Object)Float.valueOf(consumptionCounted));
        }
        float todayOffGridYield = SolaxCalculateValues.parseFloat((String)((String)((Map.Entry)dataMap.getOrDefault("solax_today_offgrid_ac_energy", new AbstractMap.SimpleEntry<String, String>("0", "kWh"))).getKey()));
        float todayYield = SolaxCalculateValues.parseFloat((String)((String)((Map.Entry)dataMap.getOrDefault("solax_today_yield", new AbstractMap.SimpleEntry<String, String>("0", "kWh"))).getKey()));
        dataMap.put("solax_today_yield_including_offgrid", new AbstractMap.SimpleEntry<String, String>(Float.toString(todayYield + todayOffGridYield), "kWh"));
        if (log.isInfoEnabled()) {
            log.debug("Calculating today's yield including off-grid value: Today's Yield = {}, Off-grid Yield = {}", (Object)Float.valueOf(todayYield), (Object)Float.valueOf(todayOffGridYield));
        }
        float totalOffGridYield = SolaxCalculateValues.parseFloat((String)((String)((Map.Entry)dataMap.getOrDefault("solax_total_offgrid_ac_energy", new AbstractMap.SimpleEntry<String, String>("0", "kWh"))).getKey()));
        float totalYield = SolaxCalculateValues.parseFloat((String)((String)((Map.Entry)dataMap.getOrDefault("solax_total_energy", new AbstractMap.SimpleEntry<String, String>("0", "kWh"))).getKey()));
        dataMap.put("solax_total_yield_including_offgrid", new AbstractMap.SimpleEntry<String, String>(Float.toString(totalYield + totalOffGridYield), "kWh"));
        if (log.isInfoEnabled()) {
            log.debug("Calculating total yield including off-grid value: Total Yield = {}, Off-grid total Yield = {}", (Object)Float.valueOf(totalYield), (Object)Float.valueOf(totalOffGridYield));
        }
        float totalConsumption = SolaxCalculateValues.parseFloat((String)((String)((Map.Entry)dataMap.getOrDefault("solax_total_consumption", new AbstractMap.SimpleEntry<String, String>("0", "W"))).getKey()));
        float totalFeedin = SolaxCalculateValues.parseFloat((String)((String)((Map.Entry)dataMap.getOrDefault("solax_total_feedin_energy", new AbstractMap.SimpleEntry<String, String>("0", "W"))).getKey()));
        InfoData lastTotalFeedinID = infoDataManagerService.getInfoDataForInverter(inverter, "last_total_feedin");
        float lastTotalFeedin = lastTotalFeedinID != null ? lastTotalFeedinID.floatValue().floatValue() : 0.0f;
        InfoData lastTotalConsumptionID = infoDataManagerService.getInfoDataForInverter(inverter, "last_total_consumption");
        float lastTotalConsumption = lastTotalConsumptionID != null ? lastTotalConsumptionID.floatValue().floatValue() : 0.0f;
        dataMap.computeIfAbsent("solax_today_feedin_energy", k -> new AbstractMap.SimpleEntry<String, String>(Float.toString(totalFeedin - lastTotalFeedin), "kWh"));
        if (log.isInfoEnabled()) {
            log.debug("Handling total consumption and feed-in adjustments: Last Total Consumption = {}, Last Total Feedin = {}", (Object)Float.valueOf(lastTotalConsumption), (Object)Float.valueOf(lastTotalFeedin));
        }
        dataMap.computeIfAbsent("solax_today_consumption", k -> new AbstractMap.SimpleEntry<String, String>(String.valueOf(totalConsumption - lastTotalConsumption + todayOffGridYield), "kWh"));
        float meter2TotalProduction = SolaxCalculateValues.parseFloat((String)((String)((Map.Entry)dataMap.getOrDefault("solax_meter2_total_production", new AbstractMap.SimpleEntry<String, String>("0", "W"))).getKey()));
        float meter2TodayProduction = 0.0f;
        if (meter2TotalProduction > 0.0f) {
            InfoData meter2Data = infoDataManagerService.getInfoDataForInverter(inverter, "last_meter2_total_production");
            float lastMeter2TotalProduction = 0.0f;
            if (meter2Data != null && !meter2Data.getDataValue().isEmpty()) {
                lastMeter2TotalProduction = SolaxCalculateValues.parseFloat((String)meter2Data.getDataValue());
            } else {
                InfoData fallbackData = infoDataManagerService.findByDataKey("last_meter2_total_production");
                if (fallbackData != null && !fallbackData.getDataValue().isEmpty()) {
                    lastMeter2TotalProduction = SolaxCalculateValues.parseFloat((String)fallbackData.getDataValue());
                }
            }
            meter2TodayProduction = meter2TotalProduction - lastMeter2TotalProduction;
            dataMap.put("solax_today_meter2_production", new AbstractMap.SimpleEntry<String, String>(String.valueOf(meter2TodayProduction), "kWh"));
            if (log.isInfoEnabled()) {
                log.debug("Calculating meter2 today's production: Last Meter 2 Production = {}, Today's Production = {}", (Object)Float.valueOf(lastMeter2TotalProduction), (Object)Float.valueOf(meter2TodayProduction));
            }
        }
        float todayExport = SolaxCalculateValues.parseFloat((String)((String)((Map.Entry)dataMap.getOrDefault("solax_today_feedin_energy", new AbstractMap.SimpleEntry<String, String>("0", "kWh"))).getKey()));
        dataMap.put("solax_today_self_consumed_yield", new AbstractMap.SimpleEntry<String, String>(String.valueOf(todayYield + meter2TodayProduction - todayExport + todayOffGridYield), "kWh"));
        float todayGridToBattery = SolaxCalculateValues.parseFloat((String)((String)((Map.Entry)dataMap.getOrDefault("solax_today_battery_grid_charge_energy", new AbstractMap.SimpleEntry<String, String>("0", "kWh"))).getKey()));
        float todayImport = SolaxCalculateValues.parseFloat((String)((String)((Map.Entry)dataMap.getOrDefault("solax_today_consumption", new AbstractMap.SimpleEntry<String, String>("0", "kWh"))).getKey()));
        dataMap.put("solax_today_grid_to_house", new AbstractMap.SimpleEntry<String, String>(String.valueOf(todayImport - todayGridToBattery), "kWh"));
        if (log.isInfoEnabled()) {
            log.debug("Final consumption and yield values: Self-consumed Yield = {}", (Object)dataMap.get("solax_today_self_consumed_yield").getKey());
        }
        SolaxCalculateValues.resetDailyValues(dataMap, (InfoDataManagerService)infoDataManagerService, (float)totalConsumption, (float)totalFeedin, (Inverter)inverter);
    }

    public static void resetDailyValues(HashMap<String, Map.Entry<String, String>> dataMap, InfoDataManagerService infoDataManagerService, float totalConsumption, float totalFeedin, Inverter inverter) {
        LocalDate today = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String formattedDate = today.format(formatter);
        InfoData restartedDay = infoDataManagerService.getInfoDataForInverter(inverter, "daily_yields_restarted");
        if (restartedDay == null || !restartedDay.getDataValue().equals(formattedDate)) {
            if (log.isInfoEnabled()) {
                log.debug("Resetting daily yields restarted values.");
            }
            SolaxCalculateValues.resetDailyValues(dataMap, (String)formattedDate, (float)totalConsumption, (float)totalFeedin, (Inverter)inverter);
        }
    }

    public static void resetDailyValues(Map<String, Map.Entry<String, String>> dataMap, String formattedDate, float totalConsumption, float totalFeedin, Inverter inverter) {
        dataMap.put("daily_yields_restarted", new AbstractMap.SimpleEntry<String, String>(formattedDate, "-"));
        dataMap.put("solax_today_feedin_energy", new AbstractMap.SimpleEntry<String, String>("0", "kWh"));
        dataMap.put("solax_today_consumption", new AbstractMap.SimpleEntry<String, String>("0", "kWh"));
        dataMap.put("last_total_consumption", new AbstractMap.SimpleEntry<String, String>(String.valueOf(totalConsumption), "kWh"));
        dataMap.put("last_total_feedin", new AbstractMap.SimpleEntry<String, String>(String.valueOf(totalFeedin), "kWh"));
    }

    private static float toSigned(float val) {
        if (val > 32767.0f) {
            return val - 65535.0f;
        }
        return val;
    }

    private static float parseFloat(String value) {
        try {
            return value != null ? Float.parseFloat(value) : 0.0f;
        }
        catch (NumberFormatException e) {
            log.warn("Could not convert value: {} to float.", (Object)value);
            return 0.0f;
        }
    }
}

