/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.collectors.inverterCollectors;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import cz.snyll.sunny.config.RestConfig;
import cz.snyll.sunny.convenience.NicePrinter;
import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.domain.inverter.CloudApiDetails;
import cz.snyll.sunny.repositories.InverterRepository;
import cz.snyll.sunny.services.EventEntryManagerService;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.InverterCollectorAbstractService;
import cz.snyll.sunny.services.SunnyConfigurationService;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service
@Scope(value="prototype")
public class DataCollectorSolaxCloud
extends InverterCollectorAbstractService {
    @Autowired
    private SunnyConfigurationService sunnyConfigurationService;
    @Autowired
    private EventEntryManagerService eventEntryManagerService;
    @Autowired
    private RestConfig restConfig;

    @Autowired
    public DataCollectorSolaxCloud(InfoDataManagerService infoDataManagerService, InverterRepository inverterRepository) {
        super(infoDataManagerService, inverterRepository);
    }

    public HashMap<String, Map.Entry<String, String>> collectData() {
        CloudApiDetails cloudApiDetails = (CloudApiDetails)this.inverter.getConnectionDetails();
        String token = cloudApiDetails.getCloudApiKey();
        if (token == null || token.isEmpty()) {
            return new HashMap<String, Map.Entry<String, String>>();
        }
        String apiUrl = cloudApiDetails.getCloudUrl();
        String wifiSn = cloudApiDetails.getWifiDongleCode();
        HashMap dataMap = new HashMap();
        RestTemplate restTemplate = this.restConfig.restTemplate();
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)(apiUrl + "getRealtimeInfo.do")).queryParam("tokenId", new Object[]{token}).queryParam("sn", new Object[]{wifiSn});
        HttpHeaders headers = new HttpHeaders();
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = null;
        try {
            response = restTemplate.exchange(builder.toUriString(), HttpMethod.GET, entity, String.class, new Object[0]);
        }
        catch (HttpClientErrorException e) {
            NicePrinter.nicePrint((String)"Solax API cloud url is probably wrong. Could not load API data.", (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            return dataMap;
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode jsonResponse = mapper.readTree((String)response.getBody()).get("result");
            dataMap.put((String)"solax_solar_panels_power_1", new AbstractMap.SimpleEntry<String, String>(jsonResponse.get("powerdc1").toString(), "W"));
            dataMap.put((String)"solax_solar_panels_power_2", new AbstractMap.SimpleEntry<String, String>(jsonResponse.get("powerdc2").toString(), "W"));
            dataMap.put((String)"solax_battery_remaining_capacity", new AbstractMap.SimpleEntry<String, String>(jsonResponse.get("soc").toString(), "%"));
            dataMap.put((String)"solax_today_self_consumed_yield", new AbstractMap.SimpleEntry<String, String>(jsonResponse.get("yieldtoday").toString(), "kWh"));
            dataMap.put((String)"solax_total_consumption", new AbstractMap.SimpleEntry<String, String>(jsonResponse.get("consumeenergy").toString(), "kWh"));
            dataMap.put((String)"solax_total_feedin_energy", new AbstractMap.SimpleEntry<String, String>(jsonResponse.get("feedinenergy").toString(), "kWh"));
            dataMap.put((String)"solax_total_energy", new AbstractMap.SimpleEntry<String, String>(jsonResponse.get("yieldtotal").toString(), "kWh"));
            dataMap.put((String)"solax_acpower", new AbstractMap.SimpleEntry<String, String>(jsonResponse.get("acpower").toString(), "W"));
            dataMap.put((String)"solax_solar_panels_power_total", new AbstractMap.SimpleEntry<String, String>(Float.toString(Float.parseFloat(dataMap.get("solax_solar_panels_power_1").getKey()) + Float.parseFloat(dataMap.get("solax_solar_panels_power_2").getKey())), "W"));
            dataMap.put((String)"solax_battery_power", new AbstractMap.SimpleEntry<String, String>(jsonResponse.get("batPower").toString(), "W"));
            dataMap.put((String)"solax_exported_power", new AbstractMap.SimpleEntry<String, String>(Float.toString(Math.negateExact((long)Float.parseFloat(jsonResponse.get("feedinpower").toString()))), "W"));
            Float acPower = Float.valueOf(Float.parseFloat(jsonResponse.get("acpower").toString()));
            Float feedinPower = Float.valueOf(Float.parseFloat(jsonResponse.get("feedinpower").toString()));
            float currentConsumption = acPower.floatValue() - feedinPower.floatValue();
            dataMap.put((String)"solax_power_consumption_now", new AbstractMap.SimpleEntry<String, String>(Float.toString(Math.abs(currentConsumption)), "W"));
            dataMap = this.prependInverterId(dataMap);
            this.saveinfodata(dataMap);
            return dataMap;
        }
        catch (Exception e) {
            this.eventEntryManagerService.raiseEvent("SOLAX CLOUD: Issue loading Solax Cloud data. Error: " + e.getMessage(), EventEntry.EventType.ERROR, 60);
            return dataMap;
        }
    }
}

