/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.collectors.inverterCollectors;

import cz.snyll.sunny.config.InverterMap;
import cz.snyll.sunny.convenience.NicePrinter;
import cz.snyll.sunny.domain.inverter.Inverter;
import cz.snyll.sunny.invertermaps.InverterMappingConfigurationFactory;
import cz.snyll.sunny.repositories.InverterRepository;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.InverterCollectorAbstractService;
import cz.snyll.sunny.services.SunnyConfigurationService;
import cz.snyll.sunny.services.collectors.inverterCollectors.SolaxCalculateValues;
import cz.snyll.sunny.services.modbus.ModbusServiceFactory;
import cz.snyll.sunny.services.modbus.ModbusServiceInterface;
import java.lang.invoke.CallSite;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class DataCollectorInverterSolaxModbus
extends InverterCollectorAbstractService {
    private static final Logger log = LoggerFactory.getLogger(DataCollectorInverterSolaxModbus.class);
    private final ModbusServiceFactory modbusServiceFactory;
    private final SunnyConfigurationService sunnyConfigurationService;
    private final InfoDataManagerService infoDataManagerService;
    private final InverterRepository inverterRepository;
    private final InverterMappingConfigurationFactory inverterMappingConfigurationFactory;

    @Autowired
    public DataCollectorInverterSolaxModbus(SunnyConfigurationService sunnyConfigurationService, InfoDataManagerService infoDataManagerService, InverterMappingConfigurationFactory inverterMappingConfigurationFactory, ModbusServiceFactory modbusServiceFactory, InverterRepository inverterRepository) {
        super(infoDataManagerService, inverterRepository);
        this.modbusServiceFactory = modbusServiceFactory;
        this.sunnyConfigurationService = sunnyConfigurationService;
        this.infoDataManagerService = infoDataManagerService;
        this.inverterRepository = inverterRepository;
        this.inverterMappingConfigurationFactory = inverterMappingConfigurationFactory;
    }

    public HashMap<String, Map.Entry<String, String>> collectData() {
        if (this.inverter == null) {
            NicePrinter.nicePrint((String)("Inverter is null, not collecting data on instance " + this), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            return new HashMap<String, Map.Entry<String, String>>();
        }
        try {
            HashMap dataMap = new HashMap();
            ModbusServiceInterface modbusService = this.modbusServiceFactory.getModbusService(this.inverter);
            if (modbusService == null) {
                NicePrinter.nicePrint((String)"Modbus service is null, not collecting data.", (String)this.sunnyConfigurationService.getSetting("debug_mode"));
                return null;
            }
            ArrayList allInputRegisters = (ArrayList)modbusService.readAllInputRegisters();
            ArrayList allHoldingRegisters = modbusService.readAllHoldingRegisters();
            if (allInputRegisters.isEmpty()) {
                NicePrinter.nicePrint((String)"Modbus input registers are empty, not collecting data.", (String)this.sunnyConfigurationService.getSetting("debug_mode"));
                return null;
            }
            if (allHoldingRegisters.isEmpty()) {
                NicePrinter.nicePrint((String)"Modbus holding registers are empty, not collecting data.", (String)this.sunnyConfigurationService.getSetting("debug_mode"));
                return null;
            }
            NicePrinter.nicePrint((String)("Modbus input registers: " + allInputRegisters), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            NicePrinter.nicePrint((String)("Modbus holding registers: " + allHoldingRegisters), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            Map modbusMapperString = this.inverterMappingConfigurationFactory.getInverterConfig(this.inverter.getInverterSerialNumber(), this.inverter.getConnectionDetails().getCommunicationType()).getInverterMap();
            Map modbusMapperStringHolding = this.inverterMappingConfigurationFactory.getInverterSettingsConfig(this.inverter.getInverterSerialNumber(), this.inverter.getConnectionDetails().getCommunicationType()).getInverterMap();
            HashMap modbusMapper = this.getFinalMap(modbusMapperString);
            HashMap modbusMapperHolding = this.getFinalMap(modbusMapperStringHolding);
            for (int registerAddress = 0; registerAddress < allHoldingRegisters.size(); ++registerAddress) {
                int registerValue = (Integer)allHoldingRegisters.get(registerAddress);
                float finalValue = 0.0f;
                Map.Entry entry = this.getMapEntry(modbusMapperHolding, registerAddress);
                if (entry == null) continue;
                String key = (String)entry.getKey();
                InverterMap map = (InverterMap)entry.getValue();
                if (map.getLength() > 1 && map.getDataType().equals("chars")) {
                    ArrayList<Integer> registerList = new ArrayList<Integer>();
                    for (int i = 0; i < map.getLength(); ++i) {
                        registerList.add((Integer)allHoldingRegisters.get(registerAddress + i));
                    }
                    String charValue = this.decodeRegisters(registerList);
                    dataMap.put(key, new AbstractMap.SimpleEntry<String, String>(charValue, ""));
                    continue;
                }
                finalValue = this.getFinalValue(allHoldingRegisters, registerAddress, registerValue, finalValue, map);
                if (map.getDataType().equals("uint8(Hi)")) {
                    finalValue = registerValue >> 8 & 0xFF;
                }
                if (map.getDataType().equals("uint8(Lo)")) {
                    finalValue = registerValue & 0xFF;
                }
                finalValue *= map.getModifier();
                if (registerAddress != map.getAddress()) continue;
                dataMap.put(key, new AbstractMap.SimpleEntry<String, String>(Float.toString(finalValue), map.getUnit()));
            }
            float armMajor = 0.0f;
            if (dataMap.get("solax_inverter_arm_version_major") != null) {
                armMajor = Optional.ofNullable((Map.Entry)dataMap.get("solax_inverter_arm_version_major")).map(Map.Entry::getKey).map(Float::parseFloat).orElse(Float.valueOf(0.0f)).floatValue();
            }
            float armMinor = 0.0f;
            if (dataMap.get("solax_inverter_arm_version_minor") != null) {
                armMinor = Optional.ofNullable((Map.Entry)dataMap.get("solax_inverter_arm_version_minor")).map(Map.Entry::getKey).map(Float::parseFloat).orElse(Float.valueOf(0.0f)).floatValue();
            }
            float dspMajor = 0.0f;
            if (dataMap.get("solax_inverter_dsp_version_major") != null) {
                dspMajor = Optional.ofNullable((Map.Entry)dataMap.get("solax_inverter_dsp_version_major")).map(Map.Entry::getKey).map(Float::parseFloat).orElse(Float.valueOf(0.0f)).floatValue();
            }
            float dspMinor = 0.0f;
            if (dataMap.get("solax_inverter_dsp_version_minor") != null) {
                dspMinor = Optional.ofNullable((Map.Entry)dataMap.get("solax_inverter_dsp_version_minor")).map(Map.Entry::getKey).map(Float::parseFloat).orElse(Float.valueOf(0.0f)).floatValue();
            }
            dataMap.put("solax_inverter_arm_version", new AbstractMap.SimpleEntry<CallSite, String>((CallSite)((Object)((int)armMajor + "." + (int)armMinor)), ""));
            dataMap.put("solax_inverter_dsp_version", new AbstractMap.SimpleEntry<CallSite, String>((CallSite)((Object)((int)dspMajor + "." + (int)dspMinor)), ""));
            int MAX_REGISTERS = 288;
            for (int registerAddress = 0; registerAddress < MAX_REGISTERS; ++registerAddress) {
                int registerValue = (Integer)allInputRegisters.get(registerAddress);
                float finalValue = 0.0f;
                Map.Entry entry = this.getMapEntry(modbusMapper, registerAddress);
                if (entry == null || registerAddress == MAX_REGISTERS - 1 && ((InverterMap)entry.getValue()).getLength() > 1) continue;
                String key = (String)entry.getKey();
                InverterMap map = (InverterMap)entry.getValue();
                finalValue = this.getFinalValue(allInputRegisters, registerAddress, registerValue, finalValue, map);
                finalValue *= map.getModifier();
                if (registerAddress != map.getAddress()) continue;
                dataMap.put(key, new AbstractMap.SimpleEntry<String, String>(Float.toString(finalValue), map.getUnit()));
            }
            SolaxCalculateValues.calculateValues(dataMap, (InfoDataManagerService)this.infoDataManagerService, (Inverter)this.inverter);
            dataMap = this.prependInverterId(dataMap);
            this.saveinfodata(dataMap);
            return dataMap;
        }
        catch (Exception e) {
            log.error("An error occurred during the data collection process: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private float getFinalValue(ArrayList<Integer> allHoldingRegisters, int registerAddress, int registerValue, float finalValue, InverterMap map) {
        int nextValue;
        if (map.getDataType().equals("uint16")) {
            finalValue = registerValue;
        }
        if (map.getDataType().equals("int16")) {
            finalValue = this.modbusInt16ToJavaInt(registerValue);
        }
        if (map.getDataType().equals("int32") && map.getLength() == 2) {
            nextValue = allHoldingRegisters.get(registerAddress + 1);
            finalValue = this.modbusInt32ToJavaInt(registerValue, nextValue);
        }
        if (map.getDataType().equals("uint32") && map.getLength() == 2) {
            nextValue = allHoldingRegisters.get(registerAddress + 1);
            finalValue = this.modbusUInt32ToJavaLong(registerValue, nextValue);
        }
        return finalValue;
    }

    public void setInverter(Inverter inverter) {
        this.inverter = inverter;
        NicePrinter.nicePrint((String)("Setting inverter: " + inverter + "; on instance: " + this), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
    }
}

