/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.collectors.energyPricesCollectors;

import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.services.EventEntryManagerService;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.SunnyConfigurationService;
import cz.snyll.sunny.services.collectors.energyPricesCollectors.DataCollectorEnergyPricesCs;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class DataCollectorEnergyPricesManager {
    private final SunnyConfigurationService sunnyConfigurationService;
    private final DataCollectorEnergyPricesCs dataCollectorEnergyPricesCs;
    private final String energyPricesService;
    public final List<String> energyPricesServices = new ArrayList();
    private final EventEntryManagerService eventEntryManagerService;
    private final InfoDataManagerService infoDataManagerService;

    @Autowired
    public DataCollectorEnergyPricesManager(EventEntryManagerService eventEntryManagerService, SunnyConfigurationService sunnyConfigurationService, DataCollectorEnergyPricesCs dataCollectorEnergyPricesCs, InfoDataManagerService infoDataManagerService) {
        this.sunnyConfigurationService = sunnyConfigurationService;
        this.dataCollectorEnergyPricesCs = dataCollectorEnergyPricesCs;
        this.infoDataManagerService = infoDataManagerService;
        this.eventEntryManagerService = eventEntryManagerService;
        this.energyPricesServices.add("Czech OTE");
        this.energyPricesService = "Czech OTE";
        if (this.energyPricesService.equals("Czech OTE")) {
            dataCollectorEnergyPricesCs.collectData();
        }
    }

    @Scheduled(cron="0 0/15 * * * *")
    public void collectEnergyPrices() {
        if (this.energyPricesService.equals("Czech OTE")) {
            this.dataCollectorEnergyPricesCs.collectData();
        }
    }

    @Scheduled(fixedDelay=323350L)
    public void checkValidity() {
        String collectorNotNone = this.sunnyConfigurationService.GetConfiguration().getSpotPricesCollector();
        if (collectorNotNone.equals("none")) {
            return;
        }
        if (this.infoDataManagerService.findByDataKey("electricity_price_current_hour") != null && !this.infoDataManagerService.findByDataKey("electricity_price_current_hour").isValid()) {
            this.eventEntryManagerService.raiseEvent("ELECTRICITY PRICE: Current hour price is not valid, trying to collect data.", EventEntry.EventType.WARNING);
            this.collectEnergyPrices();
        }
    }
}

