/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.collectors.collectorfactories;

import cz.snyll.sunny.domain.inverter.CloudDetails;
import cz.snyll.sunny.domain.inverter.ConnectionDetails;
import cz.snyll.sunny.domain.inverter.Inverter;
import cz.snyll.sunny.domain.inverter.LocalAPIDetails;
import cz.snyll.sunny.domain.inverter.ModbusRTUDetails;
import cz.snyll.sunny.domain.inverter.ModbusTCPDetails;
import cz.snyll.sunny.services.InverterCollectorAbstractService;
import cz.snyll.sunny.services.collectors.DataCollector;
import cz.snyll.sunny.services.collectors.collectorfactories.InverterCollectorFactory;
import cz.snyll.sunny.services.collectors.inverterCollectors.DataCollectorInverterSolaxApi;
import cz.snyll.sunny.services.collectors.inverterCollectors.DataCollectorInverterSolaxModbus;
import cz.snyll.sunny.services.collectors.inverterCollectors.DataCollectorSolaxCloud;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class InverterCollectorFactory {
    private final ApplicationContext context;
    private static final ConcurrentHashMap<Long, DataCollector> collectorCache = new ConcurrentHashMap();

    @Autowired
    public InverterCollectorFactory(ApplicationContext context) {
        this.context = context;
    }

    public InverterCollectorAbstractService getInverterCollector(Inverter inverter) {
        return (InverterCollectorAbstractService)collectorCache.computeIfAbsent(inverter.getId(), id -> this.createCollector(inverter));
    }

    private InverterCollectorAbstractService createCollector(Inverter inverter) {
        ConnectionDetails details = inverter.getConnectionDetails();
        InverterCollectorAbstractService collector = switch (1.$SwitchMap$cz$snyll$sunny$domain$inverter$Inverter$Manufacturer[inverter.getInverterManufacturer().ordinal()]) {
            case 1 -> {
                if (details instanceof LocalAPIDetails) {
                    yield (InverterCollectorAbstractService)this.context.getBean(DataCollectorInverterSolaxApi.class);
                }
                if (details instanceof ModbusRTUDetails || details instanceof ModbusTCPDetails) {
                    yield (InverterCollectorAbstractService)this.context.getBean(DataCollectorInverterSolaxModbus.class);
                }
                if (details instanceof CloudDetails) {
                    yield (InverterCollectorAbstractService)this.context.getBean(DataCollectorSolaxCloud.class);
                }
                throw new IllegalArgumentException("Unsupported connection details type for Solax: " + details.getClass().getName());
            }
            default -> throw new IllegalArgumentException("Unsupported manufacturer: " + inverter.getInverterManufacturer());
        };
        collector.setInverter(inverter);
        return collector;
    }

    public void updateCollectorCache(Inverter inverter) {
        InverterCollectorAbstractService collector = this.createCollector(inverter);
        collector.setInverter(inverter);
        collectorCache.put(inverter.getId(), collector);
    }

    public void removeCollectorFromCache(Long id) {
        collectorCache.remove(id);
    }
}

