/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.collectors;

import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.services.EventEntryManagerService;
import cz.snyll.sunny.services.SunnyConfigurationService;
import cz.snyll.sunny.services.collectors.CommunitySharingCollector;
import cz.snyll.sunny.services.collectors.inverterCollectors.DataCollectorInverterSolaxApi;
import cz.snyll.sunny.services.collectors.inverterCollectors.DataCollectorInverterSolaxModbus;
import cz.snyll.sunny.services.collectors.otherinfocollectors.DataCollectorDayMonth;
import cz.snyll.sunny.services.collectors.otherinfocollectors.DataCollectorWeatherForecast;
import cz.snyll.sunny.services.collectors.otherinfocollectors.DeviceLoadCollector;
import cz.snyll.sunny.services.datasenders.SunnyHomeOnlineDataSender;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class DataCollectorsManagerService {
    DataCollectorInverterSolaxModbus dataCollectorInverterSolaxModbus;
    DataCollectorInverterSolaxApi dataCollectorInverterSolaxApi;
    DataCollectorWeatherForecast dataCollectorWeatherForecast;
    SunnyConfigurationService sunnyConfigurationService;
    EventEntryManagerService eventEntryManagerService;
    DataCollectorDayMonth dataCollectorDayMonth;
    SunnyHomeOnlineDataSender sunnyHomeOnlineDataSender;
    CommunitySharingCollector communitySharingCollector;
    DeviceLoadCollector deviceLoadCollector;
    private float periodCounter = 0.0f;

    @Autowired
    public DataCollectorsManagerService(SunnyHomeOnlineDataSender sunnyHomeOnlineDataSender, DataCollectorDayMonth dataCollectorDayMonth, EventEntryManagerService eventEntryManagerService, DataCollectorInverterSolaxModbus dataCollectorInverterSolaxModbus, DataCollectorInverterSolaxApi dataCollectorInverterSolaxApi, SunnyConfigurationService sunnyConfigurationService, CommunitySharingCollector communitySharingCollector, DeviceLoadCollector deviceLoadCollector, DataCollectorWeatherForecast dataCollectorWeatherForecast) {
        this.dataCollectorInverterSolaxApi = dataCollectorInverterSolaxApi;
        this.dataCollectorInverterSolaxModbus = dataCollectorInverterSolaxModbus;
        this.sunnyConfigurationService = sunnyConfigurationService;
        this.eventEntryManagerService = eventEntryManagerService;
        this.dataCollectorDayMonth = dataCollectorDayMonth;
        this.sunnyHomeOnlineDataSender = sunnyHomeOnlineDataSender;
        this.communitySharingCollector = communitySharingCollector;
        this.deviceLoadCollector = deviceLoadCollector;
        this.dataCollectorWeatherForecast = dataCollectorWeatherForecast;
    }

    @Scheduled(fixedDelay=1000L)
    private void ManageDataCollection() {
        try {
            this.periodCounter += 1.0f;
            this.dataCollectorDayMonth.collectData();
        }
        catch (Exception e) {
            this.eventEntryManagerService.raiseEvent("DATA COLLECTING: There was an issue with data collection: " + e.getMessage(), EventEntry.EventType.ERROR, 60);
        }
    }

    @Scheduled(fixedDelay=30000L)
    private void collectCommunityData() {
        try {
            this.communitySharingCollector.collectData();
        }
        catch (Exception e) {
            this.eventEntryManagerService.raiseEvent("COMMUNITY SHARING COLLECTING: There was an issue with data collection: " + e.getMessage(), EventEntry.EventType.ERROR, 60);
        }
    }

    @Scheduled(fixedDelay=5000L)
    private void collectLocalData() {
        try {
            this.deviceLoadCollector.collectData();
        }
        catch (Exception e) {
            this.eventEntryManagerService.raiseEvent("SYSTEM DATA COLLECTING: There was an issue with data collection: " + e.getMessage(), EventEntry.EventType.ERROR, 60);
        }
    }

    @Scheduled(fixedDelay=3600000L)
    private void collectWeatherData() {
        try {
            this.dataCollectorWeatherForecast.collectData();
        }
        catch (Exception e) {
            this.eventEntryManagerService.raiseEvent("WEATHER DATA COLLECTING: There was an issue with data collection: " + e.getMessage(), EventEntry.EventType.ERROR, 60);
        }
    }

    public DataCollectorInverterSolaxModbus getDataCollectorInverterSolaxModbus() {
        return this.dataCollectorInverterSolaxModbus;
    }

    public DataCollectorInverterSolaxApi getDataCollectorInverterSolaxApi() {
        return this.dataCollectorInverterSolaxApi;
    }

    public DataCollectorWeatherForecast getDataCollectorWeatherForecast() {
        return this.dataCollectorWeatherForecast;
    }

    public SunnyConfigurationService getSunnyConfigurationService() {
        return this.sunnyConfigurationService;
    }

    public EventEntryManagerService getEventEntryManagerService() {
        return this.eventEntryManagerService;
    }

    public DataCollectorDayMonth getDataCollectorDayMonth() {
        return this.dataCollectorDayMonth;
    }

    public SunnyHomeOnlineDataSender getSunnyHomeOnlineDataSender() {
        return this.sunnyHomeOnlineDataSender;
    }

    public CommunitySharingCollector getCommunitySharingCollector() {
        return this.communitySharingCollector;
    }

    public DeviceLoadCollector getDeviceLoadCollector() {
        return this.deviceLoadCollector;
    }

    public float getPeriodCounter() {
        return this.periodCounter;
    }

    public void setDataCollectorInverterSolaxModbus(DataCollectorInverterSolaxModbus dataCollectorInverterSolaxModbus) {
        this.dataCollectorInverterSolaxModbus = dataCollectorInverterSolaxModbus;
    }

    public void setDataCollectorInverterSolaxApi(DataCollectorInverterSolaxApi dataCollectorInverterSolaxApi) {
        this.dataCollectorInverterSolaxApi = dataCollectorInverterSolaxApi;
    }

    public void setDataCollectorWeatherForecast(DataCollectorWeatherForecast dataCollectorWeatherForecast) {
        this.dataCollectorWeatherForecast = dataCollectorWeatherForecast;
    }

    public void setSunnyConfigurationService(SunnyConfigurationService sunnyConfigurationService) {
        this.sunnyConfigurationService = sunnyConfigurationService;
    }

    public void setEventEntryManagerService(EventEntryManagerService eventEntryManagerService) {
        this.eventEntryManagerService = eventEntryManagerService;
    }

    public void setDataCollectorDayMonth(DataCollectorDayMonth dataCollectorDayMonth) {
        this.dataCollectorDayMonth = dataCollectorDayMonth;
    }

    public void setSunnyHomeOnlineDataSender(SunnyHomeOnlineDataSender sunnyHomeOnlineDataSender) {
        this.sunnyHomeOnlineDataSender = sunnyHomeOnlineDataSender;
    }

    public void setCommunitySharingCollector(CommunitySharingCollector communitySharingCollector) {
        this.communitySharingCollector = communitySharingCollector;
    }

    public void setDeviceLoadCollector(DeviceLoadCollector deviceLoadCollector) {
        this.deviceLoadCollector = deviceLoadCollector;
    }

    public void setPeriodCounter(float periodCounter) {
        this.periodCounter = periodCounter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataCollectorsManagerService)) {
            return false;
        }
        DataCollectorsManagerService other = (DataCollectorsManagerService)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (Float.compare(this.getPeriodCounter(), other.getPeriodCounter()) != 0) {
            return false;
        }
        DataCollectorInverterSolaxModbus this$dataCollectorInverterSolaxModbus = this.getDataCollectorInverterSolaxModbus();
        DataCollectorInverterSolaxModbus other$dataCollectorInverterSolaxModbus = other.getDataCollectorInverterSolaxModbus();
        if (this$dataCollectorInverterSolaxModbus == null ? other$dataCollectorInverterSolaxModbus != null : !this$dataCollectorInverterSolaxModbus.equals(other$dataCollectorInverterSolaxModbus)) {
            return false;
        }
        DataCollectorInverterSolaxApi this$dataCollectorInverterSolaxApi = this.getDataCollectorInverterSolaxApi();
        DataCollectorInverterSolaxApi other$dataCollectorInverterSolaxApi = other.getDataCollectorInverterSolaxApi();
        if (this$dataCollectorInverterSolaxApi == null ? other$dataCollectorInverterSolaxApi != null : !this$dataCollectorInverterSolaxApi.equals(other$dataCollectorInverterSolaxApi)) {
            return false;
        }
        DataCollectorWeatherForecast this$dataCollectorWeatherForecast = this.getDataCollectorWeatherForecast();
        DataCollectorWeatherForecast other$dataCollectorWeatherForecast = other.getDataCollectorWeatherForecast();
        if (this$dataCollectorWeatherForecast == null ? other$dataCollectorWeatherForecast != null : !this$dataCollectorWeatherForecast.equals(other$dataCollectorWeatherForecast)) {
            return false;
        }
        SunnyConfigurationService this$sunnyConfigurationService = this.getSunnyConfigurationService();
        SunnyConfigurationService other$sunnyConfigurationService = other.getSunnyConfigurationService();
        if (this$sunnyConfigurationService == null ? other$sunnyConfigurationService != null : !this$sunnyConfigurationService.equals(other$sunnyConfigurationService)) {
            return false;
        }
        EventEntryManagerService this$eventEntryManagerService = this.getEventEntryManagerService();
        EventEntryManagerService other$eventEntryManagerService = other.getEventEntryManagerService();
        if (this$eventEntryManagerService == null ? other$eventEntryManagerService != null : !this$eventEntryManagerService.equals(other$eventEntryManagerService)) {
            return false;
        }
        DataCollectorDayMonth this$dataCollectorDayMonth = this.getDataCollectorDayMonth();
        DataCollectorDayMonth other$dataCollectorDayMonth = other.getDataCollectorDayMonth();
        if (this$dataCollectorDayMonth == null ? other$dataCollectorDayMonth != null : !this$dataCollectorDayMonth.equals(other$dataCollectorDayMonth)) {
            return false;
        }
        SunnyHomeOnlineDataSender this$sunnyHomeOnlineDataSender = this.getSunnyHomeOnlineDataSender();
        SunnyHomeOnlineDataSender other$sunnyHomeOnlineDataSender = other.getSunnyHomeOnlineDataSender();
        if (this$sunnyHomeOnlineDataSender == null ? other$sunnyHomeOnlineDataSender != null : !this$sunnyHomeOnlineDataSender.equals(other$sunnyHomeOnlineDataSender)) {
            return false;
        }
        CommunitySharingCollector this$communitySharingCollector = this.getCommunitySharingCollector();
        CommunitySharingCollector other$communitySharingCollector = other.getCommunitySharingCollector();
        if (this$communitySharingCollector == null ? other$communitySharingCollector != null : !this$communitySharingCollector.equals(other$communitySharingCollector)) {
            return false;
        }
        DeviceLoadCollector this$deviceLoadCollector = this.getDeviceLoadCollector();
        DeviceLoadCollector other$deviceLoadCollector = other.getDeviceLoadCollector();
        return !(this$deviceLoadCollector == null ? other$deviceLoadCollector != null : !this$deviceLoadCollector.equals(other$deviceLoadCollector));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataCollectorsManagerService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getPeriodCounter());
        DataCollectorInverterSolaxModbus $dataCollectorInverterSolaxModbus = this.getDataCollectorInverterSolaxModbus();
        result = result * 59 + ($dataCollectorInverterSolaxModbus == null ? 43 : $dataCollectorInverterSolaxModbus.hashCode());
        DataCollectorInverterSolaxApi $dataCollectorInverterSolaxApi = this.getDataCollectorInverterSolaxApi();
        result = result * 59 + ($dataCollectorInverterSolaxApi == null ? 43 : $dataCollectorInverterSolaxApi.hashCode());
        DataCollectorWeatherForecast $dataCollectorWeatherForecast = this.getDataCollectorWeatherForecast();
        result = result * 59 + ($dataCollectorWeatherForecast == null ? 43 : $dataCollectorWeatherForecast.hashCode());
        SunnyConfigurationService $sunnyConfigurationService = this.getSunnyConfigurationService();
        result = result * 59 + ($sunnyConfigurationService == null ? 43 : $sunnyConfigurationService.hashCode());
        EventEntryManagerService $eventEntryManagerService = this.getEventEntryManagerService();
        result = result * 59 + ($eventEntryManagerService == null ? 43 : $eventEntryManagerService.hashCode());
        DataCollectorDayMonth $dataCollectorDayMonth = this.getDataCollectorDayMonth();
        result = result * 59 + ($dataCollectorDayMonth == null ? 43 : $dataCollectorDayMonth.hashCode());
        SunnyHomeOnlineDataSender $sunnyHomeOnlineDataSender = this.getSunnyHomeOnlineDataSender();
        result = result * 59 + ($sunnyHomeOnlineDataSender == null ? 43 : $sunnyHomeOnlineDataSender.hashCode());
        CommunitySharingCollector $communitySharingCollector = this.getCommunitySharingCollector();
        result = result * 59 + ($communitySharingCollector == null ? 43 : $communitySharingCollector.hashCode());
        DeviceLoadCollector $deviceLoadCollector = this.getDeviceLoadCollector();
        result = result * 59 + ($deviceLoadCollector == null ? 43 : $deviceLoadCollector.hashCode());
        return result;
    }

    public String toString() {
        return "DataCollectorsManagerService(dataCollectorInverterSolaxModbus=" + this.getDataCollectorInverterSolaxModbus() + ", dataCollectorInverterSolaxApi=" + this.getDataCollectorInverterSolaxApi() + ", dataCollectorWeatherForecast=" + this.getDataCollectorWeatherForecast() + ", sunnyConfigurationService=" + this.getSunnyConfigurationService() + ", eventEntryManagerService=" + this.getEventEntryManagerService() + ", dataCollectorDayMonth=" + this.getDataCollectorDayMonth() + ", sunnyHomeOnlineDataSender=" + this.getSunnyHomeOnlineDataSender() + ", communitySharingCollector=" + this.getCommunitySharingCollector() + ", deviceLoadCollector=" + this.getDeviceLoadCollector() + ", periodCounter=" + this.getPeriodCounter() + ")";
    }
}

