/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.collectors;

import cz.snyll.sunny.convenience.NicePrinter;
import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.domain.InfoData;
import cz.snyll.sunny.services.EventEntryManagerService;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.SunnyConfigurationService;
import cz.snyll.sunny.services.collectors.DataCollectorAbstractService;
import jakarta.annotation.PostConstruct;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DataCollectorSpotSavings
extends DataCollectorAbstractService {
    private final SunnyConfigurationService sunnyConfigurationService;
    private final EventEntryManagerService eventEntryManagerService;

    @Autowired
    public DataCollectorSpotSavings(InfoDataManagerService infoDataManagerService, SunnyConfigurationService sunnyConfigurationService, EventEntryManagerService eventEntryManagerService) {
        super(infoDataManagerService);
        this.sunnyConfigurationService = sunnyConfigurationService;
        this.eventEntryManagerService = eventEntryManagerService;
    }

    @PostConstruct
    public void collectDataAtStartup() {
        String solarConsumptionToday = "0";
        InfoData solarConsumptionTodayInfoData = this.getInfoDataManagerService().findByDataKey("solax_today_self_consumed_yield");
        if (solarConsumptionTodayInfoData != null) {
            solarConsumptionToday = solarConsumptionTodayInfoData.getDataValue();
        }
        this.saveinfodata(new InfoData("last_hour_solar_consumption", solarConsumptionToday, "kWh", 5000));
    }

    @Scheduled(cron="00 59 * * * *")
    public void scheduledCollection() {
        this.collectData();
    }

    @Scheduled(cron="00 00/5 * * * *")
    public void scheduledCollectionAdHoc() {
        if (this.getInfoDataManagerService().findByDataKey("energy_spot_price_today_1_hour") == null) {
            this.collectData();
        }
    }

    public HashMap<String, Map.Entry<String, String>> collectData() {
        try {
            String formattedDate = DataCollectorSpotSavings.getToday();
            if (this.sunnyConfigurationService.getSetting("spot_prices_buy") != null && this.sunnyConfigurationService.getSetting("spot_prices_buy").equals("true")) {
                float spotPriceBuyExtra = Optional.ofNullable(this.sunnyConfigurationService.getSetting("spot_price_buy_extra")).map(value -> {
                    try {
                        return Float.valueOf(Float.parseFloat(value));
                    }
                    catch (NumberFormatException e) {
                        return Float.valueOf(0.0f);
                    }
                }).orElse(Float.valueOf(0.0f)).floatValue();
                HashMap<String, Map.Entry<String, String>> dataMap = new HashMap<String, Map.Entry<String, String>>();
                InfoData lastHourOtePriceInfoData = this.getInfoDataManagerService().findByDataKey("ote_price_current_hour_local_currency_kwh");
                InfoData spotSavingsTodayInfoData = this.getInfoDataManagerService().findByDataKey("spot_savings_today");
                InfoData spotSavingsTodayCsResetDateInfoData = this.getInfoDataManagerService().findByDataKey("spot_savings_today_cs_reset_date");
                InfoData solarConsumptionTodayInfoData = this.getInfoDataManagerService().findByDataKey("solax_today_self_consumed_yield");
                InfoData lastHourSolarConsumptionTodayInfoData = this.getInfoDataManagerService().findByDataKey("last_hour_solar_consumption");
                float lastHourSolarConsumption = 0.0f;
                float solarConsumptionToday = 0.0f;
                float spotSavingsTodayValue = 0.0f;
                float spotSavingsTodayFinalLocalCurrency = 0.0f;
                float lastHourOtePrice = 0.0f;
                String resetDate = "-";
                if (lastHourSolarConsumptionTodayInfoData != null) {
                    lastHourSolarConsumption = Float.parseFloat(lastHourSolarConsumptionTodayInfoData.getDataValue());
                }
                if (spotSavingsTodayCsResetDateInfoData != null) {
                    resetDate = spotSavingsTodayCsResetDateInfoData.getDataValue();
                }
                if (solarConsumptionTodayInfoData != null) {
                    solarConsumptionToday = Float.parseFloat(solarConsumptionTodayInfoData.getDataValue());
                }
                if (lastHourSolarConsumption <= 0.0f) {
                    lastHourSolarConsumption = solarConsumptionToday;
                }
                if (lastHourOtePriceInfoData != null) {
                    lastHourOtePrice = Float.parseFloat(lastHourOtePriceInfoData.getDataValue());
                }
                if (lastHourOtePrice < 0.0f) {
                    lastHourOtePrice = 0.0f;
                }
                if (spotSavingsTodayInfoData != null) {
                    spotSavingsTodayValue = Float.parseFloat(spotSavingsTodayInfoData.getDataValue());
                }
                if (!resetDate.equals(formattedDate) || spotSavingsTodayCsResetDateInfoData == null) {
                    spotSavingsTodayValue = 0.0f;
                    dataMap.put("spot_savings_today_cs_reset_date", new AbstractMap.SimpleEntry<String, String>(formattedDate, "-"));
                }
                float savedLastHour = (solarConsumptionToday - lastHourSolarConsumption) * (lastHourOtePrice + spotPriceBuyExtra);
                spotSavingsTodayFinalLocalCurrency = spotSavingsTodayValue + savedLastHour;
                this.eventEntryManagerService.raiseEvent("SAVINGS: Saved last hour in local currency: " + savedLastHour + " CZK; Total today: " + spotSavingsTodayFinalLocalCurrency + " CZK; Solar consumption today: " + solarConsumptionToday + " kWh; Last hour consumed: " + lastHourSolarConsumption + "; Ote price this hour: " + lastHourOtePrice + "; Spot price buy extra: " + spotPriceBuyExtra, EventEntry.EventType.INFO, 60);
                NicePrinter.nicePrint((String)("Saved last hour in local currency: " + savedLastHour + " CZK; Total today: " + spotSavingsTodayFinalLocalCurrency + " CZK;"), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
                dataMap.put("spot_savings_today", new AbstractMap.SimpleEntry<String, String>(Float.toString(spotSavingsTodayFinalLocalCurrency), "CZK"));
                dataMap.put("last_hour_solar_consumption", new AbstractMap.SimpleEntry<String, String>(Float.toString(solarConsumptionToday), "kWh"));
                this.saveinfodata(dataMap);
                return dataMap;
            }
        }
        catch (Exception e) {
            this.eventEntryManagerService.raiseEvent("SPOT SAVINGS: Some issue with calculating spot savings - " + e.getMessage(), EventEntry.EventType.ERROR, 60);
            NicePrinter.nicePrint((String)("SPOT SAVINGS: Some issue with calculating spot savings - - " + e.getMessage()), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
        }
        return new HashMap<String, Map.Entry<String, String>>();
    }

    @Scheduled(cron="00 00 00 * * *")
    public void resetLastHourSolarConsumption() {
        try {
            HashMap<String, AbstractMap.SimpleEntry<String, String>> dataMap = new HashMap<String, AbstractMap.SimpleEntry<String, String>>();
            dataMap.put("last_hour_solar_consumption", new AbstractMap.SimpleEntry<String, String>("0", "kWh"));
            this.saveinfodata(dataMap);
        }
        catch (Exception e) {
            this.eventEntryManagerService.raiseEvent("SPOT SAVINGS: Some issue with resetting last hour solar consumption - " + e.getMessage(), EventEntry.EventType.ERROR, 60);
            NicePrinter.nicePrint((String)("SPOT SAVINGS: Some issue with resetting last hour solar consumption - " + e.getMessage()), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
        }
    }

    static String getToday() {
        LocalDate today = LocalDate.now();
        DateTimeFormatter formatter_today = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        return today.format(formatter_today);
    }

    static int getHour() {
        LocalDateTime currentTime = LocalDateTime.now();
        DateTimeFormatter formatter_hour = DateTimeFormatter.ofPattern("H");
        String currentHour = currentTime.format(formatter_hour);
        return Integer.parseInt(currentHour);
    }
}

