/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.collectors;

import com.fasterxml.jackson.databind.JsonNode;
import cz.snyll.sunny.config.InfoDataConfiguration;
import cz.snyll.sunny.config.InverterMap;
import cz.snyll.sunny.domain.InfoData;
import cz.snyll.sunny.services.DailyRecordManagerService;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.collectors.DataCollector;
import cz.snyll.sunny.services.datasenders.RemoteDataSender;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.LocalTime;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class DataCollectorAbstractService
implements DataCollector {
    private static final Logger log = LoggerFactory.getLogger(DataCollectorAbstractService.class);
    @Autowired
    private InfoDataConfiguration infoDataConfiguration;
    @Autowired
    private DailyRecordManagerService dailyRecordManagerService;
    @Autowired(required=false)
    private RemoteDataSender remoteDataSender;
    private final InfoDataManagerService infoDataManagerService;
    private final HashMap<String, Long> infoDataSentMap = new HashMap();

    @Autowired
    protected DataCollectorAbstractService(InfoDataManagerService infoDataManagerService) {
        this.infoDataManagerService = infoDataManagerService;
    }

    @Transactional
    public void saveinfodata(HashMap<String, Map.Entry<String, String>> map) {
        ArrayList<InfoData> toSend = new ArrayList<InfoData>();
        if (this.shouldSaveDailyRecord(map)) {
            this.dailyRecordManagerService.saveDailyRecord();
        }
        for (Map.Entry<String, Map.Entry<String, String>> mapElement : map.entrySet()) {
            String dataKey = mapElement.getKey();
            Map.Entry<String, String> dataEntry = mapElement.getValue();
            String dataValue = dataEntry.getKey();
            String dataUnit = dataEntry.getValue();
            InfoData infoData = this.infoDataManagerService.findByDataKey(dataKey);
            if (infoData == null) {
                infoData = new InfoData();
            }
            infoData.setDataKey(dataKey);
            infoData.setDataValue(dataValue);
            infoData.setUnits(dataUnit);
            infoData.setDataFreshness(new Date());
            this.infoDataManagerService.save(infoData, false);
            toSend.add(infoData);
        }
        this.sendMultipleDataToRemote(toSend);
    }

    public boolean shouldSaveDailyRecord(Map<String, Map.Entry<String, String>> map) {
        if (!DataCollectorAbstractService.isTimeAfter22OrBefore2()) {
            return false;
        }
        InfoData infoDataTodayEnergy = this.infoDataManagerService.findByDataKey("solax_today_energy");
        InfoData infoDataTodayYield = this.infoDataManagerService.findByDataKey("solax_today_yield");
        InfoData infoDataTodayFeedin = this.infoDataManagerService.findByDataKey("solax_today_feedin_energy");
        InfoData infoDataTodayConsumption = this.infoDataManagerService.findByDataKey("solax_today_consumption");
        if (infoDataTodayEnergy == null && infoDataTodayYield == null) {
            return false;
        }
        float todayEnergy = infoDataTodayEnergy != null ? Float.parseFloat(infoDataTodayEnergy.getDataValue()) : 0.0f;
        float todayYield = infoDataTodayYield != null ? Float.parseFloat(infoDataTodayYield.getDataValue()) : 0.0f;
        float todayFeedin = infoDataTodayFeedin != null ? Float.parseFloat(infoDataTodayFeedin.getDataValue()) : 0.0f;
        float todayConsumption = infoDataTodayConsumption != null ? Float.parseFloat(infoDataTodayConsumption.getDataValue()) : 0.0f;
        for (Map.Entry<String, Map.Entry<String, String>> mapElement : map.entrySet()) {
            String dataKey = mapElement.getKey();
            Map.Entry<String, String> dataEntry = mapElement.getValue();
            String dataValue = dataEntry.getKey();
            try {
                if (dataKey.equals("solax_today_energy") && Float.parseFloat(dataValue) < todayEnergy) {
                    return true;
                }
                if (dataKey.equals("solax_today_yield") && Float.parseFloat(dataValue) < todayYield) {
                    return true;
                }
                if (dataKey.equals("solax_today_feedin_energy") && Float.parseFloat(dataValue) < todayFeedin) {
                    return true;
                }
                if (!dataKey.equals("solax_today_consumption") || !(Float.parseFloat(dataValue) < todayConsumption)) continue;
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public InfoData prepareInfoData(InfoData infoData) {
        InfoData existingData = this.infoDataManagerService.findByDataKey(infoData.getDataKey());
        if (existingData == null) {
            existingData = new InfoData();
        }
        existingData.setId(infoData.getId());
        existingData.setDataKey(infoData.getDataKey());
        existingData.setDataValue(infoData.getDataValue());
        existingData.setUnits(infoData.getUnits());
        existingData.setDataFreshness(new Date());
        existingData.setValidTime(infoData.getValidTime());
        return existingData;
    }

    @Transactional
    public void saveinfodata(InfoData infoData) {
        InfoData existingData = this.prepareInfoData(infoData);
        this.infoDataManagerService.save(existingData, false);
        this.sendDataToRemote(existingData);
    }

    @Transactional
    public void saveinfodata(InfoData infoData, boolean flushToDb) {
        InfoData existingData = this.prepareInfoData(infoData);
        this.infoDataManagerService.save(existingData, true);
        this.sendDataToRemote(existingData);
    }

    public void sendDataToRemote(InfoData infoData) {
        if (this.remoteDataSender == null) {
            log.warn("REMOTE DATA: remote storage not defined, not sending data to remote.");
            return;
        }
        HashMap infoDataRemoteMap = this.infoDataConfiguration.getRemoteMap();
        String secondsString = (String)infoDataRemoteMap.get(infoData.getDataKey());
        long secondsLong = 0L;
        if (secondsString != null) {
            try {
                secondsLong = Long.parseLong(secondsString);
            }
            catch (NumberFormatException e) {
                log.warn("REMOTE DATA: Failed to parse seconds value for data key {}: {}", (Object)infoData.getDataKey(), (Object)e.getMessage());
                return;
            }
        }
        long lastSentEpochSecond = this.infoDataSentMap.getOrDefault(infoData.getDataKey(), 0L);
        long currentEpochSecond = Instant.now().getEpochSecond();
        if (currentEpochSecond >= lastSentEpochSecond + secondsLong) {
            if (log.isDebugEnabled()) {
                log.debug("REMOTE DATA: Time elapsed, sending remote data for {}", (Object)infoData.getDataKey());
            }
            this.remoteDataSender.sendData(infoData);
            this.infoDataSentMap.put(infoData.getDataKey(), currentEpochSecond);
        } else if (log.isDebugEnabled()) {
            this.logTimeout(infoData, secondsLong);
        }
    }

    @Transactional
    public void sendMultipleDataToRemote(ArrayList<InfoData> infoDatas) {
        if (this.remoteDataSender == null) {
            if (log.isDebugEnabled()) {
                log.debug("REMOTE DATA: remote storage not defined, not sending data to remote.");
            }
        } else {
            ArrayList<InfoData> toSend = new ArrayList<InfoData>();
            for (InfoData infoData : infoDatas) {
                long secondsLong;
                HashMap infoDataRemoteMap = this.infoDataConfiguration.getRemoteMap();
                String secondsString = (String)infoDataRemoteMap.get(infoData.getDataKey());
                try {
                    secondsLong = Long.parseLong(secondsString);
                }
                catch (Exception e) {
                    continue;
                }
                if (this.infoDataSentMap.containsKey(infoData.getDataKey())) {
                    if (Instant.now().getEpochSecond() < (Long)this.infoDataSentMap.get(infoData.getDataKey()) + secondsLong) continue;
                    toSend.add(infoData);
                    this.infoDataSentMap.put(infoData.getDataKey(), Instant.now().getEpochSecond());
                    continue;
                }
                toSend.add(infoData);
                this.infoDataSentMap.put(infoData.getDataKey(), Instant.now().getEpochSecond());
            }
            this.remoteDataSender.sendMultipleData(toSend);
        }
    }

    private void logTimeout(InfoData infoData, long secondsLong) {
        log.debug("REMOTE DATA: Time not reached for {}; last sent time = {}; compared with = {}", new Object[]{infoData.getDataKey(), this.infoDataSentMap.get(infoData.getDataKey()), Instant.now().plusSeconds(secondsLong).getEpochSecond()});
    }

    public HashMap<String, InverterMap> getFinalMap(Map<String, ArrayList<String>> stringMap) {
        HashMap<String, InverterMap> finalMap = new HashMap<String, InverterMap>();
        for (Map.Entry<String, ArrayList<String>> entry : stringMap.entrySet()) {
            try {
                String key = entry.getKey();
                InverterMap inverterMap = new InverterMap(Integer.parseInt(entry.getValue().get(0)), Float.parseFloat(entry.getValue().get(1)), entry.getValue().get(2), entry.getValue().get(3), Integer.parseInt(entry.getValue().get(4)));
                finalMap.put(key, inverterMap);
            }
            catch (Exception exception) {}
        }
        return finalMap;
    }

    public int modbusInt16ToJavaInt(int modbusInt16) {
        return (short)modbusInt16;
    }

    public int modbusInt32ToJavaInt(int lowRegister, int highRegister) {
        int combined = highRegister << 16 | lowRegister & 0xFFFF;
        if ((combined & Integer.MIN_VALUE) != 0) {
            combined |= 0xFFFF0000;
        }
        return combined;
    }

    public long modbusUInt32ToJavaLong(int lowRegister, int highRegister) {
        long highRegLong = (long)highRegister & 0xFFFFL;
        return highRegLong << 16 | (long)(lowRegister & 0xFFFF);
    }

    public Map.Entry<String, InverterMap> getMapEntry(HashMap<String, InverterMap> apiMapper, int i) {
        return apiMapper.entrySet().stream().filter(entry -> ((InverterMap)entry.getValue()).getAddress() == i).findFirst().orElse(null);
    }

    protected String decodeRegisters(List<Integer> registers) {
        StringBuilder sb = new StringBuilder();
        for (int value : registers) {
            char high = (char)(value >> 8);
            char low = (char)(value & 0xFF);
            sb.append(high).append(low);
        }
        return sb.toString();
    }

    public HashMap<String, Map.Entry<String, String>> parseValues(JsonNode jsonResponseData, HashMap<String, InverterMap> apiMapper) {
        HashMap<String, Map.Entry<String, String>> dataMap = new HashMap<String, Map.Entry<String, String>>();
        for (int i = 0; i < jsonResponseData.size(); ++i) {
            try {
                JsonNode inverterValue = jsonResponseData.get(i);
                float apiValue = Float.parseFloat(inverterValue.toString());
                Map.Entry entry = this.getMapEntry(apiMapper, i);
                if (entry == null) continue;
                String key = (String)entry.getKey();
                InverterMap map = (InverterMap)entry.getValue();
                BigDecimal finalValue = new BigDecimal(apiValue);
                switch (map.getDataType()) {
                    case "uint16": {
                        finalValue = BigDecimal.valueOf(apiValue);
                        break;
                    }
                    case "int16": {
                        finalValue = BigDecimal.valueOf(this.modbusInt16ToJavaInt((int)apiValue));
                        break;
                    }
                    case "int32": {
                        if (map.getLength() != 2) break;
                        int nextValue = jsonResponseData.get(i + 1).intValue();
                        finalValue = BigDecimal.valueOf(this.modbusInt32ToJavaInt((int)apiValue, nextValue));
                        break;
                    }
                    case "uint32": {
                        if (map.getLength() != 2) break;
                        int nextValue = jsonResponseData.get(i + 1).intValue();
                        finalValue = BigDecimal.valueOf(this.modbusUInt32ToJavaLong((int)apiValue, nextValue));
                    }
                }
                finalValue = finalValue.multiply(BigDecimal.valueOf(map.getModifier())).setScale(2, RoundingMode.HALF_UP);
                if (i != map.getAddress()) continue;
                dataMap.put(key, new AbstractMap.SimpleEntry<String, String>(finalValue.toString(), map.getUnit()));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return dataMap;
    }

    private static boolean isTimeAfter22OrBefore2() {
        LocalTime currentTime = LocalTime.now();
        LocalTime time22 = LocalTime.of(22, 0);
        LocalTime time02 = LocalTime.of(2, 0);
        return currentTime.isAfter(time22) || currentTime.isBefore(time02);
    }

    public InfoDataManagerService getInfoDataManagerService() {
        return this.infoDataManagerService;
    }
}

