/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.click;

import cz.snyll.sunny.convenience.NicePrinter;
import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.services.EventEntryManagerService;
import cz.snyll.sunny.services.SunnyConfigurationService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class ClickAPIService {
    private final SunnyConfigurationService sunnyConfigurationService;
    private final EventEntryManagerService eventEntryManagerService;
    private final RestTemplate restTemplate;
    @Value(value="${sunnyhomeonline.url}")
    private String sunnyHomeOnlineUrlConfig;

    public ClickAPIService(SunnyConfigurationService sunnyConfigurationService, EventEntryManagerService eventEntryManagerService, RestTemplate restTemplate) {
        this.sunnyConfigurationService = sunnyConfigurationService;
        this.eventEntryManagerService = eventEntryManagerService;
        this.restTemplate = restTemplate;
    }

    public ResponseEntity<String> callClickAPI(String user, String token, String json, String apiUrl, HttpMethod method) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(token);
        NicePrinter.nicePrint((String)("SUNNYHOME CLICK API SERVICE: Sending request to url: " + this.sunnyHomeOnlineUrlConfig + apiUrl + " with payload - " + json), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
        HttpEntity entity = new HttpEntity((Object)json, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(this.sunnyHomeOnlineUrlConfig + apiUrl, method, entity, String.class, new Object[0]);
            NicePrinter.nicePrint((String)("SUNNYHOME CLICK API SERVICE: Response from sunnyhome.click: " + (String)response.getBody()), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            return response;
        }
        catch (Exception e) {
            this.eventEntryManagerService.raiseEvent("SUNNYHOME CLICK API SERVICE: Error while calling sunnyhome.click API: " + e.getMessage(), EventEntry.EventType.ERROR, 60);
            NicePrinter.nicePrint((String)("SUNNYHOME CLICK API SERVICE: Error while calling sunnyhome.click API: " + e.getMessage()), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            return null;
        }
    }
}

