/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services;

import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.domain.Trigger;
import cz.snyll.sunny.repositories.TriggerRepository;
import cz.snyll.sunny.services.EventEntryManagerService;
import cz.snyll.sunny.services.TriggerManager;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;

@Service
public class TriggerManagerService
implements TriggerManager {
    private final TriggerRepository triggerRepository;
    @Autowired
    private EventEntryManagerService eventEntryManagerService;

    @Autowired
    public TriggerManagerService(TriggerRepository triggerRepository) {
        this.triggerRepository = triggerRepository;
    }

    public void saveTrigger(Trigger trigger) {
        if (trigger.getId() == null) {
            trigger.setStatusUpdatedTime(new Date(System.currentTimeMillis()));
            trigger.setTriggerState(false);
            this.eventEntryManagerService.raiseEvent("TRIGGER: Adding Trigger with name: " + trigger.getTriggerName(), EventEntry.EventType.SUCCESS);
        }
        if (trigger.getStatusUpdatedTime() == null) {
            trigger.setStatusUpdatedTime(new Date(System.currentTimeMillis()));
        }
        trigger.setTriggerName(trigger.getTriggerName().trim());
        trigger.setInfoDataKey(trigger.getInfoDataKey().trim());
        trigger.setInfoDataKeyCompare(trigger.getInfoDataKeyCompare().trim());
        Trigger savedTrigger = (Trigger)this.triggerRepository.save((Object)trigger);
    }

    public void deleteTrigger(Trigger trigger) throws DataIntegrityViolationException {
        this.triggerRepository.delete((Object)trigger);
        this.eventEntryManagerService.raiseEvent("TRIGGER: Trigger deleted. Name: " + trigger.getTriggerName(), EventEntry.EventType.WARNING);
    }

    public Trigger loadTrigger(Long id) {
        return this.triggerRepository.findById((Object)id).isPresent() ? (Trigger)this.triggerRepository.findById((Object)id).get() : null;
    }

    public ArrayList<Trigger> loadAll() {
        return (ArrayList)this.triggerRepository.findAll();
    }

    public void setTriggerState(boolean state, Trigger trigger) {
        if (trigger.getStatusUpdatedTime() == null) {
            trigger.setStatusUpdatedTime(new Date(System.currentTimeMillis()));
        }
        if (trigger.isTriggerState() == state) {
            return;
        }
        trigger.setStatusUpdatedTime(new Date(System.currentTimeMillis()));
        trigger.setTriggerState(state);
        Trigger savedTrigger = (Trigger)this.triggerRepository.save((Object)trigger);
    }

    public void deleteTriggerById(long id) {
        this.triggerRepository.deleteById((Object)id);
        this.eventEntryManagerService.raiseEvent("TRIGGER: Trigger deleted. ID: " + id, EventEntry.EventType.WARNING);
    }
}

