/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services;

import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.domain.MainConfiguration;
import cz.snyll.sunny.domain.MainSunnyConfiguration;
import cz.snyll.sunny.repositories.MainSunnyConfigurationRepository;
import cz.snyll.sunny.services.EventEntryManagerService;
import cz.snyll.sunny.services.SunnyConfiguration;
import jakarta.annotation.PostConstruct;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.factory.PasswordEncoderFactories;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class SunnyConfigurationService
implements SunnyConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SunnyConfigurationService.class);
    private static final Logger logger = LoggerFactory.getLogger(SunnyConfigurationService.class);
    private final HashMap<String, String> allSettings;
    private MainConfiguration configuration;
    private final EventEntryManagerService eventEntryManagerService;
    MainSunnyConfigurationRepository mainSunnyConfigurationRepository;

    @Autowired
    public SunnyConfigurationService(MainSunnyConfigurationRepository mainSunnyConfigurationRepository, EventEntryManagerService eventEntryManagerService) {
        MainSunnyConfiguration openWeatherApiKey;
        MainSunnyConfiguration debugMode;
        MainSunnyConfiguration spotPricesCollector;
        MainSunnyConfiguration sunnyHomeClickCollectUsers;
        MainSunnyConfiguration sunnyhomeClickAllowedUsers;
        MainSunnyConfiguration sunnyHomeClickEmail;
        MainSunnyConfiguration sunnyHomeClickToken;
        MainSunnyConfiguration sunnyHomeClickUsername;
        MainSunnyConfiguration solax_cloud_password;
        MainSunnyConfiguration solax_cloud_username;
        MainSunnyConfiguration wallbox_password;
        MainSunnyConfiguration wallbox_ip_address;
        MainSunnyConfiguration energy_currency;
        MainSunnyConfiguration spot_price_sell_extra;
        MainSunnyConfiguration spot_price_buy_extra;
        MainSunnyConfiguration spot_prices_buy;
        MainSunnyConfiguration spot_prices;
        MainSunnyConfiguration sunnymap_token;
        MainSunnyConfiguration send_data_to_sunnymap;
        MainSunnyConfiguration influxdb_org;
        MainSunnyConfiguration influxdb_bucket;
        MainSunnyConfiguration influxdb_apitoken;
        MainSunnyConfiguration influxdb_url;
        MainSunnyConfiguration away_mode;
        MainSunnyConfiguration automation;
        MainSunnyConfiguration energy_price_per_kwh_sell;
        MainSunnyConfiguration energy_price_per_kwh;
        MainSunnyConfiguration latitude;
        MainSunnyConfiguration longitude;
        MainSunnyConfiguration password;
        MainSunnyConfiguration userName;
        MainSunnyConfiguration systemSize;
        this.mainSunnyConfigurationRepository = mainSunnyConfigurationRepository;
        this.eventEntryManagerService = eventEntryManagerService;
        this.ConfigurationReset();
        this.allSettings = this.allSettingsMap();
        MainSunnyConfiguration language = mainSunnyConfigurationRepository.findBySettingKey("language");
        if (language == null) {
            this.saveSetting("language", "cs");
        }
        if ((systemSize = mainSunnyConfigurationRepository.findBySettingKey("total_panel_power_installed")) == null) {
            this.saveSetting("total_panel_power_installed", "10");
        }
        if ((userName = mainSunnyConfigurationRepository.findBySettingKey("user_name")) == null) {
            this.saveSetting("user_name", "");
        }
        if ((password = mainSunnyConfigurationRepository.findBySettingKey("password")) == null) {
            this.saveSetting("password", "");
        }
        if ((longitude = mainSunnyConfigurationRepository.findBySettingKey("longitude")) == null) {
            this.saveSetting("longitude", "0");
        }
        if ((latitude = mainSunnyConfigurationRepository.findBySettingKey("latitude")) == null) {
            this.saveSetting("latitude", "0");
        }
        if ((energy_price_per_kwh = mainSunnyConfigurationRepository.findBySettingKey("energy_price_per_kwh")) == null) {
            this.saveSetting("energy_price_per_kwh", "0");
        }
        if ((energy_price_per_kwh_sell = mainSunnyConfigurationRepository.findBySettingKey("energy_price_per_kwh_sell")) == null) {
            this.saveSetting("energy_price_per_kwh_sell", "0");
        }
        if ((automation = mainSunnyConfigurationRepository.findBySettingKey("automation")) == null) {
            this.saveSetting("automation", "TRUE");
        }
        if ((away_mode = mainSunnyConfigurationRepository.findBySettingKey("away_mode")) == null) {
            this.saveSetting("away_mode", "FALSE");
        }
        if ((influxdb_url = mainSunnyConfigurationRepository.findBySettingKey("influxdb_url")) == null) {
            this.saveSetting("influxdb_url", "");
        }
        if ((influxdb_apitoken = mainSunnyConfigurationRepository.findBySettingKey("influxdb_apitoken")) == null) {
            this.saveSetting("influxdb_apitoken", "");
        }
        if ((influxdb_bucket = mainSunnyConfigurationRepository.findBySettingKey("influxdb_bucket")) == null) {
            this.saveSetting("influxdb_bucket", "FVE");
        }
        if ((influxdb_org = mainSunnyConfigurationRepository.findBySettingKey("influxdb_org")) == null) {
            this.saveSetting("influxdb_org", "");
        }
        if ((send_data_to_sunnymap = mainSunnyConfigurationRepository.findBySettingKey("send_data_to_sunnymap")) == null) {
            this.saveSetting("send_data_to_sunnymap", "FALSE");
        }
        if ((sunnymap_token = mainSunnyConfigurationRepository.findBySettingKey("sunnymap_token")) == null) {
            this.saveSetting("sunnymap_token", "");
        }
        if ((spot_prices = mainSunnyConfigurationRepository.findBySettingKey("spot_prices")) == null) {
            this.saveSetting("spot_prices", "FALSE");
        }
        if ((spot_prices_buy = mainSunnyConfigurationRepository.findBySettingKey("spot_prices_buy")) == null) {
            this.saveSetting("spot_prices_buy", "FALSE");
        }
        if ((spot_price_buy_extra = mainSunnyConfigurationRepository.findBySettingKey("spot_price_buy_extra")) == null) {
            this.saveSetting("spot_price_buy_extra", "0");
        }
        if ((spot_price_sell_extra = mainSunnyConfigurationRepository.findBySettingKey("spot_price_sell_extra")) == null) {
            this.saveSetting("spot_price_sell_extra", "0");
        }
        if ((energy_currency = mainSunnyConfigurationRepository.findBySettingKey("energy_currency")) == null) {
            this.saveSetting("energy_currency", "CZK");
        }
        if ((wallbox_ip_address = mainSunnyConfigurationRepository.findBySettingKey("wallbox_ip_address")) == null) {
            this.saveSetting("wallbox_ip_address", "");
        }
        if ((wallbox_password = mainSunnyConfigurationRepository.findBySettingKey("wallbox_password")) == null) {
            this.saveSetting("wallbox_password", "");
        }
        if ((solax_cloud_username = mainSunnyConfigurationRepository.findBySettingKey("solax_cloud_username")) == null) {
            this.saveSetting("solax_cloud_username", "");
        }
        if ((solax_cloud_password = mainSunnyConfigurationRepository.findBySettingKey("solax_cloud_password")) == null) {
            this.saveSetting("solax_cloud_password", "");
        }
        if ((sunnyHomeClickUsername = mainSunnyConfigurationRepository.findBySettingKey("sunnyhome_click_user")) == null) {
            this.saveSetting("sunnyhome_click_user", "");
        }
        if ((sunnyHomeClickToken = mainSunnyConfigurationRepository.findBySettingKey("sunnyhome_click_token")) == null) {
            this.saveSetting("sunnyhome_click_token", "");
        }
        if ((sunnyHomeClickEmail = mainSunnyConfigurationRepository.findBySettingKey("sunnyhome_click_email")) == null) {
            this.saveSetting("sunnyhome_click_email", "");
        }
        if ((sunnyhomeClickAllowedUsers = mainSunnyConfigurationRepository.findBySettingKey("sunnyhome_click_allowed_users")) == null) {
            this.saveSetting("sunnyhome_click_allowed_users", "");
        }
        if ((sunnyHomeClickCollectUsers = mainSunnyConfigurationRepository.findBySettingKey("sunnyhome_click_collect_users")) == null) {
            this.saveSetting("sunnyhome_click_collect_users", "");
        }
        if ((spotPricesCollector = mainSunnyConfigurationRepository.findBySettingKey("spot_prices_collector")) == null) {
            this.saveSetting("spot_prices_collector", "none");
        }
        if ((debugMode = mainSunnyConfigurationRepository.findBySettingKey("debug_mode")) == null) {
            this.saveSetting("debug_mode", "FALSE");
        }
        if ((openWeatherApiKey = mainSunnyConfigurationRepository.findBySettingKey("open_weather_api_key")) == null) {
            this.saveSetting("open_weather_api_key", "");
        }
        this.configuration = this.loadIntoMainConfiguration();
    }

    public void saveSetting(String key, String value) {
        if (value == null) {
            return;
        }
        MainSunnyConfiguration mainSunnyConfiguration = this.mainSunnyConfigurationRepository.findBySettingKey(key);
        if (mainSunnyConfiguration == null) {
            mainSunnyConfiguration = new MainSunnyConfiguration();
        }
        mainSunnyConfiguration.setSettingKey(key);
        mainSunnyConfiguration.setSettingValue(value);
        this.mainSunnyConfigurationRepository.save((Object)mainSunnyConfiguration);
        this.allSettings.put(key, value);
        this.configuration = this.loadIntoMainConfiguration();
    }

    public void ConfigurationReset() {
        String currentWorkingDir = System.getProperty("user.dir");
        Path defaultSettingsPath = Paths.get(currentWorkingDir, "data", "reset_configuration.txt");
        Path defaultPasswordResetPath = Paths.get(currentWorkingDir, "data", "reset_password.txt");
        if (Files.exists(defaultSettingsPath, new LinkOption[0])) {
            this.eventEntryManagerService.raiseEvent("RESET: reset_configuration.txt file found in data folder, proceeding with total configuration reset ", EventEntry.EventType.WARNING);
            this.mainSunnyConfigurationRepository.deleteAll();
        }
        if (Files.exists(defaultPasswordResetPath, new LinkOption[0])) {
            this.eventEntryManagerService.raiseEvent("RESET: reset_password.txt file found in data folder, proceeding with user and password configuration reset ", EventEntry.EventType.WARNING);
            this.mainSunnyConfigurationRepository.deleteBySettingKey("user_name");
            this.mainSunnyConfigurationRepository.deleteBySettingKey("password");
        }
    }

    public String getSetting(String key) {
        return this.allSettings.getOrDefault(key, null);
    }

    public MainConfiguration GetConfiguration() {
        return this.configuration;
    }

    public HashMap<String, String> allSettingsMap() {
        HashMap<String, String> allConf = new HashMap<String, String>();
        List allConfiguration = this.mainSunnyConfigurationRepository.findAll();
        for (MainSunnyConfiguration config : allConfiguration) {
            allConf.put(config.getSettingKey(), config.getSettingValue());
        }
        return allConf;
    }

    public List<MainSunnyConfiguration> allConfigurations() {
        return this.mainSunnyConfigurationRepository.findAll();
    }

    public MainConfiguration loadIntoMainConfiguration() {
        MainConfiguration configuration = new MainConfiguration();
        List allConfiguration = this.allConfigurations();
        for (MainSunnyConfiguration config : allConfiguration) {
            if (config.getSettingKey().equals("total_panel_power_installed")) {
                configuration.setTotalPanelPowerInstalled(Float.parseFloat(config.getSettingValue()));
            }
            if (config.getSettingKey().equals("user_name")) {
                configuration.setUserName(config.getSettingValue());
            }
            if (config.getSettingKey().equals("password")) {
                configuration.setPassword(config.getSettingValue());
            }
            if (config.getSettingKey().equals("longitude")) {
                configuration.setLongitude(Float.parseFloat(config.getSettingValue()));
            }
            if (config.getSettingKey().equals("latitude")) {
                configuration.setLatitude(Float.parseFloat(config.getSettingValue()));
            }
            if (config.getSettingKey().equals("energy_price_per_kwh")) {
                configuration.setEnergyPricePerKwh(Float.parseFloat(config.getSettingValue()));
            }
            if (config.getSettingKey().equals("energy_price_per_kwh_sell")) {
                configuration.setEnergyPricePerKwhSell(Float.parseFloat(config.getSettingValue()));
            }
            if (config.getSettingKey().equals("solax_local_ip_address")) {
                configuration.setSolaxLocalIpAddress(config.getSettingValue());
            }
            if (config.getSettingKey().equals("automation")) {
                configuration.setAutomation(Boolean.parseBoolean(config.getSettingValue()));
            }
            if (config.getSettingKey().equals("away_mode")) {
                configuration.setAwayMode(Boolean.parseBoolean(config.getSettingValue()));
            }
            if (config.getSettingKey().equals("influxdb_url")) {
                configuration.setInfluxdbUrl(config.getSettingValue());
            }
            if (config.getSettingKey().equals("influxdb_apitoken")) {
                configuration.setInfluxdbApitoken(config.getSettingValue());
            }
            if (config.getSettingKey().equals("influxdb_bucket")) {
                configuration.setInfluxdbBucket(config.getSettingValue());
            }
            if (config.getSettingKey().equals("influxdb_org")) {
                configuration.setInfluxdbOrg(config.getSettingValue());
            }
            if (config.getSettingKey().equals("language")) {
                configuration.setLanguage(config.getSettingValue());
            }
            if (config.getSettingKey().equals("send_data_to_sunnymap")) {
                configuration.setSendDataToSunnymap(Boolean.parseBoolean(config.getSettingValue()));
            }
            if (config.getSettingKey().equals("sunnymap_token")) {
                configuration.setSunnymapToken(config.getSettingValue());
            }
            if (config.getSettingKey().equals("spot_prices")) {
                configuration.setSpotPrices(Boolean.parseBoolean(config.getSettingValue()));
            }
            if (config.getSettingKey().equals("spot_prices_buy")) {
                configuration.setSpotPricesBuy(Boolean.parseBoolean(config.getSettingValue()));
            }
            if (config.getSettingKey().equals("spot_price_buy_extra")) {
                configuration.setSpotPriceBuyExtra(Float.parseFloat(config.getSettingValue()));
            }
            if (config.getSettingKey().equals("spot_price_sell_extra")) {
                configuration.setSpotPriceSellExtra(Float.parseFloat(config.getSettingValue()));
            }
            if (config.getSettingKey().equals("energy_currency")) {
                configuration.setEnergyCurrency(config.getSettingValue());
            }
            if (config.getSettingKey().equals("wallbox_ip_address")) {
                configuration.setWallboxIpAddress(config.getSettingValue());
            }
            if (config.getSettingKey().equals("wallbox_password")) {
                configuration.setWallboxPassword(config.getSettingValue());
            }
            if (config.getSettingKey().equals("sunnyhome_click_user")) {
                configuration.setSunnyHomeClickUsername(config.getSettingValue());
            }
            if (config.getSettingKey().equals("sunnyhome_click_token")) {
                configuration.setSunnyHomeClickToken(config.getSettingValue());
            }
            if (config.getSettingKey().equals("sunnyhome_click_email")) {
                configuration.setSunnyHomeClickEmail(config.getSettingValue());
            }
            if (config.getSettingKey().equals("sunnyhome_click_allowed_users")) {
                configuration.setSunnyHomeClickAllowedUsers(config.getSettingValue());
            }
            if (config.getSettingKey().equals("sunnyhome_click_collect_users")) {
                configuration.setSunnyHomeClickCollectUsers(config.getSettingValue());
            }
            if (config.getSettingKey().equals("spot_prices_collector")) {
                configuration.setSpotPricesCollector(config.getSettingValue());
            }
            if (config.getSettingKey().equals("debug_mode")) {
                configuration.setDebugMode(Boolean.parseBoolean(config.getSettingValue()));
            }
            if (!config.getSettingKey().equals("open_weather_api_key")) continue;
            configuration.setOpenWeatherApiKey(config.getSettingValue());
        }
        return configuration;
    }

    public void saveAsMainConfiguration(MainConfiguration mainConfiguration) {
        this.saveSetting("total_panel_power_installed", Float.toString(mainConfiguration.getTotalPanelPowerInstalled()));
        this.saveSetting("latitude", Float.toString(mainConfiguration.getLatitude()));
        this.saveSetting("longitude", Float.toString(mainConfiguration.getLongitude()));
        this.saveSetting("solax_local_ip_address", mainConfiguration.getSolaxLocalIpAddress());
        this.saveSetting("remote_data_storage", mainConfiguration.getRemoteDataStorage());
        this.saveSetting("automation", Boolean.toString(mainConfiguration.isAutomation()));
        this.saveSetting("user_name", mainConfiguration.getUserName());
        if (!mainConfiguration.getPassword().isEmpty()) {
            PasswordEncoder encoder = PasswordEncoderFactories.createDelegatingPasswordEncoder();
            mainConfiguration.setPassword(encoder.encode((CharSequence)mainConfiguration.getPassword()));
            this.saveSetting("password", mainConfiguration.getPassword());
            System.out.println("Password is not empty, saving: " + this.getSetting("password"));
        } else {
            System.out.println("Password is empty, saving: " + this.getSetting("password"));
            this.saveSetting("password", this.getSetting("password"));
        }
        this.saveSetting("energy_price_per_kwh", Float.toString(mainConfiguration.getEnergyPricePerKwh()));
        this.saveSetting("energy_price_per_kwh_sell", Float.toString(mainConfiguration.getEnergyPricePerKwhSell()));
        this.saveSetting("away_mode", Boolean.toString(mainConfiguration.isAwayMode()));
        this.saveSetting("influxdb_url", mainConfiguration.getInfluxdbUrl());
        this.saveSetting("influxdb_apitoken", mainConfiguration.getInfluxdbApitoken());
        this.saveSetting("influxdb_bucket", mainConfiguration.getInfluxdbBucket());
        this.saveSetting("influxdb_org", mainConfiguration.getInfluxdbOrg());
        this.saveSetting("language", mainConfiguration.getLanguage());
        this.saveSetting("send_data_to_sunnymap", Boolean.toString(mainConfiguration.isSendDataToSunnymap()));
        this.saveSetting("sunnymap_token", mainConfiguration.getSunnymapToken());
        this.saveSetting("spot_prices", Boolean.toString(mainConfiguration.isSpotPrices()));
        this.saveSetting("spot_prices_buy", Boolean.toString(mainConfiguration.isSpotPricesBuy()));
        this.saveSetting("energy_currency", mainConfiguration.getEnergyCurrency());
        this.saveSetting("wallbox_ip_address", mainConfiguration.getWallboxIpAddress());
        this.saveSetting("wallbox_password", mainConfiguration.getWallboxPassword());
        this.saveSetting("spot_price_buy_extra", Float.toString(mainConfiguration.getSpotPriceBuyExtra()));
        this.saveSetting("spot_price_sell_extra", Float.toString(mainConfiguration.getSpotPriceSellExtra()));
        this.saveSetting("sunnyhome_click_user", mainConfiguration.getSunnyHomeClickUsername().trim());
        this.saveSetting("sunnyhome_click_token", mainConfiguration.getSunnyHomeClickToken().trim());
        this.saveSetting("sunnyhome_click_email", mainConfiguration.getSunnyHomeClickEmail().trim());
        this.saveSetting("sunnyhome_click_allowed_users", mainConfiguration.getSunnyHomeClickAllowedUsers().trim());
        this.saveSetting("sunnyhome_click_collect_users", mainConfiguration.getSunnyHomeClickCollectUsers().trim());
        this.saveSetting("debug_mode", Boolean.toString(mainConfiguration.isDebugMode()));
        this.saveSetting("spot_prices_collector", mainConfiguration.getSpotPricesCollector());
        this.saveSetting("open_weather_api_key", mainConfiguration.getOpenWeatherApiKey());
    }

    @PostConstruct
    public void IntroMessage() {
        System.out.println("SERVER IS RUNNING ON: https://localhost:8802 - open your browser and enter this address to open the application.");
    }
}

