/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services;

import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.domain.InfoData;
import cz.snyll.sunny.domain.SmartInverterAutomation;
import cz.snyll.sunny.domain.inverter.Inverter;
import cz.snyll.sunny.repositories.InverterRepository;
import cz.snyll.sunny.repositories.SmartInverterAutomationRepository;
import cz.snyll.sunny.services.EventEntryManagerService;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.collectors.DataCollectorAbstractService;
import cz.snyll.sunny.services.collectors.collectorfactories.InverterCollectorFactory;
import jakarta.persistence.EntityNotFoundException;
import jakarta.transaction.Transactional;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InverterManagerService
extends DataCollectorAbstractService {
    private static final Logger log = LoggerFactory.getLogger(InverterManagerService.class);
    private final EventEntryManagerService eventEntryManagerService;
    private final InverterRepository inverterRepository;
    private final InverterCollectorFactory inverterCollectorFactory;
    private final InfoDataManagerService infoDataManagerService;
    private final SmartInverterAutomationRepository smartInverterAutomationRepository;

    @Autowired
    public InverterManagerService(InverterRepository inverterRepository, EventEntryManagerService eventEntryManagerService, InverterCollectorFactory inverterCollectorFactory, InfoDataManagerService infoDataManagerService, SmartInverterAutomationRepository smartInverterAutomationRepository) {
        super(infoDataManagerService);
        this.eventEntryManagerService = eventEntryManagerService;
        this.inverterRepository = inverterRepository;
        this.inverterCollectorFactory = inverterCollectorFactory;
        this.infoDataManagerService = infoDataManagerService;
        this.smartInverterAutomationRepository = smartInverterAutomationRepository;
    }

    public void saveInverter(Inverter inverter) {
        if (inverter.getId() == null) {
            this.eventEntryManagerService.raiseEvent("INVERTER: Adding new inverter with name: " + inverter.getInverterName(), EventEntry.EventType.SUCCESS);
        }
        this.eventEntryManagerService.raiseEvent("INVERTER: Adding new inverter with name: " + inverter.getInverterName() + "; id " + inverter.getId(), EventEntry.EventType.SUCCESS);
        Inverter savedInverter = (Inverter)this.inverterRepository.save((Object)inverter);
        this.inverterCollectorFactory.updateCollectorCache(savedInverter);
    }

    public void deleteInverter(Inverter inverter) {
        this.inverterRepository.deleteById((Object)inverter.getId());
        this.inverterCollectorFactory.removeCollectorFromCache(inverter.getId());
        this.eventEntryManagerService.raiseEvent("INVERTER: Inverter deleted. Name: " + inverter.getInverterName(), EventEntry.EventType.WARNING);
    }

    @Transactional
    public void deleteInverterById(Long inverterId) {
        Inverter inverter = (Inverter)this.inverterRepository.findById((Object)inverterId).orElseThrow(() -> new EntityNotFoundException("Inverter not found with ID: " + inverterId));
        for (SmartInverterAutomation automation : inverter.getAppliedAutomations()) {
            automation.getInvertersApplied().remove(inverter);
            this.smartInverterAutomationRepository.save((Object)automation);
        }
        this.inverterRepository.deleteById((Object)inverterId);
    }

    public Inverter loadInverter(Long id) {
        return this.inverterRepository.findById((Object)id).orElse(null);
    }

    public ArrayList<Inverter> loadAll() {
        return (ArrayList)this.inverterRepository.findAll();
    }

    public void concatenateInvertersData() {
        HashSet invertersData = new HashSet();
        ArrayList inverters = this.loadAll();
        if (inverters.size() == 1) {
            return;
        }
        inverters.forEach(inverter -> {
            try {
                invertersData.addAll(this.infoDataManagerService.findByPrefix("inverter_" + inverter.getId() + "_"));
            }
            catch (Exception e) {
                log.error("Error while loading inverter data for inverter " + inverter.getId(), (Throwable)e);
            }
        });
        HashSet<String> processedKeys = new HashSet<String>();
        HashMap<String, AbstractMap.SimpleEntry<String, String>> mapToSend = new HashMap<String, AbstractMap.SimpleEntry<String, String>>();
        for (InfoData data : invertersData) {
            InfoData updatedInfoData;
            InfoData updatedInfoData2;
            InfoData updatedInfoData3;
            List<InfoData> dataList;
            String keyWithoutPrefix = data.getDataKey().replaceFirst("inverter_\\d+_", "");
            if (processedKeys.contains(keyWithoutPrefix) || (dataList = invertersData.stream().filter(d -> d.getDataKey().endsWith(keyWithoutPrefix)).toList()).isEmpty()) continue;
            processedKeys.add(keyWithoutPrefix);
            double sumA = 0.0;
            double sumW = 0.0;
            double sumkWh = 0.0;
            double sumV = 0.0;
            double sumHz = 0.0;
            double sumPct = 0.0;
            double sumCelsius = 0.0;
            int countV = 0;
            int countHz = 0;
            int countPct = 0;
            int countCelsius = 0;
            int countA = 0;
            int countkWh = 0;
            int countW = 0;
            StringBuilder noUnitValues = new StringBuilder();
            block19: for (InfoData d2 : dataList) {
                switch (d2.getUnits()) {
                    case "A": {
                        sumA += (double)d2.floatValue().floatValue();
                        ++countA;
                        continue block19;
                    }
                    case "W": {
                        sumW += (double)d2.floatValue().floatValue();
                        ++countW;
                        continue block19;
                    }
                    case "kWh": {
                        sumkWh += (double)d2.floatValue().floatValue();
                        ++countkWh;
                        continue block19;
                    }
                    case "V": {
                        sumV += (double)d2.floatValue().floatValue();
                        ++countV;
                        continue block19;
                    }
                    case "Hz": {
                        sumHz += (double)d2.floatValue().floatValue();
                        ++countHz;
                        continue block19;
                    }
                    case "%": {
                        sumPct += (double)d2.floatValue().floatValue();
                        ++countPct;
                        continue block19;
                    }
                    case "\u00b0C": {
                        sumCelsius += (double)d2.floatValue().floatValue();
                        ++countCelsius;
                        continue block19;
                    }
                }
                if (!d2.getUnits().equals("-") && !d2.getUnits().isEmpty()) continue;
                if (keyWithoutPrefix.toLowerCase().contains("restarted") || keyWithoutPrefix.toLowerCase().contains("reset") || keyWithoutPrefix.toLowerCase().contains("date")) {
                    if (!noUnitValues.isEmpty() && d2.getDataValue().compareTo(noUnitValues.toString()) <= 0) continue;
                    noUnitValues.setLength(0);
                    noUnitValues.append(d2.getDataValue());
                    continue;
                }
                if (!noUnitValues.isEmpty()) {
                    noUnitValues.append(", ");
                }
                noUnitValues.append(d2.getDataValue());
            }
            double meanV = 0.0;
            if (countV > 0 && (updatedInfoData3 = this.updateOrCreateInfoData(keyWithoutPrefix, String.valueOf(meanV = sumV / (double)countV), "V", true)) != null) {
                mapToSend.put(updatedInfoData3.getDataKey(), new AbstractMap.SimpleEntry<String, String>(updatedInfoData3.getDataValue(), updatedInfoData3.getUnits()));
            }
            double meanHz = 0.0;
            if (countHz > 0 && (updatedInfoData2 = this.updateOrCreateInfoData(keyWithoutPrefix, String.valueOf(meanHz = sumHz / (double)countHz), "Hz", true)) != null) {
                mapToSend.put(updatedInfoData2.getDataKey(), new AbstractMap.SimpleEntry<String, String>(updatedInfoData2.getDataValue(), updatedInfoData2.getUnits()));
            }
            double meanPct = 0.0;
            if (countPct > 0 && (updatedInfoData = this.updateOrCreateInfoData(keyWithoutPrefix, String.valueOf(meanPct = sumPct / (double)countPct), "%", true)) != null) {
                mapToSend.put(updatedInfoData.getDataKey(), new AbstractMap.SimpleEntry<String, String>(updatedInfoData.getDataValue(), updatedInfoData.getUnits()));
            }
            updatedInfoData = null;
            double meanCelsius = 0.0;
            if (countCelsius > 0 && (updatedInfoData = this.updateOrCreateInfoData(keyWithoutPrefix, String.valueOf(meanCelsius = sumCelsius / (double)countCelsius), "\u00b0C", true)) != null) {
                mapToSend.put(updatedInfoData.getDataKey(), new AbstractMap.SimpleEntry<String, String>(updatedInfoData.getDataValue(), updatedInfoData.getUnits()));
            }
            if ((updatedInfoData = this.updateOrCreateInfoData(keyWithoutPrefix, String.valueOf(sumA), "A", countA > 0)) != null) {
                mapToSend.put(updatedInfoData.getDataKey(), new AbstractMap.SimpleEntry<String, String>(updatedInfoData.getDataValue(), updatedInfoData.getUnits()));
            }
            if ((updatedInfoData = this.updateOrCreateInfoData(keyWithoutPrefix, String.valueOf(sumW), "W", countW > 0)) != null) {
                mapToSend.put(updatedInfoData.getDataKey(), new AbstractMap.SimpleEntry<String, String>(updatedInfoData.getDataValue(), updatedInfoData.getUnits()));
            }
            if ((updatedInfoData = this.updateOrCreateInfoData(keyWithoutPrefix, String.valueOf(sumkWh), "kWh", countkWh > 0)) != null) {
                mapToSend.put(updatedInfoData.getDataKey(), new AbstractMap.SimpleEntry<String, String>(updatedInfoData.getDataValue(), updatedInfoData.getUnits()));
            }
            if (noUnitValues.isEmpty() || (updatedInfoData = this.updateOrCreateInfoData(keyWithoutPrefix, noUnitValues.toString(), "", true)) == null) continue;
            mapToSend.put(updatedInfoData.getDataKey(), new AbstractMap.SimpleEntry<String, String>(updatedInfoData.getDataValue(), updatedInfoData.getUnits()));
        }
        this.saveinfodata(mapToSend);
    }

    private InfoData updateOrCreateInfoData(String key, String value, String units, boolean condition) {
        if (!condition) {
            return null;
        }
        InfoData existingData = this.infoDataManagerService.findByDataKey(key);
        if (existingData != null) {
            existingData.setDataValue(value);
            existingData.setDataFreshness(new Date());
            existingData.setUnits(units);
            return this.infoDataManagerService.save(existingData, false);
        }
        return this.infoDataManagerService.save(new InfoData(key, value, units, 600), false);
    }

    public HashMap<String, Map.Entry<String, String>> collectData() {
        return null;
    }
}

