/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.DeviceControllers;

import com.fasterxml.jackson.databind.JsonNode;
import cz.snyll.sunny.domain.Device;
import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.services.DeviceControllers.DeviceController;
import cz.snyll.sunny.services.DeviceControllers.ShellyController;
import cz.snyll.sunny.services.DeviceControllers.ShellyRestService;
import cz.snyll.sunny.services.EventEntryManagerService;

public class ShellyPro4PMController
extends ShellyController
implements DeviceController {
    private JsonNode statusJSON;

    public ShellyPro4PMController(Device device, EventEntryManagerService eventEntryManagerService, ShellyRestService shellyRestService) {
        super(device, eventEntryManagerService, ShellyController.ShellyGen.gen2, shellyRestService);
        super.setTurnOnUrl("/rpc/Switch.Set?id=" + this.getDevice().getRelayMeterNumber() + "&on=true");
        super.setTurnOffUrl("/rpc/Switch.Set?id=" + this.getDevice().getRelayMeterNumber() + "&on=false");
        super.setStatusUrl("/rpc/Switch.GetStatus?id=" + this.getDevice().getRelayMeterNumber());
    }

    public float getCurrentConsumption() {
        try {
            float consumption = Float.parseFloat(this.statusJSON.get("apower").toString());
            return consumption;
        }
        catch (Exception e) {
            this.getEventEntryManagerService().raiseEvent("DEVICE INFO: " + this.getDevice().getDeviceName() + " -Could not parse consumption.", EventEntry.EventType.WARNING, 60);
            return 0.0f;
        }
    }

    public float getTotalConsumption() {
        try {
            float consumption = Float.parseFloat(this.statusJSON.get("aenergy").get("total").toString()) / 1000.0f;
            return consumption;
        }
        catch (Exception e) {
            this.getEventEntryManagerService().raiseEvent("DEVICE INFO: " + this.getDevice().getDeviceName() + " - Could not parse total consumption.", EventEntry.EventType.WARNING, 60);
            return 0.0f;
        }
    }

    public float getTodayConsumption() {
        try {
            float consumption = Float.parseFloat(this.statusJSON.get("aenergy").get("total").toString()) / 1000.0f;
            if (consumption <= this.getDevice().getDeviceStatus().getLastDayTotalConsumption()) {
                return 0.0f;
            }
            if ((consumption -= this.getDevice().getDeviceStatus().getLastDayTotalConsumption()) < 0.0f) {
                return 0.0f;
            }
            return consumption;
        }
        catch (Exception e) {
            this.getEventEntryManagerService().raiseEvent("DEVICE INFO: " + this.getDevice().getDeviceName() + " - Could not parse total consumption.", EventEntry.EventType.WARNING, 60);
            return 0.0f;
        }
    }

    public boolean getActualStatus() {
        try {
            return this.statusJSON.get("output").asBoolean();
        }
        catch (Exception e) {
            this.getEventEntryManagerService().raiseEvent("DEVICE INFO: " + this.getDevice().getDeviceName() + " - Could not parse actual status.", EventEntry.EventType.WARNING, 60);
            return false;
        }
    }

    public float getTemperature() {
        try {
            return Float.parseFloat(this.statusJSON.get("temperature").get("tC").toString());
        }
        catch (Exception e) {
            this.getEventEntryManagerService().raiseEvent("DEVICE INFO: " + this.getDevice().getDeviceName() + " - Could not parse actual temperature.", EventEntry.EventType.WARNING, 60);
            return 0.0f;
        }
    }

    public void refreshData() {
        this.statusJSON = this.getCurrentData();
    }
}

