/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.DeviceControllers;

import com.fasterxml.jackson.databind.JsonNode;
import cz.snyll.sunny.domain.Device;
import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.services.DeviceControllers.DeviceController;
import cz.snyll.sunny.services.DeviceControllers.ShellyController;
import cz.snyll.sunny.services.DeviceControllers.ShellyRestService;
import cz.snyll.sunny.services.EventEntryManagerService;

public class ShellyPlugSController
extends ShellyController
implements DeviceController {
    private JsonNode statusJSON;

    public ShellyPlugSController(Device device, EventEntryManagerService eventEntryManagerService, ShellyRestService shellyRestService) {
        super(device, eventEntryManagerService, ShellyController.ShellyGen.gen1, shellyRestService);
        String turnOnUrl = "/relay/0/?turn=on";
        super.setTurnOnUrl(turnOnUrl);
        String turnOffUrl = "/relay/0/?turn=off";
        super.setTurnOffUrl(turnOffUrl);
        String statusUrl = "/status";
        super.setStatusUrl(statusUrl);
    }

    public void refreshData() {
        this.statusJSON = this.getCurrentData();
    }

    public float getCurrentConsumption() {
        try {
            return Float.parseFloat(this.statusJSON.get("meters").get(0).get("power").toString());
        }
        catch (Exception e) {
            this.getEventEntryManagerService().raiseEvent("DEVICE INFO: " + this.getDevice().getDeviceName() + " -Could not parse consumption.", EventEntry.EventType.WARNING, 60);
            return 0.0f;
        }
    }

    public float getTotalConsumption() {
        try {
            return Float.parseFloat(this.statusJSON.get("meters").get(0).get("total").toString()) * 1.7E-5f;
        }
        catch (Exception e) {
            this.getEventEntryManagerService().raiseEvent("DEVICE INFO: " + this.getDevice().getDeviceName() + " - Could not parse total consumption.", EventEntry.EventType.WARNING, 60);
            return 0.0f;
        }
    }

    public float getTodayConsumption() {
        try {
            float consumption = Float.parseFloat(this.statusJSON.get("meters").get(0).get("total").toString()) * 1.7E-5f;
            if (consumption <= this.getDevice().getDeviceStatus().getLastDayTotalConsumption()) {
                return 0.0f;
            }
            if ((consumption -= this.getDevice().getDeviceStatus().getLastDayTotalConsumption()) < 0.0f) {
                return 0.0f;
            }
            return consumption;
        }
        catch (Exception e) {
            this.getEventEntryManagerService().raiseEvent("DEVICE INFO: " + this.getDevice().getDeviceName() + " - Could not parse total consumption.", EventEntry.EventType.WARNING, 60);
            return 0.0f;
        }
    }

    public boolean getActualStatus() {
        try {
            return this.statusJSON.get("relays").get(0).get("ison").asBoolean();
        }
        catch (Exception e) {
            this.getEventEntryManagerService().raiseEvent("DEVICE INFO: " + this.getDevice().getDeviceName() + " - Could not parse actual status.", EventEntry.EventType.WARNING, 60);
            return false;
        }
    }

    public float getTemperature() {
        try {
            return Float.parseFloat(this.statusJSON.get("temperature").toString());
        }
        catch (Exception e) {
            this.getEventEntryManagerService().raiseEvent("Device: " + this.getDevice().getDeviceName() + ": Could not parse temperature - " + e.getMessage(), EventEntry.EventType.ERROR, 60);
            return 0.0f;
        }
    }
}

