/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.DeviceControllers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import cz.snyll.sunny.domain.Device;
import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.services.DeviceControllers.DeviceController;
import cz.snyll.sunny.services.DeviceControllers.ShellyController;
import cz.snyll.sunny.services.DeviceControllers.ShellyRestService;
import cz.snyll.sunny.services.EventEntryManagerService;
import java.util.Objects;
import org.springframework.web.client.RestTemplate;

public abstract class ShellyController
implements DeviceController {
    private Device device;
    private EventEntryManagerService eventEntryManagerService;
    private RestTemplate restTemplate;
    private String turnOnUrl;
    private String turnOffUrl;
    private String statusUrl;
    private ShellyGen shellyGen;
    private ShellyRestService shellyRestService;
    public final float WH_KWH_CONSTANT = 1.7E-5f;

    public ShellyController(Device device, EventEntryManagerService eventEntryManagerService, ShellyGen shellyGen, ShellyRestService shellyRestService) {
        this.device = device;
        this.eventEntryManagerService = eventEntryManagerService;
        this.shellyGen = shellyGen;
        this.shellyRestService = shellyRestService;
        this.initializeRestTemplate();
    }

    public Device getControlledDevice() {
        return this.device;
    }

    public JsonNode getCurrentData() {
        try {
            String url = "http://" + this.device.getDeviceIP() + this.getStatusUrl();
            String response = (String)this.restTemplate.getForObject(url, String.class, new Object[0]);
            ObjectMapper mapper = new ObjectMapper();
            return mapper.readTree(response);
        }
        catch (Exception e) {
            this.getEventEntryManagerService().raiseEvent("DEVICE INFO: " + this.getDevice().getDeviceName() + " - Could not retrieve API data. Check IP address of this device.", EventEntry.EventType.WARNING, 60);
            return null;
        }
    }

    private void initializeRestTemplate() {
        boolean isPasswordProvided;
        boolean isUsernameProvided = this.device.getShellyUsername() != null && !this.device.getShellyUsername().isEmpty();
        boolean bl = isPasswordProvided = this.device.getShellyPassword() != null && !this.device.getShellyPassword().isEmpty();
        if (!isUsernameProvided || !isPasswordProvided) {
            this.restTemplate = this.shellyRestService.getRestTemplate();
            return;
        }
        switch (1.$SwitchMap$cz$snyll$sunny$services$DeviceControllers$ShellyController$ShellyGen[this.shellyGen.ordinal()]) {
            case 1: {
                this.restTemplate = this.shellyRestService.getBasicAuthRestTemplate(this.device.getShellyUsername(), this.device.getShellyPassword());
                break;
            }
            case 2: 
            case 3: {
                this.restTemplate = this.shellyRestService.getDigestAuthRestTemplate(this.device.getShellyUsername(), this.device.getShellyPassword());
                break;
            }
            default: {
                this.restTemplate = this.shellyRestService.getRestTemplate();
            }
        }
    }

    public boolean turnOffDevice() {
        try {
            String url = "http://" + this.device.getDeviceIP() + this.turnOffUrl;
            this.restTemplate.getForObject(url, String.class, new Object[0]);
            return true;
        }
        catch (Exception e) {
            this.eventEntryManagerService.raiseEvent("Device: " + this.device.getDeviceName() + ": Error when turning OFF - " + e.getMessage(), EventEntry.EventType.ERROR, 60);
            return false;
        }
    }

    public boolean turnOnDevice() {
        try {
            String url = "http://" + this.device.getDeviceIP() + this.turnOnUrl;
            this.restTemplate.getForObject(url, String.class, new Object[0]);
            return true;
        }
        catch (Exception e) {
            this.eventEntryManagerService.raiseEvent("Device: " + this.device.getDeviceName() + ": Error when turning ON - " + e.getMessage(), EventEntry.EventType.ERROR, 60);
            return false;
        }
    }

    public Device getDevice() {
        return this.device;
    }

    public EventEntryManagerService getEventEntryManagerService() {
        return this.eventEntryManagerService;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public String getTurnOnUrl() {
        return this.turnOnUrl;
    }

    public String getTurnOffUrl() {
        return this.turnOffUrl;
    }

    public String getStatusUrl() {
        return this.statusUrl;
    }

    public ShellyGen getShellyGen() {
        return this.shellyGen;
    }

    public ShellyRestService getShellyRestService() {
        return this.shellyRestService;
    }

    public float getWH_KWH_CONSTANT() {
        Objects.requireNonNull(this);
        return 1.7E-5f;
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    public void setEventEntryManagerService(EventEntryManagerService eventEntryManagerService) {
        this.eventEntryManagerService = eventEntryManagerService;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public void setTurnOnUrl(String turnOnUrl) {
        this.turnOnUrl = turnOnUrl;
    }

    public void setTurnOffUrl(String turnOffUrl) {
        this.turnOffUrl = turnOffUrl;
    }

    public void setStatusUrl(String statusUrl) {
        this.statusUrl = statusUrl;
    }

    public void setShellyGen(ShellyGen shellyGen) {
        this.shellyGen = shellyGen;
    }

    public void setShellyRestService(ShellyRestService shellyRestService) {
        this.shellyRestService = shellyRestService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShellyController)) {
            return false;
        }
        ShellyController other = (ShellyController)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (Float.compare(this.getWH_KWH_CONSTANT(), other.getWH_KWH_CONSTANT()) != 0) {
            return false;
        }
        Device this$device = this.getDevice();
        Device other$device = other.getDevice();
        if (this$device == null ? other$device != null : !this$device.equals(other$device)) {
            return false;
        }
        EventEntryManagerService this$eventEntryManagerService = this.getEventEntryManagerService();
        EventEntryManagerService other$eventEntryManagerService = other.getEventEntryManagerService();
        if (this$eventEntryManagerService == null ? other$eventEntryManagerService != null : !this$eventEntryManagerService.equals(other$eventEntryManagerService)) {
            return false;
        }
        RestTemplate this$restTemplate = this.getRestTemplate();
        RestTemplate other$restTemplate = other.getRestTemplate();
        if (this$restTemplate == null ? other$restTemplate != null : !this$restTemplate.equals(other$restTemplate)) {
            return false;
        }
        String this$turnOnUrl = this.getTurnOnUrl();
        String other$turnOnUrl = other.getTurnOnUrl();
        if (this$turnOnUrl == null ? other$turnOnUrl != null : !this$turnOnUrl.equals(other$turnOnUrl)) {
            return false;
        }
        String this$turnOffUrl = this.getTurnOffUrl();
        String other$turnOffUrl = other.getTurnOffUrl();
        if (this$turnOffUrl == null ? other$turnOffUrl != null : !this$turnOffUrl.equals(other$turnOffUrl)) {
            return false;
        }
        String this$statusUrl = this.getStatusUrl();
        String other$statusUrl = other.getStatusUrl();
        if (this$statusUrl == null ? other$statusUrl != null : !this$statusUrl.equals(other$statusUrl)) {
            return false;
        }
        ShellyGen this$shellyGen = this.getShellyGen();
        ShellyGen other$shellyGen = other.getShellyGen();
        if (this$shellyGen == null ? other$shellyGen != null : !this$shellyGen.equals(other$shellyGen)) {
            return false;
        }
        ShellyRestService this$shellyRestService = this.getShellyRestService();
        ShellyRestService other$shellyRestService = other.getShellyRestService();
        return !(this$shellyRestService == null ? other$shellyRestService != null : !this$shellyRestService.equals(other$shellyRestService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShellyController;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getWH_KWH_CONSTANT());
        Device $device = this.getDevice();
        result = result * 59 + ($device == null ? 43 : $device.hashCode());
        EventEntryManagerService $eventEntryManagerService = this.getEventEntryManagerService();
        result = result * 59 + ($eventEntryManagerService == null ? 43 : $eventEntryManagerService.hashCode());
        RestTemplate $restTemplate = this.getRestTemplate();
        result = result * 59 + ($restTemplate == null ? 43 : $restTemplate.hashCode());
        String $turnOnUrl = this.getTurnOnUrl();
        result = result * 59 + ($turnOnUrl == null ? 43 : $turnOnUrl.hashCode());
        String $turnOffUrl = this.getTurnOffUrl();
        result = result * 59 + ($turnOffUrl == null ? 43 : $turnOffUrl.hashCode());
        String $statusUrl = this.getStatusUrl();
        result = result * 59 + ($statusUrl == null ? 43 : $statusUrl.hashCode());
        ShellyGen $shellyGen = this.getShellyGen();
        result = result * 59 + ($shellyGen == null ? 43 : $shellyGen.hashCode());
        ShellyRestService $shellyRestService = this.getShellyRestService();
        result = result * 59 + ($shellyRestService == null ? 43 : $shellyRestService.hashCode());
        return result;
    }

    public String toString() {
        return "ShellyController(device=" + this.getDevice() + ", eventEntryManagerService=" + this.getEventEntryManagerService() + ", restTemplate=" + this.getRestTemplate() + ", turnOnUrl=" + this.getTurnOnUrl() + ", turnOffUrl=" + this.getTurnOffUrl() + ", statusUrl=" + this.getStatusUrl() + ", shellyGen=" + this.getShellyGen() + ", shellyRestService=" + this.getShellyRestService() + ", WH_KWH_CONSTANT=" + this.getWH_KWH_CONSTANT() + ")";
    }
}

