/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.DeviceControllers;

import com.fasterxml.jackson.databind.JsonNode;
import cz.snyll.sunny.domain.Device;
import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.services.DeviceControllers.DeviceController;
import cz.snyll.sunny.services.DeviceControllers.ShellyController;
import cz.snyll.sunny.services.DeviceControllers.ShellyRestService;
import cz.snyll.sunny.services.EventEntryManagerService;

public class ShellyAddonDS18B20Controller
extends ShellyController
implements DeviceController {
    private JsonNode statusJSON;

    public ShellyAddonDS18B20Controller(Device device, EventEntryManagerService eventEntryManagerService, ShellyRestService shellyRestService) {
        super(device, eventEntryManagerService, ShellyController.ShellyGen.gen2, shellyRestService);
        String statusUrl = "/rpc/Temperature.GetStatus?id=";
        super.setStatusUrl(statusUrl + device.getRelayMeterNumber());
    }

    public float getCurrentConsumption() {
        return 0.0f;
    }

    public float getTotalConsumption() {
        return 0.0f;
    }

    public float getTodayConsumption() {
        return 0.0f;
    }

    public boolean getActualStatus() {
        return false;
    }

    public float getTemperature() {
        try {
            return Float.parseFloat(this.statusJSON.get("tC").toString());
        }
        catch (Exception e) {
            this.getEventEntryManagerService().raiseEvent("DEVICE INFO: " + this.getDevice().getDeviceName() + " - Could not parse temperature.", EventEntry.EventType.WARNING, 60);
            return 0.0f;
        }
    }

    public void refreshData() {
        this.statusJSON = this.getCurrentData();
    }
}

