/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.DeviceControllers;

import com.fasterxml.jackson.databind.JsonNode;
import cz.snyll.sunny.domain.Device;
import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.services.DeviceControllers.DeviceController;
import cz.snyll.sunny.services.DeviceControllers.ShellyController;
import cz.snyll.sunny.services.DeviceControllers.ShellyRestService;
import cz.snyll.sunny.services.EventEntryManagerService;

public class Shelly1PMPlusController
extends ShellyController
implements DeviceController {
    private JsonNode statusJSON;

    public Shelly1PMPlusController(Device device, EventEntryManagerService eventEntryManagerService, ShellyRestService shellyRestService) {
        super(device, eventEntryManagerService, ShellyController.ShellyGen.gen1, shellyRestService);
        String turnOnUrl = "/rpc/Switch.Set?id=0&on=true";
        super.setTurnOnUrl(turnOnUrl);
        String turnOffUrl = "/rpc/Switch.Set?id=0&on=false";
        super.setTurnOffUrl(turnOffUrl);
        String statusUrl = "/rpc/Switch.GetStatus?id=0";
        super.setStatusUrl(statusUrl);
    }

    public float getCurrentConsumption() {
        try {
            return Float.parseFloat(this.statusJSON.get("apower").toString());
        }
        catch (Exception e) {
            this.getEventEntryManagerService().raiseEvent("DEVICE INFO: " + this.getDevice().getDeviceName() + " -Could not parse consumption.", EventEntry.EventType.WARNING, 60);
            return 0.0f;
        }
    }

    public float getTotalConsumption() {
        try {
            return Float.parseFloat(this.statusJSON.get("aenergy").get("total").toString()) / 1000.0f;
        }
        catch (Exception e) {
            this.getEventEntryManagerService().raiseEvent("DEVICE INFO: " + this.getDevice().getDeviceName() + " - Could not parse total consumption.", EventEntry.EventType.WARNING, 60);
            return 0.0f;
        }
    }

    public float getTodayConsumption() {
        try {
            float consumption = Float.parseFloat(this.statusJSON.get("aenergy").get("total").toString()) / 1000.0f;
            if (consumption <= this.getDevice().getDeviceStatus().getLastDayTotalConsumption()) {
                return 0.0f;
            }
            if ((consumption -= this.getDevice().getDeviceStatus().getLastDayTotalConsumption()) < 0.0f) {
                return 0.0f;
            }
            return consumption;
        }
        catch (Exception e) {
            this.getEventEntryManagerService().raiseEvent("DEVICE INFO: " + this.getDevice().getDeviceName() + " - Could not parse total consumption.", EventEntry.EventType.WARNING, 60);
            return 0.0f;
        }
    }

    public boolean getActualStatus() {
        try {
            return this.statusJSON.get("output").asBoolean();
        }
        catch (Exception e) {
            this.getEventEntryManagerService().raiseEvent("DEVICE INFO: " + this.getDevice().getDeviceName() + " - Could not parse actual status.", EventEntry.EventType.WARNING, 60);
            return false;
        }
    }

    public float getTemperature() {
        try {
            return Float.parseFloat(this.statusJSON.get("temperature").get("tC").toString());
        }
        catch (Exception e) {
            this.getEventEntryManagerService().raiseEvent("DEVICE INFO: " + this.getDevice().getDeviceName() + " - Could not parse temperature.", EventEntry.EventType.WARNING, 60);
            return 0.0f;
        }
    }

    public void refreshData() {
        this.statusJSON = this.getCurrentData();
    }
}

