/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services;

import cz.snyll.sunny.domain.DailyRecord;
import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.domain.InfoData;
import cz.snyll.sunny.repositories.DailyRecordRepository;
import cz.snyll.sunny.services.DailyRecordManager;
import cz.snyll.sunny.services.EventEntryManager;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.SunnyConfigurationService;
import cz.snyll.sunny.services.datasenders.SunnyHomeOnlineDailyRecordSender;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DailyRecordManagerService
implements DailyRecordManager {
    private static final Logger log = LoggerFactory.getLogger(DailyRecordManagerService.class);
    DailyRecordRepository dailyRecordRepository;
    InfoDataManagerService infoDataManagerService;
    EventEntryManager eventEntryManager;
    SunnyConfigurationService sunnyConfigurationService;
    SunnyHomeOnlineDailyRecordSender sunnyHomeOnlineDailyRecordSender;

    @Autowired
    public DailyRecordManagerService(SunnyHomeOnlineDailyRecordSender sunnyHomeOnlineDailyRecordSender, DailyRecordRepository dailyRecordRepository, InfoDataManagerService infoDataManagerService, EventEntryManager eventEntryManager, SunnyConfigurationService sunnyConfigurationService) {
        this.dailyRecordRepository = dailyRecordRepository;
        this.infoDataManagerService = infoDataManagerService;
        this.eventEntryManager = eventEntryManager;
        this.sunnyConfigurationService = sunnyConfigurationService;
        this.sunnyHomeOnlineDailyRecordSender = sunnyHomeOnlineDailyRecordSender;
    }

    public void createDailyRecord(int balance, float totalConsumption, float gridConsumption, float gridFeedin, float panelEnergy, float acEnergy, float selfConsumed, float energyPricePerKwh, float energyPricePerKwhSell, float todaySpotEarnings, float todaySpotEarningsLocalCurrency, float todaySpotSavingsLocalCurrency) {
        DailyRecord todayRecord;
        LocalDateTime now = LocalDateTime.now();
        LocalDate nowDate = LocalDate.now();
        if (now.getHour() < 2) {
            nowDate = LocalDate.now().minusDays(1L);
        }
        if ((todayRecord = this.dailyRecordRepository.findByDate(nowDate)) != null) {
            this.eventEntryManager.raiseEvent("Daily Record already exists for date: " + nowDate, EventEntry.EventType.WARNING);
            return;
        }
        DailyRecord dailyRecord = new DailyRecord();
        dailyRecord.setBalance(balance);
        dailyRecord.setTotalConsumption(totalConsumption);
        dailyRecord.setGridConsumption(gridConsumption);
        dailyRecord.setGridFeedin(gridFeedin);
        dailyRecord.setPanelEnergy(panelEnergy);
        dailyRecord.setAcEnergy(acEnergy);
        dailyRecord.setSelfConsumed(selfConsumed);
        dailyRecord.setEnergyPricePerKwh(energyPricePerKwh);
        dailyRecord.setEnergyPricePerKwhSell(energyPricePerKwhSell);
        dailyRecord.setTodaySpotEarnings(todaySpotEarnings);
        dailyRecord.setTodaySpotEarningsLocalCurrency(todaySpotEarningsLocalCurrency);
        dailyRecord.setTodaySpotSavingsLocalCurrency(todaySpotSavingsLocalCurrency);
        dailyRecord.setUpdatedTimestamp(LocalDateTime.now());
        dailyRecord.setDate(nowDate);
        this.dailyRecordRepository.save((Object)dailyRecord);
        this.eventEntryManager.raiseEvent("Daily Record saved: " + dailyRecord, EventEntry.EventType.SUCCESS);
        this.sunnyHomeOnlineDailyRecordSender.SendDailyRecords();
    }

    public ArrayList<DailyRecord> getAllDailyRecords() {
        return (ArrayList)this.dailyRecordRepository.findAll();
    }

    public void saveDailyRecord() {
        try {
            float today_spot_savings_local_currency;
            float today_spot_earnings_local_currency;
            float self_consumed;
            float ac_energy;
            float panel_energy;
            float grid_feedin;
            float balance;
            InfoData infoData_solax_today_self_consumed_yield = this.infoDataManagerService.findByDataKey("solax_today_self_consumed_yield");
            InfoData infoData_solax_today_consumption = this.infoDataManagerService.findByDataKey("solax_today_consumption");
            InfoData infoData_solax_today_battery_grid_charge_energy = this.infoDataManagerService.findByDataKey("solax_today_battery_grid_charge_energy");
            InfoData infoData_solax_today_feedin_energy = this.infoDataManagerService.findByDataKey("solax_today_feedin_energy");
            InfoData infoData_solax_today_energy = this.infoDataManagerService.findByDataKey("solax_today_energy");
            InfoData infoData_solax_today_yield = this.infoDataManagerService.findByDataKey("solax_today_yield");
            InfoData infoData_solax_today_spot_earnings = this.infoDataManagerService.findByDataKey("spot_earnings_today");
            InfoData infoData_solax_today_spot_earnings_local_currency = this.infoDataManagerService.findByDataKey("spot_earnings_today_local_currency");
            InfoData infoData_solax_today_spot_savings_local_currency = this.infoDataManagerService.findByDataKey("spot_savings_today");
            DecimalFormat df = new DecimalFormat("#.##", new DecimalFormatSymbols(Locale.US));
            float total_consumption = this.safeParseFloat(Optional.ofNullable(infoData_solax_today_self_consumed_yield).map(InfoData::getDataValue).orElse("0")) + this.safeParseFloat(Optional.ofNullable(infoData_solax_today_consumption).map(InfoData::getDataValue).orElse("0")) - this.safeParseFloat(Optional.ofNullable(infoData_solax_today_battery_grid_charge_energy).map(InfoData::getDataValue).orElse("0"));
            total_consumption = Float.parseFloat(df.format(total_consumption));
            if (total_consumption < 0.0f) {
                total_consumption = 0.0f;
            }
            float grid_consumption = this.safeParseFloat(Optional.ofNullable(infoData_solax_today_consumption).map(InfoData::getDataValue).orElse("0"));
            float grid_to_home = total_consumption - this.safeParseFloat(Optional.ofNullable(infoData_solax_today_self_consumed_yield).map(InfoData::getDataValue).orElse("0"));
            float f = balance = total_consumption != 0.0f ? 100.0f - grid_to_home / total_consumption * 100.0f : 0.0f;
            if (balance < 0.0f) {
                balance = 0.0f;
            }
            if ((grid_feedin = this.safeParseFloat(Optional.ofNullable(infoData_solax_today_feedin_energy).map(InfoData::getDataValue).orElse("0"))) < 0.0f) {
                grid_feedin = 0.0f;
            }
            if ((panel_energy = this.safeParseFloat(Optional.ofNullable(infoData_solax_today_energy).map(InfoData::getDataValue).orElse("0"))) < 0.0f) {
                panel_energy = 0.0f;
            }
            if ((ac_energy = this.safeParseFloat(Optional.ofNullable(infoData_solax_today_yield).map(InfoData::getDataValue).orElse("0"))) < 0.0f) {
                ac_energy = 0.0f;
            }
            if ((self_consumed = this.safeParseFloat(Optional.ofNullable(infoData_solax_today_self_consumed_yield).map(InfoData::getDataValue).orElse("0"))) < 0.0f) {
                self_consumed = 0.0f;
            }
            float energy_price_per_kwh = this.safeParseFloat(Optional.ofNullable(this.sunnyConfigurationService.getSetting("energy_price_per_kwh")).orElse("0"));
            float energy_price_per_kwh_sell = this.safeParseFloat(Optional.ofNullable(this.sunnyConfigurationService.getSetting("energy_price_per_kwh_sell")).orElse("0"));
            float today_spot_earnings = this.safeParseFloat(Optional.ofNullable(infoData_solax_today_spot_earnings).map(InfoData::getDataValue).orElse("0"));
            if (today_spot_earnings < 0.0f) {
                today_spot_earnings = 0.0f;
            }
            if ((today_spot_earnings_local_currency = this.safeParseFloat(Optional.ofNullable(infoData_solax_today_spot_earnings_local_currency).map(InfoData::getDataValue).orElse("0"))) < 0.0f) {
                today_spot_earnings_local_currency = 0.0f;
            }
            if ((today_spot_savings_local_currency = this.safeParseFloat(Optional.ofNullable(infoData_solax_today_spot_savings_local_currency).map(InfoData::getDataValue).orElse("0"))) < 0.0f) {
                today_spot_savings_local_currency = 0.0f;
            }
            this.createDailyRecord((int)balance, total_consumption, grid_consumption, grid_feedin, panel_energy, ac_energy, self_consumed, energy_price_per_kwh, energy_price_per_kwh_sell, today_spot_earnings, today_spot_earnings_local_currency, today_spot_savings_local_currency);
        }
        catch (Exception e) {
            this.eventEntryManager.raiseEvent("Daily Record saving error: " + e.getMessage(), EventEntry.EventType.ERROR);
        }
    }

    private float safeParseFloat(String str) {
        try {
            return Float.parseFloat(DailyRecordManagerService.replaceCommasWithDots((String)str));
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    private static String replaceCommasWithDots(String input) {
        if (input == null) {
            return "";
        }
        return input.replace(',', '.');
    }
}

