/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.repositories;

import cz.snyll.sunny.domain.EventEntry;
import jakarta.transaction.Transactional;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Set;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.stereotype.Repository;

@Repository
public interface EventRepository
extends CrudRepository<EventEntry, Long> {
    public Set<EventEntry> findByEventType(EventEntry.EventType var1);

    @Query(value="select * from event_entries order by updated_timestamp desc limit ?1", nativeQuery=true)
    public ArrayList<EventEntry> getLastEvents(int var1);

    @Query(value="select * from event_entries where event_message = ?1 order by updated_timestamp desc limit 1", nativeQuery=true)
    public EventEntry getEventEntryWithMessage(String var1);

    @Modifying
    public void deleteByUpdatedTimestampBefore(LocalDateTime var1);

    @Modifying
    @Query(value="DELETE FROM event_entries WHERE rowid NOT IN (SELECT rowid FROM event_entries ORDER BY updated_timestamp DESC LIMIT 10000)", nativeQuery=true)
    @Transactional
    public void deleteAllExceptLast10000();
}

