/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.domain.inverter;

import com.fasterxml.jackson.annotation.JsonIgnore;
import cz.snyll.sunny.domain.SmartInverterAutomation;
import cz.snyll.sunny.domain.inverter.ConnectionDetails;
import cz.snyll.sunny.domain.inverter.Inverter;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Set;

@Entity
@Table(name="inverters")
public class Inverter {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    private String inverterName;
    @Column(name="inverter_manufacturer")
    @Enumerated(value=EnumType.STRING)
    private Manufacturer inverterManufacturer;
    private String inverterSerialNumber;
    @Column(name="active", columnDefinition="boolean default true")
    private Boolean active;
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="connection_details_id", referencedColumnName="id")
    private ConnectionDetails connectionDetails;
    @Column(columnDefinition="integer default 0")
    private int exportLimitCustom;
    @Column(columnDefinition="integer default 0")
    private int exportLimitOriginal;
    @Column(columnDefinition="integer default 0")
    private int chargeLimit;
    @Column(columnDefinition="integer default 0")
    private int dischargeLimit;
    @ManyToMany(mappedBy="invertersApplied", cascade={CascadeType.DETACH})
    @JsonIgnore
    private Set<SmartInverterAutomation> appliedAutomations;
    private LocalDateTime lastDataCollection;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Inverter inverter = (Inverter)o;
        return Objects.equals(this.id, inverter.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public Long getId() {
        return this.id;
    }

    public String getInverterName() {
        return this.inverterName;
    }

    public Manufacturer getInverterManufacturer() {
        return this.inverterManufacturer;
    }

    public String getInverterSerialNumber() {
        return this.inverterSerialNumber;
    }

    public Boolean getActive() {
        return this.active;
    }

    public ConnectionDetails getConnectionDetails() {
        return this.connectionDetails;
    }

    public int getExportLimitCustom() {
        return this.exportLimitCustom;
    }

    public int getExportLimitOriginal() {
        return this.exportLimitOriginal;
    }

    public int getChargeLimit() {
        return this.chargeLimit;
    }

    public int getDischargeLimit() {
        return this.dischargeLimit;
    }

    public Set<SmartInverterAutomation> getAppliedAutomations() {
        return this.appliedAutomations;
    }

    public LocalDateTime getLastDataCollection() {
        return this.lastDataCollection;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setInverterName(String inverterName) {
        this.inverterName = inverterName;
    }

    public void setInverterManufacturer(Manufacturer inverterManufacturer) {
        this.inverterManufacturer = inverterManufacturer;
    }

    public void setInverterSerialNumber(String inverterSerialNumber) {
        this.inverterSerialNumber = inverterSerialNumber;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public void setConnectionDetails(ConnectionDetails connectionDetails) {
        this.connectionDetails = connectionDetails;
    }

    public void setExportLimitCustom(int exportLimitCustom) {
        this.exportLimitCustom = exportLimitCustom;
    }

    public void setExportLimitOriginal(int exportLimitOriginal) {
        this.exportLimitOriginal = exportLimitOriginal;
    }

    public void setChargeLimit(int chargeLimit) {
        this.chargeLimit = chargeLimit;
    }

    public void setDischargeLimit(int dischargeLimit) {
        this.dischargeLimit = dischargeLimit;
    }

    @JsonIgnore
    public void setAppliedAutomations(Set<SmartInverterAutomation> appliedAutomations) {
        this.appliedAutomations = appliedAutomations;
    }

    public void setLastDataCollection(LocalDateTime lastDataCollection) {
        this.lastDataCollection = lastDataCollection;
    }
}

