/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import cz.snyll.sunny.domain.DeviceSetting;
import cz.snyll.sunny.domain.inverter.Inverter;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.Table;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Objects;
import java.util.Set;
import org.hibernate.annotations.UpdateTimestamp;

@Entity
@Table(name="smart_inverter_automations")
public class SmartInverterAutomation {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    private String automationName;
    @NotNull
    private boolean exportLimitEnabled = false;
    @NotNull
    private boolean forceDischargeEnabled = false;
    @NotNull
    private boolean useGridEnabled = false;
    @NotNull
    private boolean chargeEnabled = false;
    private float chargeLimitPrice;
    @Column(name="chargeXHours", columnDefinition="INTEGER DEFAULT 0")
    private int chargeX15MinIntervals;
    @Column(name="dischargeXHours", columnDefinition="INTEGER DEFAULT 0")
    private int dischargeX15MinIntervals;
    @JsonFormat(pattern="HH:mm")
    @Column(columnDefinition="TIME DEFAULT '00:00'")
    private LocalTime chargeStartTime = LocalTime.of(0, 0);
    @JsonFormat(pattern="HH:mm")
    @Column(columnDefinition="TIME DEFAULT '23:59'")
    private LocalTime chargeEndTime = LocalTime.of(23, 59);
    @Column(columnDefinition="FLOAT DEFAULT 0.0")
    private float exportLimitPrice = 0.0f;
    @JsonFormat(pattern="HH:mm")
    @Column(columnDefinition="TIME DEFAULT '00:00'")
    private LocalTime exportLimitStartTime = LocalTime.of(0, 0);
    @JsonFormat(pattern="HH:mm")
    @Column(columnDefinition="TIME DEFAULT '23:59'")
    private LocalTime exportLimitEndTime = LocalTime.of(23, 59);
    @Column(columnDefinition="FLOAT DEFAULT 0.0")
    private float forceDischargePrice = 0.0f;
    @JsonFormat(pattern="HH:mm")
    @Column(columnDefinition="TIME DEFAULT '00:00'")
    private LocalTime forceDischargeStartTime = LocalTime.of(0, 0);
    @JsonFormat(pattern="HH:mm")
    @Column(columnDefinition="TIME DEFAULT '23:59'")
    private LocalTime forceDischargeEndTime = LocalTime.of(23, 59);
    private boolean testMode = false;
    @UpdateTimestamp
    private LocalDateTime lastModified;
    @ManyToMany(fetch=FetchType.EAGER, cascade={CascadeType.DETACH})
    @JoinTable(name="inverter_smartinverterautomation", joinColumns={@JoinColumn(name="smartinverterautomation_id")}, inverseJoinColumns={@JoinColumn(name="inverter_id")})
    private Set<Inverter> invertersApplied;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="devicesetting_smartinverterautomation", joinColumns={@JoinColumn(name="smartinverterautomation_id")}, inverseJoinColumns={@JoinColumn(name="devicesetting_id")})
    private Set<DeviceSetting> automationConditions;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SmartInverterAutomation)) {
            return false;
        }
        SmartInverterAutomation that = (SmartInverterAutomation)o;
        return Objects.equals(this.getId(), that.getId());
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    public Long getId() {
        return this.id;
    }

    public String getAutomationName() {
        return this.automationName;
    }

    public boolean isExportLimitEnabled() {
        return this.exportLimitEnabled;
    }

    public boolean isForceDischargeEnabled() {
        return this.forceDischargeEnabled;
    }

    public boolean isUseGridEnabled() {
        return this.useGridEnabled;
    }

    public boolean isChargeEnabled() {
        return this.chargeEnabled;
    }

    public float getChargeLimitPrice() {
        return this.chargeLimitPrice;
    }

    public int getChargeX15MinIntervals() {
        return this.chargeX15MinIntervals;
    }

    public int getDischargeX15MinIntervals() {
        return this.dischargeX15MinIntervals;
    }

    public LocalTime getChargeStartTime() {
        return this.chargeStartTime;
    }

    public LocalTime getChargeEndTime() {
        return this.chargeEndTime;
    }

    public float getExportLimitPrice() {
        return this.exportLimitPrice;
    }

    public LocalTime getExportLimitStartTime() {
        return this.exportLimitStartTime;
    }

    public LocalTime getExportLimitEndTime() {
        return this.exportLimitEndTime;
    }

    public float getForceDischargePrice() {
        return this.forceDischargePrice;
    }

    public LocalTime getForceDischargeStartTime() {
        return this.forceDischargeStartTime;
    }

    public LocalTime getForceDischargeEndTime() {
        return this.forceDischargeEndTime;
    }

    public boolean isTestMode() {
        return this.testMode;
    }

    public LocalDateTime getLastModified() {
        return this.lastModified;
    }

    public Set<Inverter> getInvertersApplied() {
        return this.invertersApplied;
    }

    public Set<DeviceSetting> getAutomationConditions() {
        return this.automationConditions;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setAutomationName(String automationName) {
        this.automationName = automationName;
    }

    public void setExportLimitEnabled(boolean exportLimitEnabled) {
        this.exportLimitEnabled = exportLimitEnabled;
    }

    public void setForceDischargeEnabled(boolean forceDischargeEnabled) {
        this.forceDischargeEnabled = forceDischargeEnabled;
    }

    public void setUseGridEnabled(boolean useGridEnabled) {
        this.useGridEnabled = useGridEnabled;
    }

    public void setChargeEnabled(boolean chargeEnabled) {
        this.chargeEnabled = chargeEnabled;
    }

    public void setChargeLimitPrice(float chargeLimitPrice) {
        this.chargeLimitPrice = chargeLimitPrice;
    }

    public void setChargeX15MinIntervals(int chargeX15MinIntervals) {
        this.chargeX15MinIntervals = chargeX15MinIntervals;
    }

    public void setDischargeX15MinIntervals(int dischargeX15MinIntervals) {
        this.dischargeX15MinIntervals = dischargeX15MinIntervals;
    }

    @JsonFormat(pattern="HH:mm")
    public void setChargeStartTime(LocalTime chargeStartTime) {
        this.chargeStartTime = chargeStartTime;
    }

    @JsonFormat(pattern="HH:mm")
    public void setChargeEndTime(LocalTime chargeEndTime) {
        this.chargeEndTime = chargeEndTime;
    }

    public void setExportLimitPrice(float exportLimitPrice) {
        this.exportLimitPrice = exportLimitPrice;
    }

    @JsonFormat(pattern="HH:mm")
    public void setExportLimitStartTime(LocalTime exportLimitStartTime) {
        this.exportLimitStartTime = exportLimitStartTime;
    }

    @JsonFormat(pattern="HH:mm")
    public void setExportLimitEndTime(LocalTime exportLimitEndTime) {
        this.exportLimitEndTime = exportLimitEndTime;
    }

    public void setForceDischargePrice(float forceDischargePrice) {
        this.forceDischargePrice = forceDischargePrice;
    }

    @JsonFormat(pattern="HH:mm")
    public void setForceDischargeStartTime(LocalTime forceDischargeStartTime) {
        this.forceDischargeStartTime = forceDischargeStartTime;
    }

    @JsonFormat(pattern="HH:mm")
    public void setForceDischargeEndTime(LocalTime forceDischargeEndTime) {
        this.forceDischargeEndTime = forceDischargeEndTime;
    }

    public void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }

    public void setLastModified(LocalDateTime lastModified) {
        this.lastModified = lastModified;
    }

    public void setInvertersApplied(Set<Inverter> invertersApplied) {
        this.invertersApplied = invertersApplied;
    }

    public void setAutomationConditions(Set<DeviceSetting> automationConditions) {
        this.automationConditions = automationConditions;
    }
}

