/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import cz.snyll.sunny.domain.Device;
import cz.snyll.sunny.domain.DeviceStatus;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;

@Entity
@Table(name="device_statuses")
public class DeviceStatus {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Enumerated(value=EnumType.STRING)
    private OperationStatus currentState;
    private float currentConsumption;
    private float totalConsumption;
    private float todayConsumption;
    private float temperature;
    private float lastDayTotalConsumption;
    private long todayRuntime;
    private long currentRuntime;
    private Date dataFreshness;
    private boolean manualOverride;
    private LocalDateTime overriddenUntil;
    private LocalDateTime lastStateChange;
    private LocalDate dailyResetHappened;
    @OneToOne
    @JsonIgnore
    @JoinColumn(name="device_id", referencedColumnName="id", unique=true)
    private Device device;

    public Long getId() {
        return this.id;
    }

    public OperationStatus getCurrentState() {
        return this.currentState;
    }

    public float getCurrentConsumption() {
        return this.currentConsumption;
    }

    public float getTotalConsumption() {
        return this.totalConsumption;
    }

    public float getTodayConsumption() {
        return this.todayConsumption;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public float getLastDayTotalConsumption() {
        return this.lastDayTotalConsumption;
    }

    public long getTodayRuntime() {
        return this.todayRuntime;
    }

    public long getCurrentRuntime() {
        return this.currentRuntime;
    }

    public Date getDataFreshness() {
        return this.dataFreshness;
    }

    public boolean isManualOverride() {
        return this.manualOverride;
    }

    public LocalDateTime getOverriddenUntil() {
        return this.overriddenUntil;
    }

    public LocalDateTime getLastStateChange() {
        return this.lastStateChange;
    }

    public LocalDate getDailyResetHappened() {
        return this.dailyResetHappened;
    }

    public Device getDevice() {
        return this.device;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCurrentState(OperationStatus currentState) {
        this.currentState = currentState;
    }

    public void setCurrentConsumption(float currentConsumption) {
        this.currentConsumption = currentConsumption;
    }

    public void setTotalConsumption(float totalConsumption) {
        this.totalConsumption = totalConsumption;
    }

    public void setTodayConsumption(float todayConsumption) {
        this.todayConsumption = todayConsumption;
    }

    public void setTemperature(float temperature) {
        this.temperature = temperature;
    }

    public void setLastDayTotalConsumption(float lastDayTotalConsumption) {
        this.lastDayTotalConsumption = lastDayTotalConsumption;
    }

    public void setTodayRuntime(long todayRuntime) {
        this.todayRuntime = todayRuntime;
    }

    public void setCurrentRuntime(long currentRuntime) {
        this.currentRuntime = currentRuntime;
    }

    public void setDataFreshness(Date dataFreshness) {
        this.dataFreshness = dataFreshness;
    }

    public void setManualOverride(boolean manualOverride) {
        this.manualOverride = manualOverride;
    }

    public void setOverriddenUntil(LocalDateTime overriddenUntil) {
        this.overriddenUntil = overriddenUntil;
    }

    public void setLastStateChange(LocalDateTime lastStateChange) {
        this.lastStateChange = lastStateChange;
    }

    public void setDailyResetHappened(LocalDate dailyResetHappened) {
        this.dailyResetHappened = dailyResetHappened;
    }

    @JsonIgnore
    public void setDevice(Device device) {
        this.device = device;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeviceStatus)) {
            return false;
        }
        DeviceStatus other = (DeviceStatus)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (Float.compare(this.getCurrentConsumption(), other.getCurrentConsumption()) != 0) {
            return false;
        }
        if (Float.compare(this.getTotalConsumption(), other.getTotalConsumption()) != 0) {
            return false;
        }
        if (Float.compare(this.getTodayConsumption(), other.getTodayConsumption()) != 0) {
            return false;
        }
        if (Float.compare(this.getTemperature(), other.getTemperature()) != 0) {
            return false;
        }
        if (Float.compare(this.getLastDayTotalConsumption(), other.getLastDayTotalConsumption()) != 0) {
            return false;
        }
        if (this.getTodayRuntime() != other.getTodayRuntime()) {
            return false;
        }
        if (this.getCurrentRuntime() != other.getCurrentRuntime()) {
            return false;
        }
        if (this.isManualOverride() != other.isManualOverride()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        OperationStatus this$currentState = this.getCurrentState();
        OperationStatus other$currentState = other.getCurrentState();
        if (this$currentState == null ? other$currentState != null : !this$currentState.equals(other$currentState)) {
            return false;
        }
        Date this$dataFreshness = this.getDataFreshness();
        Date other$dataFreshness = other.getDataFreshness();
        if (this$dataFreshness == null ? other$dataFreshness != null : !((Object)this$dataFreshness).equals(other$dataFreshness)) {
            return false;
        }
        LocalDateTime this$overriddenUntil = this.getOverriddenUntil();
        LocalDateTime other$overriddenUntil = other.getOverriddenUntil();
        if (this$overriddenUntil == null ? other$overriddenUntil != null : !((Object)this$overriddenUntil).equals(other$overriddenUntil)) {
            return false;
        }
        LocalDateTime this$lastStateChange = this.getLastStateChange();
        LocalDateTime other$lastStateChange = other.getLastStateChange();
        if (this$lastStateChange == null ? other$lastStateChange != null : !((Object)this$lastStateChange).equals(other$lastStateChange)) {
            return false;
        }
        LocalDate this$dailyResetHappened = this.getDailyResetHappened();
        LocalDate other$dailyResetHappened = other.getDailyResetHappened();
        if (this$dailyResetHappened == null ? other$dailyResetHappened != null : !((Object)this$dailyResetHappened).equals(other$dailyResetHappened)) {
            return false;
        }
        Device this$device = this.getDevice();
        Device other$device = other.getDevice();
        return !(this$device == null ? other$device != null : !this$device.equals(other$device));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeviceStatus;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getCurrentConsumption());
        result = result * 59 + Float.floatToIntBits(this.getTotalConsumption());
        result = result * 59 + Float.floatToIntBits(this.getTodayConsumption());
        result = result * 59 + Float.floatToIntBits(this.getTemperature());
        result = result * 59 + Float.floatToIntBits(this.getLastDayTotalConsumption());
        long $todayRuntime = this.getTodayRuntime();
        result = result * 59 + (int)($todayRuntime >>> 32 ^ $todayRuntime);
        long $currentRuntime = this.getCurrentRuntime();
        result = result * 59 + (int)($currentRuntime >>> 32 ^ $currentRuntime);
        result = result * 59 + (this.isManualOverride() ? 79 : 97);
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        OperationStatus $currentState = this.getCurrentState();
        result = result * 59 + ($currentState == null ? 43 : $currentState.hashCode());
        Date $dataFreshness = this.getDataFreshness();
        result = result * 59 + ($dataFreshness == null ? 43 : ((Object)$dataFreshness).hashCode());
        LocalDateTime $overriddenUntil = this.getOverriddenUntil();
        result = result * 59 + ($overriddenUntil == null ? 43 : ((Object)$overriddenUntil).hashCode());
        LocalDateTime $lastStateChange = this.getLastStateChange();
        result = result * 59 + ($lastStateChange == null ? 43 : ((Object)$lastStateChange).hashCode());
        LocalDate $dailyResetHappened = this.getDailyResetHappened();
        result = result * 59 + ($dailyResetHappened == null ? 43 : ((Object)$dailyResetHappened).hashCode());
        Device $device = this.getDevice();
        result = result * 59 + ($device == null ? 43 : $device.hashCode());
        return result;
    }

    public String toString() {
        return "DeviceStatus(id=" + this.getId() + ", currentState=" + this.getCurrentState() + ", currentConsumption=" + this.getCurrentConsumption() + ", totalConsumption=" + this.getTotalConsumption() + ", todayConsumption=" + this.getTodayConsumption() + ", temperature=" + this.getTemperature() + ", lastDayTotalConsumption=" + this.getLastDayTotalConsumption() + ", todayRuntime=" + this.getTodayRuntime() + ", currentRuntime=" + this.getCurrentRuntime() + ", dataFreshness=" + this.getDataFreshness() + ", manualOverride=" + this.isManualOverride() + ", overriddenUntil=" + this.getOverriddenUntil() + ", lastStateChange=" + this.getLastStateChange() + ", dailyResetHappened=" + this.getDailyResetHappened() + ", device=" + this.getDevice() + ")";
    }
}

