/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.controllers;

import cz.snyll.sunny.domain.Trigger;
import cz.snyll.sunny.repositories.TriggerRepository;
import cz.snyll.sunny.services.TriggerManagerService;
import jakarta.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class TriggerController {
    @Autowired
    private TriggerRepository triggerRepository;
    @Autowired
    private TriggerManagerService triggerManagerService;

    @GetMapping(value={"/trigger"})
    public String trigger(Model model, @RequestParam(required=false) Long id) {
        if (id == null) {
            id = 0L;
        }
        Trigger trigger = this.triggerRepository.findById((Object)id).orElseGet(Trigger::new);
        model.addAttribute("trigger", (Object)trigger);
        return "trigger";
    }

    @GetMapping(value={"/trigger/edit"})
    public String triggerEdit(Model model, @RequestParam(required=false) Long id, @RequestParam(required=false) boolean delete) {
        if (delete && id > 0L) {
            try {
                this.triggerManagerService.deleteTriggerById(id.longValue());
            }
            catch (DataIntegrityViolationException e) {
                return "redirect:../triggerlist?deleteerror=true";
            }
            return "redirect:../triggerlist?deletesuccess=true";
        }
        return "redirect:../triggerlist";
    }

    @PostMapping(value={"/trigger"})
    public String triggerSubmit(@Valid @ModelAttribute Trigger trigger, BindingResult result, Model model) {
        model.addAttribute("trigger", (Object)trigger);
        if (result.hasErrors()) {
            return "trigger";
        }
        this.triggerManagerService.saveTrigger(trigger);
        return "redirect:triggerlist?success=true";
    }
}

