/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.controllers;

import cz.snyll.sunny.services.NotificationServiceManager;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class NotificationListController {
    private final NotificationServiceManager notificationServiceManager;

    @Autowired
    public NotificationListController(NotificationServiceManager notificationServiceManager) {
        this.notificationServiceManager = notificationServiceManager;
    }

    @GetMapping(value={"/notificationlist"})
    public String deviceList(Model model, @RequestParam(required=false) boolean success, @RequestParam(required=false) boolean deletesuccess) {
        Iterable emailNotifications = this.notificationServiceManager.loadAll();
        List truncatedEmailNotifications = StreamSupport.stream(emailNotifications.spliterator(), false).peek(en -> en.setEmailSubject(this.truncateString(en.getEmailSubject(), 50))).collect(Collectors.toList());
        model.addAttribute("success", (Object)success);
        model.addAttribute("deletesuccess", (Object)deletesuccess);
        model.addAttribute("notifications", truncatedEmailNotifications);
        return "notificationlist";
    }

    public String truncateString(String str, int maxLength) {
        if (str != null && str.length() > maxLength) {
            return str.substring(0, maxLength) + "...";
        }
        return str;
    }
}

