/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.controllers;

import cz.snyll.sunny.convenience.NicePrinter;
import cz.snyll.sunny.domain.NewsEntry;
import cz.snyll.sunny.services.EventEntryManagerService;
import cz.snyll.sunny.services.SunnyConfigurationService;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.client.RestTemplate;

@Controller
public class NewsController {
    @Value(value="${sunnyhomeonline.url}")
    private String sunnyHomeOnlineUrl;
    EventEntryManagerService eventEntryManagerService;
    RestTemplate restTemplate;
    SunnyConfigurationService sunnyConfigurationService;

    @Autowired
    public NewsController(EventEntryManagerService eventEntryManagerService, RestTemplate restTemplate, SunnyConfigurationService sunnyConfigurationService) {
        this.eventEntryManagerService = eventEntryManagerService;
        this.restTemplate = restTemplate;
        this.sunnyConfigurationService = sunnyConfigurationService;
    }

    @GetMapping(value={"/news"})
    public String news(Model model) {
        String token = this.sunnyConfigurationService.getSetting("sunnyhome_click_token");
        String locale = this.sunnyConfigurationService.getSetting("language");
        this.sunnyConfigurationService.saveSetting("last_read_time", LocalDateTime.now().toString());
        this.sunnyConfigurationService.saveSetting("news_read", "True");
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(List.of(MediaType.APPLICATION_JSON));
        if (token != null && !token.isBlank()) {
            headers.setBearerAuth(token);
        }
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        String url = this.sunnyHomeOnlineUrl + "/news/news/by_locale/" + locale;
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, entity, NewsEntry[].class, new Object[0]);
            List<NewsEntry> newsList = Arrays.asList(Objects.requireNonNull((NewsEntry[])response.getBody()));
            model.addAttribute("news", newsList);
        }
        catch (Exception e) {
            NicePrinter.nicePrint((String)("SUNNYHOME NEWS GETTER: Error while getting news from sunnyhome.click: " + e.getMessage()), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
        }
        return "news";
    }
}

