/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.controllers;

import cz.snyll.sunny.domain.InfoData;
import cz.snyll.sunny.services.CustomDashboardDataManagerService;
import cz.snyll.sunny.services.DeviceManagerService;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.SunnyConfigurationService;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class KrhovaController {
    private final MessageSource messageSource;
    private final DeviceManagerService deviceManagerService;
    private final InfoDataManagerService infoDataManagerService;
    private final SunnyConfigurationService sunnyConfigurationService;
    private final CustomDashboardDataManagerService customDashboardDataManagerService;

    @Autowired
    public KrhovaController(CustomDashboardDataManagerService customDashboardDataManagerService, MessageSource messageSource, DeviceManagerService deviceManagerService, InfoDataManagerService infoDataManagerService, SunnyConfigurationService sunnyConfigurationService) {
        this.messageSource = messageSource;
        this.deviceManagerService = deviceManagerService;
        this.infoDataManagerService = infoDataManagerService;
        this.sunnyConfigurationService = sunnyConfigurationService;
        this.customDashboardDataManagerService = customDashboardDataManagerService;
    }

    @GetMapping(value={"/krhova"})
    public String krhova(Model model, @RequestParam(required=false) Boolean fullscreen) {
        ArrayList infoDataSet = (ArrayList)this.infoDataManagerService.findAll();
        for (InfoData infoData : infoDataSet) {
            model.addAttribute(infoData.getDataKey(), (Object)infoData.prettyValue());
            try {
                model.addAttribute(infoData.getDataKey() + "_number", (Object)infoData.floatValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.sunnyConfigurationService.getSetting("total_panel_power_installed") != null) {
                model.addAttribute("total_power_installed", (Object)Float.valueOf(Float.parseFloat(this.sunnyConfigurationService.getSetting("total_panel_power_installed"))));
                continue;
            }
            model.addAttribute("total_power_installed", (Object)0);
        }
        model.addAttribute("fullscreen", (Object)fullscreen);
        model.addAttribute("spot_prices", (Object)Boolean.parseBoolean(this.sunnyConfigurationService.getSetting("spot_prices")));
        model.addAttribute("price_per_kwh_sell", (Object)Float.valueOf(Float.parseFloat(this.sunnyConfigurationService.getSetting("energy_price_per_kwh_sell"))));
        model.addAttribute("price_per_kwh", (Object)Float.valueOf(Float.parseFloat(this.sunnyConfigurationService.getSetting("energy_price_per_kwh"))));
        model.addAttribute("energy_currency", (Object)"?");
        model.addAttribute("wallboxip", (Object)this.sunnyConfigurationService.getSetting("wallbox_ip_address"));
        if (this.sunnyConfigurationService.getSetting("energy_currency") != null) {
            model.addAttribute("energy_currency", (Object)this.sunnyConfigurationService.getSetting("energy_currency"));
        }
        ArrayList devices = this.deviceManagerService.loadAll();
        model.addAttribute("devices", (Object)devices);
        List customDashboardData = this.customDashboardDataManagerService.loadAll();
        model.addAttribute("customDashboardData", (Object)customDashboardData);
        String[] runModes = new String[]{this.decodeRunMode(0), this.decodeRunMode(1), this.decodeRunMode(2), this.decodeRunMode(3), this.decodeRunMode(4), this.decodeRunMode(5), this.decodeRunMode(6), this.decodeRunMode(7), this.decodeRunMode(8), this.decodeRunMode(9), this.decodeRunMode(10), this.decodeRunMode(10), this.decodeRunMode(10), this.decodeRunMode(10), this.decodeRunMode(10), this.decodeRunMode(10), this.decodeRunMode(10), this.decodeRunMode(10), this.decodeRunMode(10), this.decodeRunMode(10), this.decodeRunMode(20)};
        String[] runModesWallbox = new String[]{this.decodeRunModeWallbox(0), this.decodeRunModeWallbox(1), this.decodeRunModeWallbox(2), this.decodeRunModeWallbox(3), this.decodeRunModeWallbox(4), this.decodeRunModeWallbox(5), this.decodeRunModeWallbox(6), this.decodeRunModeWallbox(7), this.decodeRunModeWallbox(8), this.decodeRunModeWallbox(9), this.decodeRunModeWallbox(10)};
        model.addAttribute("runModes", (Object)runModes);
        model.addAttribute("runModesWallbox", (Object)runModesWallbox);
        return "krhova";
    }

    public String decodeRunMode(int runMode) {
        String lang = this.sunnyConfigurationService.getSetting("language");
        Locale locale = Locale.forLanguageTag(lang);
        return this.messageSource.getMessage(switch (runMode) {
            case 0 -> "dashboard.diagram.inverter_runmode_waiting";
            case 1 -> "dashboard.diagram.inverter_runmode_checking";
            case 2 -> "dashboard.diagram.inverter_runmode_normal";
            case 3 -> "dashboard.diagram.inverter_runmode_fault";
            case 4 -> "dashboard.diagram.inverter_runmode_permanentfault";
            case 5 -> "dashboard.diagram.inverter_runmode_updating";
            case 6 -> "dashboard.diagram.inverter_runmode_epscheck";
            case 7 -> "dashboard.diagram.inverter_runmode_epsmode";
            case 8 -> "dashboard.diagram.inverter_runmode_selftest";
            case 9 -> "dashboard.diagram.inverter_runmode_idle";
            case 10 -> "dashboard.diagram.inverter_runmode_standby";
            case 20 -> "dashboard.diagram.inverter_runmode_remote_power_control";
            default -> throw new IllegalArgumentException("Invalid run mode: " + runMode);
        }, null, locale);
    }

    public String decodeRunModeWallbox(int runModeWallbox) {
        String lang = this.sunnyConfigurationService.getSetting("language");
        Locale locale = Locale.forLanguageTag(lang);
        return this.messageSource.getMessage(switch (runModeWallbox) {
            case 0 -> "dashboard.diagram.wallbox_runmode_available";
            case 1 -> "dashboard.diagram.wallbox_runmode_preparing";
            case 2 -> "dashboard.diagram.wallbox_runmode_charging";
            case 3 -> "dashboard.diagram.wallbox_runmode_finishing";
            case 4 -> "dashboard.diagram.wallbox_runmode_faulted";
            case 5 -> "dashboard.diagram.wallbox_runmode_unavailable";
            case 6 -> "dashboard.diagram.wallbox_runmode_reserved";
            case 7 -> "dashboard.diagram.wallbox_runmode_suspendedev";
            case 8 -> "dashboard.diagram.wallbox_runmode_suspendedevse";
            case 9 -> "dashboard.diagram.wallbox_runmode_update";
            case 10 -> "dashboard.diagram.wallbox_runmode_card_activation";
            default -> throw new IllegalArgumentException("Invalid wallbox run mode: " + runModeWallbox);
        }, null, locale);
    }
}

