/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.controllers;

import cz.snyll.sunny.domain.Device;
import cz.snyll.sunny.domain.DeviceSetting;
import cz.snyll.sunny.repositories.DeviceRepository;
import cz.snyll.sunny.repositories.DeviceSettingRepository;
import cz.snyll.sunny.services.DeviceControllers.DeviceControllerFactory;
import cz.snyll.sunny.services.DeviceManagerService;
import cz.snyll.sunny.services.DeviceSettingManagerService;
import jakarta.validation.Valid;
import java.util.HashSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class DeviceController {
    private final DeviceManagerService deviceManagerService;
    private final DeviceRepository deviceRepository;
    private final DeviceSettingManagerService deviceSettingManagerService;
    private final DeviceSettingRepository deviceSettingRepository;

    @Autowired
    public DeviceController(DeviceManagerService deviceManagerService, DeviceRepository deviceRepository, DeviceSettingManagerService deviceSettingManagerService, DeviceSettingRepository deviceSettingRepository) {
        this.deviceManagerService = deviceManagerService;
        this.deviceRepository = deviceRepository;
        this.deviceSettingManagerService = deviceSettingManagerService;
        this.deviceSettingRepository = deviceSettingRepository;
    }

    @GetMapping(value={"/device"})
    public String device(Model model, @RequestParam(required=false) Long id) {
        if (id == null) {
            id = 0L;
        }
        Device device = this.deviceRepository.findById((Object)id).orElseGet(Device::new);
        model.addAttribute("smartdevicelist", (Object)DeviceControllerFactory.getSmartDeviceList());
        model.addAttribute("device", (Object)device);
        model.addAttribute("devicesettings", (Object)this.deviceSettingManagerService.loadAll());
        return "device";
    }

    @GetMapping(value={"/device/edit"})
    public String deviceEdit(Model model, @RequestParam(required=false) Long id, @RequestParam(required=false) boolean delete) {
        if (delete && id > 0L) {
            model.addAttribute("smartdevicelist", (Object)DeviceControllerFactory.getSmartDeviceList());
            model.addAttribute("devicesettings", (Object)this.deviceSettingManagerService.loadAll());
            this.deviceManagerService.deleteDeviceById(id.longValue());
            return "redirect:../devicelist?deletesuccess=true";
        }
        return "redirect:../devicelist?deletesuccess=false";
    }

    @PostMapping(value={"/device"})
    public String deviceSubmit(@Valid @ModelAttribute Device device, BindingResult result, Model model) {
        try {
            model.addAttribute("device", (Object)device);
            model.addAttribute("smartdevicelist", (Object)DeviceControllerFactory.getSmartDeviceList());
            model.addAttribute("devicesettings", (Object)this.deviceSettingManagerService.loadAll());
            if (device.getDeviceSettings() != null) {
                HashSet actualDeviceSettings = new HashSet();
                for (DeviceSetting idDeviceSetting : device.getDeviceSettings()) {
                    this.deviceSettingRepository.findById((Object)idDeviceSetting.getId()).ifPresent(actualDeviceSettings::add);
                }
                device.setDeviceSettings(actualDeviceSettings);
            }
            DeviceControllerFactory.removeControllerFromCache((Long)device.getId());
            if (result.hasErrors()) {
                return "device";
            }
            this.deviceManagerService.saveDevice(device);
            model.addAttribute("success", (Object)true);
            return "redirect:/devicelist?success=true";
        }
        catch (Exception e) {
            e.printStackTrace();
            model.addAttribute("smartdevicelist", (Object)DeviceControllerFactory.getSmartDeviceList());
            model.addAttribute("devicesettings", (Object)this.deviceSettingManagerService.loadAll());
            return "device";
        }
    }
}

