/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.controllers;

import cz.snyll.sunny.domain.InfoData;
import cz.snyll.sunny.services.CustomDashboardDataManagerService;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.SunnyConfigurationService;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;

@Controller
public class CustomDashboardController {
    private final MessageSource messageSource;
    private final InfoDataManagerService infoDataManagerService;
    private final SunnyConfigurationService sunnyConfigurationService;
    private final CustomDashboardDataManagerService customDashboardDataManagerService;

    @Autowired
    public CustomDashboardController(CustomDashboardDataManagerService customDashboardDataManagerService, MessageSource messageSource, InfoDataManagerService infoDataManagerService, SunnyConfigurationService sunnyConfigurationService) {
        this.messageSource = messageSource;
        this.infoDataManagerService = infoDataManagerService;
        this.sunnyConfigurationService = sunnyConfigurationService;
        this.customDashboardDataManagerService = customDashboardDataManagerService;
    }

    @GetMapping(value={"/custom_dashboard"})
    public String customDashboard(Model model) {
        ArrayList infoDataSet = (ArrayList)this.infoDataManagerService.findAll();
        for (InfoData infoData : infoDataSet) {
            model.addAttribute(infoData.getDataKey(), (Object)infoData.prettyValue());
            try {
                model.addAttribute(infoData.getDataKey() + "_number", (Object)infoData.floatValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.sunnyConfigurationService.getSetting("total_panel_power_installed") != null) {
                model.addAttribute("total_power_installed", (Object)Float.valueOf(Float.parseFloat(this.sunnyConfigurationService.getSetting("total_panel_power_installed"))));
                continue;
            }
            model.addAttribute("total_power_installed", (Object)0);
        }
        model.addAttribute("spot_prices", (Object)Boolean.parseBoolean(this.sunnyConfigurationService.getSetting("spot_prices")));
        model.addAttribute("price_per_kwh_sell", (Object)Float.valueOf(Float.parseFloat(this.sunnyConfigurationService.getSetting("energy_price_per_kwh_sell"))));
        model.addAttribute("price_per_kwh", (Object)Float.valueOf(Float.parseFloat(this.sunnyConfigurationService.getSetting("energy_price_per_kwh"))));
        model.addAttribute("energy_currency", (Object)"?");
        if (this.sunnyConfigurationService.getSetting("energy_currency") != null) {
            model.addAttribute("energy_currency", (Object)this.sunnyConfigurationService.getSetting("energy_currency"));
        }
        List customDashboardData = this.customDashboardDataManagerService.loadAll();
        model.addAttribute("customDashboardData", (Object)customDashboardData);
        String[] runModes = new String[]{this.decodeRunMode(0), this.decodeRunMode(1), this.decodeRunMode(2), this.decodeRunMode(3), this.decodeRunMode(4), this.decodeRunMode(5), this.decodeRunMode(6), this.decodeRunMode(7), this.decodeRunMode(8), this.decodeRunMode(9), this.decodeRunMode(10), this.decodeRunMode(11), this.decodeRunMode(12), this.decodeRunMode(13), this.decodeRunMode(14), this.decodeRunMode(15), this.decodeRunMode(16), this.decodeRunMode(17), this.decodeRunMode(18), this.decodeRunMode(19), this.decodeRunMode(20)};
        model.addAttribute("runModes", (Object)runModes);
        return "customdashboard";
    }

    public String decodeRunMode(int runMode) {
        String lang = this.sunnyConfigurationService.getSetting("language");
        Locale locale = Locale.forLanguageTag(lang);
        return this.messageSource.getMessage(switch (runMode) {
            case 0 -> "dashboard.diagram.inverter_runmode_waiting";
            case 1 -> "dashboard.diagram.inverter_runmode_checking";
            case 2 -> "dashboard.diagram.inverter_runmode_normal";
            case 3 -> "dashboard.diagram.inverter_runmode_fault";
            case 4 -> "dashboard.diagram.inverter_runmode_permanentfault";
            case 5 -> "dashboard.diagram.inverter_runmode_updating";
            case 6 -> "dashboard.diagram.inverter_runmode_epscheck";
            case 7 -> "dashboard.diagram.inverter_runmode_epsmode";
            case 8 -> "dashboard.diagram.inverter_runmode_selftest";
            case 9 -> "dashboard.diagram.inverter_runmode_idle";
            case 10 -> "dashboard.diagram.inverter_runmode_standby";
            default -> "dashboard.diagram.inverter_runmode_unknown";
        }, null, locale);
    }
}

