/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.config;

import cz.snyll.sunny.convenience.CustomLocaleChangeInterceptor;
import cz.snyll.sunny.convenience.CustomLocaleResolver;
import cz.snyll.sunny.services.SunnyConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class LocaleConfiguration
implements WebMvcConfigurer {
    private final SunnyConfigurationService sunnyConfigurationService;
    @Autowired
    private CustomLocaleChangeInterceptor customLocaleChangeInterceptor;

    @Autowired
    public LocaleConfiguration(SunnyConfigurationService sunnyConfigurationService) {
        this.sunnyConfigurationService = sunnyConfigurationService;
    }

    @Bean(value={"messageSource"})
    public MessageSource messageSource() {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBasenames(new String[]{"languages/messages"});
        messageSource.setDefaultEncoding("UTF-8");
        return messageSource;
    }

    @Bean
    public LocaleResolver localeResolver() {
        return new CustomLocaleResolver(this.sunnyConfigurationService);
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.customLocaleChangeInterceptor);
    }
}

