/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.smartinverterautomations;

import cz.snyll.sunny.config.InverterMap;
import cz.snyll.sunny.domain.inverter.Inverter;
import cz.snyll.sunny.invertermaps.InverterMappingConfigurationFactory;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.automation.InverterCloudController;
import cz.snyll.sunny.services.smartinverterautomations.InverterWriteServiceInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class InverterWriteServiceAPI
implements InverterWriteServiceInterface {
    private static final Logger log = LoggerFactory.getLogger(InverterWriteServiceAPI.class);
    private Inverter inverter;
    private HashMap<String, InverterMap> inverterMap;
    private final InverterMappingConfigurationFactory inverterMappingConfigurationFactory;
    private final InfoDataManagerService infoDataManagerService;
    private final InverterCloudController inverterCloudController;
    private int inverterWorkmodeWhenDischargingStarted;

    @Autowired
    public InverterWriteServiceAPI(InverterMappingConfigurationFactory inverterMappingConfigurationFactory, InfoDataManagerService infoDataManagerService, InverterCloudController inverterCloudController) {
        this.infoDataManagerService = infoDataManagerService;
        this.inverter = null;
        this.inverterMappingConfigurationFactory = inverterMappingConfigurationFactory;
        this.inverterCloudController = inverterCloudController;
    }

    public boolean startBatteryCharging() {
        if (this.inverter == null) {
            log.error("Cannot start battery charging: inverter is null");
            return false;
        }
        log.info("Starting battery charging for inverter: {}", (Object)this.inverter.getInverterName());
        try {
            int gridChargeEnabledRegisterAddress = InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"grid_charge_enabled");
            int gridChargeToRegisterAddress = InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"charge_battery_to");
            int gridChargePeriodStartRegisterAddress = InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"charge_period_start");
            int gridChargePeriodEndRegisterAddress = InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"charge_period_end");
            log.info("Register addresses - gridChargeEnabled: {}, chargeTo: {}, periodStart: {}, periodEnd: {}", new Object[]{gridChargeEnabledRegisterAddress, gridChargeToRegisterAddress, gridChargePeriodStartRegisterAddress, gridChargePeriodEndRegisterAddress});
            if (gridChargeEnabledRegisterAddress == -1 || gridChargeToRegisterAddress == -1 || gridChargePeriodStartRegisterAddress == -1 || gridChargePeriodEndRegisterAddress == -1) {
                log.error("Cannot start battery charging: missing required register addresses for inverter {}. gridChargeEnabled={}, chargeTo={}, periodStart={}, periodEnd={}", new Object[]{this.inverter.getInverterName(), gridChargeEnabledRegisterAddress, gridChargeToRegisterAddress, gridChargePeriodStartRegisterAddress, gridChargePeriodEndRegisterAddress});
                return false;
            }
            log.info("Waking up inverter before charging");
            this.wakeUpInverter();
            log.info("Unlocking inverter {}", (Object)this.inverter.getInverterName());
            this.inverterCloudController.unlockInverter(this.inverter);
            String CHARGE_ADDRESS = "1";
            String CHARGE_PERIOD_START_VALUE = "1";
            String CHARGE_PERIOD_END_VALUE = "5947";
            log.info("Sending charging settings - chargeLimit: {}, periodStart: {}, periodEnd: {}", new Object[]{this.inverter.getChargeLimit(), CHARGE_PERIOD_START_VALUE, CHARGE_PERIOD_END_VALUE});
            this.inverterCloudController.sendInverterSettings(gridChargeEnabledRegisterAddress, CHARGE_ADDRESS, true, this.inverter);
            this.inverterCloudController.sendInverterSettings(gridChargeToRegisterAddress, String.valueOf(this.inverter.getChargeLimit()), true, this.inverter);
            this.inverterCloudController.sendInverterSettings(gridChargePeriodStartRegisterAddress, CHARGE_PERIOD_START_VALUE, true, this.inverter);
            this.inverterCloudController.sendInverterSettings(gridChargePeriodEndRegisterAddress, CHARGE_PERIOD_END_VALUE, true, this.inverter);
            log.info("Successfully started battery charging for inverter {}", (Object)this.inverter.getInverterName());
            return true;
        }
        catch (Exception e) {
            log.error("Exception occurred while starting battery charging for inverter {}: {}", new Object[]{this.inverter.getInverterName(), e.getMessage(), e});
            return false;
        }
    }

    public boolean startBatteryDischarging() {
        if (this.inverter == null) {
            log.error("Cannot start battery discharging: inverter is null");
            return false;
        }
        log.info("Starting battery discharging for inverter: {}", (Object)this.inverter.getInverterName());
        try {
            String workmodeStr = this.infoDataManagerService.findByDataKey("inverter_workmode").getDataValue();
            log.info("Current inverter workmode: {}", (Object)workmodeStr);
            if (workmodeStr != null) {
                try {
                    this.inverterWorkmodeWhenDischargingStarted = (int)Double.parseDouble(workmodeStr);
                    log.info("Parsed workmode value: {}", (Object)this.inverterWorkmodeWhenDischargingStarted);
                }
                catch (NumberFormatException e) {
                    log.error("Invalid inverter_workmode value: {}", (Object)workmodeStr, (Object)e);
                    throw new IllegalArgumentException("Invalid inverter_workmode value: " + workmodeStr, e);
                }
            } else {
                log.error("inverter_workmode key not found in infoDataManagerService");
                throw new IllegalStateException("inverter_workmode key not found in infoDataManagerService");
            }
            int workModeRegisterAddress = InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"work_mode");
            int manualModeSettingsRegisterAddress = InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"manual_mode_settings");
            log.info("Register addresses - workMode: {}, manualModeSettings: {}", (Object)workModeRegisterAddress, (Object)manualModeSettingsRegisterAddress);
            if (workModeRegisterAddress == -1 || manualModeSettingsRegisterAddress == -1) {
                log.error("Cannot start battery discharging: missing required register addresses for inverter {}. workMode={}, manualModeSettings={}", new Object[]{this.inverter.getInverterName(), workModeRegisterAddress, manualModeSettingsRegisterAddress});
                return false;
            }
            log.info("Waking up inverter before discharging");
            this.wakeUpInverter();
            String MANUAL_MODE = "3";
            String DISCHARGE = "2";
            log.info("Sending discharging settings - manualMode: {}, discharge: {}", (Object)MANUAL_MODE, (Object)DISCHARGE);
            this.inverterCloudController.sendInverterSettings(workModeRegisterAddress, MANUAL_MODE, true, this.inverter);
            this.inverterCloudController.sendInverterSettings(manualModeSettingsRegisterAddress, DISCHARGE, true, this.inverter);
            log.info("Successfully started battery discharging for inverter {}", (Object)this.inverter.getInverterName());
            return true;
        }
        catch (Exception e) {
            log.error("Exception occurred while starting battery discharging for inverter {}: {}", new Object[]{this.inverter.getInverterName(), e.getMessage(), e});
            return false;
        }
    }

    public boolean stopBatteryDischarging() {
        if (this.inverter == null) {
            log.error("Cannot stop battery discharging: inverter is null");
            return false;
        }
        log.info("Stopping battery discharging for inverter: {}", (Object)this.inverter.getInverterName());
        try {
            int workModeRegisterAddress = InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"work_mode");
            int manualModeSettingsRegisterAddress = InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"manual_mode_settings");
            log.info("Register addresses - workMode: {}, manualModeSettings: {}", (Object)workModeRegisterAddress, (Object)manualModeSettingsRegisterAddress);
            if (workModeRegisterAddress == -1 || manualModeSettingsRegisterAddress == -1) {
                log.error("Cannot stop battery discharging: missing required register addresses for inverter {}. workMode={}, manualModeSettings={}", new Object[]{this.inverter.getInverterName(), workModeRegisterAddress, manualModeSettingsRegisterAddress});
                return false;
            }
            log.info("Waking up inverter before stopping discharge");
            this.wakeUpInverter();
            String STOP_CHARGE_DISCHARGE_VALUE = "3";
            log.info("Restoring previous workmode: {} and setting manual mode to: {}", (Object)this.inverterWorkmodeWhenDischargingStarted, (Object)STOP_CHARGE_DISCHARGE_VALUE);
            this.inverterCloudController.sendInverterSettings(workModeRegisterAddress, String.valueOf(this.inverterWorkmodeWhenDischargingStarted), true, this.inverter);
            this.inverterCloudController.sendInverterSettings(manualModeSettingsRegisterAddress, STOP_CHARGE_DISCHARGE_VALUE, true, this.inverter);
            log.info("Successfully stopped battery discharging for inverter {}", (Object)this.inverter.getInverterName());
            return true;
        }
        catch (Exception e) {
            log.error("Exception occurred while stopping battery discharging for inverter {}: {}", new Object[]{this.inverter.getInverterName(), e.getMessage(), e});
            return false;
        }
    }

    public boolean setExportLimit(int limitWatts) {
        if (this.inverter == null) {
            log.error("Cannot set export limit: inverter is null");
            return false;
        }
        log.info("Setting export limit to {} watts for inverter: {}", (Object)limitWatts, (Object)this.inverter.getInverterName());
        try {
            int userExportLimitRegisterAddress = InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"user_export_limit");
            log.info("Register address - userExportLimit: {}", (Object)userExportLimitRegisterAddress);
            if (userExportLimitRegisterAddress == -1) {
                log.error("Cannot set export limit: missing required register address 'user_export_limit' for inverter {}", (Object)this.inverter.getInverterName());
                return false;
            }
            double modifier = InverterMap.getModifierOrDefault((Map)this.inverterMap, (String)"user_export_limit");
            int finalLimitWatts = (int)((double)limitWatts * modifier);
            log.info("Setting export limit - original: {} watts, modifier: {}, final: {} watts", new Object[]{limitWatts, modifier, finalLimitWatts});
            log.info("Waking up inverter before setting export limit");
            this.wakeUpInverter();
            log.info("Unlocking inverter {}", (Object)this.inverter.getInverterName());
            this.inverterCloudController.unlockInverter(this.inverter);
            if (!this.inverterCloudController.sendInverterSettings(userExportLimitRegisterAddress, String.valueOf(finalLimitWatts), true, this.inverter)) {
                log.error("Failed to send export limit settings for inverter {}", (Object)this.inverter.getInverterName());
                return false;
            }
            log.info("Successfully set export limit to {} watts for inverter {}", (Object)finalLimitWatts, (Object)this.inverter.getInverterName());
            return true;
        }
        catch (Exception e) {
            log.error("Exception occurred while setting export limit for inverter {}: {}", new Object[]{this.inverter.getInverterName(), e.getMessage(), e});
            return false;
        }
    }

    public boolean stopBatteryCharging() {
        if (this.inverter == null) {
            log.error("Cannot stop battery charging: inverter is null");
            return false;
        }
        log.info("Stopping battery charging for inverter: {}", (Object)this.inverter.getInverterName());
        try {
            int gridChargeEnabledRegisterAddress = InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"grid_charge_enabled");
            int gridChargePeriodStartRegisterAddress = InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"charge_period_start");
            int gridChargePeriodEndRegisterAddress = InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"charge_period_end");
            log.info("Register addresses - gridChargeEnabled: {}, periodStart: {}, periodEnd: {}", new Object[]{gridChargeEnabledRegisterAddress, gridChargePeriodStartRegisterAddress, gridChargePeriodEndRegisterAddress});
            if (gridChargeEnabledRegisterAddress == -1 || gridChargePeriodStartRegisterAddress == -1 || gridChargePeriodEndRegisterAddress == -1) {
                log.error("Cannot stop battery charging: missing required register addresses for inverter {}. gridChargeEnabled={}, periodStart={}, periodEnd={}", new Object[]{this.inverter.getInverterName(), gridChargeEnabledRegisterAddress, gridChargePeriodStartRegisterAddress, gridChargePeriodEndRegisterAddress});
                return false;
            }
            log.info("Waking up inverter before stopping charge");
            this.wakeUpInverter();
            log.info("Disabling grid charge and resetting charge periods");
            this.inverterCloudController.sendInverterSettings(gridChargeEnabledRegisterAddress, "0", true, this.inverter);
            this.inverterCloudController.sendInverterSettings(gridChargePeriodStartRegisterAddress, "0", true, this.inverter);
            this.inverterCloudController.sendInverterSettings(gridChargePeriodEndRegisterAddress, "0", true, this.inverter);
            log.info("Successfully stopped battery charging for inverter {}", (Object)this.inverter.getInverterName());
            return true;
        }
        catch (Exception e) {
            log.error("Exception occurred while stopping battery charging for inverter {}: {}", new Object[]{this.inverter.getInverterName(), e.getMessage(), e});
            return false;
        }
    }

    public void wakeUpInverter() {
        if (this.inverter == null) {
            log.warn("Cannot wake up inverter: inverter is null");
            return;
        }
        log.info("Checking if inverter {} needs to be woken up", (Object)this.inverter.getInverterName());
        try {
            String runmodeStr = this.infoDataManagerService.getInfoDataForInverter(this.inverter, "solax_inverter_runmode").getDataValue();
            log.info("Current inverter runmode: {}", (Object)runmodeStr);
            int runmode = (int)Double.parseDouble(runmodeStr);
            if (runmode != 9) {
                log.info("Inverter is already awake (runmode: {}), skipping wake up", (Object)runmode);
                return;
            }
            log.info("Inverter {} is in sleep mode (runmode: 9), attempting to wake up", (Object)this.inverter.getInverterName());
            int wakeUpRegisterAddress = InverterMap.getRegisterAddressOrDefault((Map)this.inverterMap, (String)"system_on");
            log.info("Wake up register address: {}", (Object)wakeUpRegisterAddress);
            if (wakeUpRegisterAddress == -1) {
                log.error("Cannot wake up inverter: missing required register address 'system_on' for inverter {}", (Object)this.inverter.getInverterName());
                return;
            }
            this.inverterCloudController.sendInverterSettings(wakeUpRegisterAddress, "1", true, this.inverter);
            log.info("Successfully sent wake up command to inverter {}", (Object)this.inverter.getInverterName());
        }
        catch (Exception e) {
            log.error("Exception occurred while waking up inverter {}: {}", new Object[]{this.inverter.getInverterName(), e.getMessage(), e});
        }
    }

    public void setInverter(Inverter inverter) {
        log.info("Setting inverter: {}", (Object)(inverter != null ? inverter.getInverterName() : "null"));
        this.inverter = inverter;
        if (inverter == null) {
            log.warn("Inverter set to null");
            return;
        }
        try {
            log.info("Loading inverter mapping configuration for serial: {}", (Object)inverter.getInverterSerialNumber());
            Map apiMapperString = this.inverterMappingConfigurationFactory.getInverterWriteConfig(inverter.getInverterSerialNumber(), Inverter.CommunicationType.LocalAPI).getInverterMap();
            this.inverterMap = new HashMap();
            int successCount = 0;
            int failCount = 0;
            for (Map.Entry entry : apiMapperString.entrySet()) {
                try {
                    String key = (String)entry.getKey();
                    InverterMap inverterMap = new InverterMap(Integer.parseInt((String)((ArrayList)entry.getValue()).get(0)), Float.parseFloat((String)((ArrayList)entry.getValue()).get(1)), (String)((ArrayList)entry.getValue()).get(2), (String)((ArrayList)entry.getValue()).get(3), Integer.parseInt((String)((ArrayList)entry.getValue()).get(4)));
                    this.inverterMap.put(key, inverterMap);
                    ++successCount;
                }
                catch (Exception e) {
                    ++failCount;
                    log.warn("Failed to parse inverter map entry for key '{}': {}", entry.getKey(), (Object)e.getMessage());
                }
            }
            log.info("Loaded inverter mapping configuration: {} successful, {} failed entries", (Object)successCount, (Object)failCount);
            log.info("Available register mappings: {}", this.inverterMap.keySet());
        }
        catch (Exception e) {
            log.error("Exception occurred while setting inverter mapping configuration for {}: {}", new Object[]{inverter.getInverterName(), e.getMessage(), e});
        }
    }
}

