/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.datasenders;

import cz.snyll.sunny.convenience.NicePrinter;
import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.domain.InfoData;
import cz.snyll.sunny.services.EventEntryManagerService;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.SunnyConfigurationService;
import java.util.Date;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class SunnyMapDataSender {
    private final InfoDataManagerService infoDataManagerService;
    private final SunnyConfigurationService sunnyConfigurationService;
    private final EventEntryManagerService eventEntryManagerService;

    @Autowired
    public SunnyMapDataSender(InfoDataManagerService infoDataManagerService, SunnyConfigurationService sunnyConfigurationService, EventEntryManagerService eventEntryManagerService) {
        this.eventEntryManagerService = eventEntryManagerService;
        this.sunnyConfigurationService = sunnyConfigurationService;
        this.infoDataManagerService = infoDataManagerService;
    }

    @Scheduled(fixedDelay=10000L)
    public void SendData() {
        block4: {
            if (!Boolean.parseBoolean(this.sunnyConfigurationService.getSetting("send_data_to_sunnymap"))) {
                return;
            }
            try {
                String token = this.sunnyConfigurationService.getSetting("sunnymap_token");
                float currentProductionFloat = Float.parseFloat(this.infoDataManagerService.findByDataKey("solax_solar_panels_power_total").getDataValue());
                String currentProduction = String.format(Locale.US, "%.2f", Float.valueOf(currentProductionFloat /= 1000.0f));
                InfoData infoData = this.infoDataManagerService.findByDataKey("solax_today_energy");
                if (infoData.getDataFreshness().before(new Date(System.currentTimeMillis() - 600000L))) {
                    NicePrinter.nicePrint((String)"SunnyMap sender: You have old data, check if everything is set up correctly. Not sending to SunnyMap.", (String)this.sunnyConfigurationService.getSetting("debug_mode"));
                    this.eventEntryManagerService.raiseEvent("SunnyMap sender: You have old data, check if everything is set up correctly. Not sending to SunnyMap.", EventEntry.EventType.WARNING, 60);
                    return;
                }
                String todayProduction = infoData.getDataValue();
                RestTemplate restTemplate = new RestTemplate();
                HttpHeaders headers = new HttpHeaders();
                headers.setContentType(MediaType.APPLICATION_JSON);
                String json = "{\"tokenHash\": \"" + token + "\", \"currentProduction\": " + currentProduction + ", \"todayProduction\": " + todayProduction + "}";
                HttpEntity entity = new HttpEntity((Object)json, (MultiValueMap)headers);
                ResponseEntity response = restTemplate.exchange("https://sunnymap.net/send_generation_data", HttpMethod.POST, entity, String.class, new Object[0]);
                NicePrinter.nicePrint((String)("SunnyMap response: " + (String)response.getBody()), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            }
            catch (Exception e) {
                NicePrinter.nicePrint((String)("Something went wrong when sending data to SunnyMap: " + e.getMessage()), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
                if (!(e instanceof HttpClientErrorException)) break block4;
                HttpClientErrorException clientError = (HttpClientErrorException)((Object)e);
                this.eventEntryManagerService.raiseEvent("Issue when sending data to SunnyMap: " + e.getMessage(), EventEntry.EventType.WARNING, 60);
                NicePrinter.nicePrint((String)("Error details: " + clientError.getResponseBodyAsString()), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            }
        }
    }
}

