/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.datasenders;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import cz.snyll.sunny.convenience.NicePrinter;
import cz.snyll.sunny.domain.DailyRecord;
import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.repositories.DailyRecordRepository;
import cz.snyll.sunny.services.EventEntryManagerService;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.SunnyConfigurationService;
import cz.snyll.sunny.services.datasenders.SunnyHomeClickAPIManager;
import cz.snyll.sunny.services.datasenders.SunnyHomeOnlineDailyRecordSender;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class SunnyHomeOnlineDailyRecordSender {
    private final SunnyConfigurationService sunnyConfigurationService;
    private final EventEntryManagerService eventEntryManagerService;
    private final DailyRecordRepository dailyRecordRepository;
    private final SunnyHomeClickAPIManager sunnyHomeClickAPIManager;
    @Value(value="${sunnyhomeonline.url}")
    private String sunnyHomeOnlineUrl;

    public SunnyHomeOnlineDailyRecordSender(DailyRecordRepository dailyRecordRepository, InfoDataManagerService infoDataManagerService, SunnyConfigurationService sunnyConfigurationService, EventEntryManagerService eventEntryManagerService, SunnyHomeClickAPIManager sunnyHomeClickAPIManager, RestTemplate restTemplate) {
        this.eventEntryManagerService = eventEntryManagerService;
        this.sunnyConfigurationService = sunnyConfigurationService;
        this.dailyRecordRepository = dailyRecordRepository;
        this.sunnyHomeClickAPIManager = sunnyHomeClickAPIManager;
        SimpleClientHttpRequestFactory clientHttpRequestFactory = new SimpleClientHttpRequestFactory();
        clientHttpRequestFactory.setConnectTimeout(5000);
        clientHttpRequestFactory.setReadTimeout(5000);
    }

    public void SendDailyRecords() {
        try {
            String latestDate;
            NicePrinter.nicePrint((String)"SUNNYHOME ONLINE DAILY RECORD DATASENDER: Going to send daily records to sunnyhome.click", (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            if (this.sunnyConfigurationService.getSetting("sunnyhome_click_user").isEmpty() || this.sunnyConfigurationService.getSetting("sunnyhome_click_token").isEmpty()) {
                return;
            }
            NicePrinter.nicePrint((String)"SUNNYHOME ONLINE DATASENDER: Sending daily records sunnyhome.click", (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            String sunnyHomeOnlineUser = this.sunnyConfigurationService.getSetting("sunnyhome_click_user");
            sunnyHomeOnlineUser = sunnyHomeOnlineUser.trim();
            String token = this.sunnyConfigurationService.getSetting("sunnyhome_click_token");
            token = token.trim();
            String url_latest_date = this.sunnyHomeOnlineUrl + "/data/" + sunnyHomeOnlineUser + "/latest_daily_record_date";
            String latest_date = this.sunnyHomeClickAPIManager.CallSunnyHomeClickAPI(token, url_latest_date, "");
            NicePrinter.nicePrint((String)("SUNNYHOME ONLINE DATASENDER: Latest date from sunnyhome.click: " + latest_date), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode latestDateNode = objectMapper.readTree(latest_date);
                if (latestDateNode == null || latestDateNode.get("latest_date") == null) {
                    latestDate = "1970-01-01";
                } else {
                    latestDate = latestDateNode.get("latest_date").asText();
                    if (latestDate == null || latestDate.isEmpty()) {
                        latestDate = "1970-01-01";
                    }
                }
            }
            catch (Exception e) {
                NicePrinter.nicePrint((String)("SUNNYHOME ONLINE DATASENDER: Error while parsing latest date from sunnyhome.click: " + e.getMessage()), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
                return;
            }
            LocalDate date = LocalDate.parse(latestDate);
            List dailyRecordList = this.dailyRecordRepository.findByDateGreaterThanEqual(date);
            ArrayList<DailyRecordDTO> dailyRecordDTOList = new ArrayList<DailyRecordDTO>();
            for (DailyRecord record : dailyRecordList) {
                DailyRecordDTO dto = new DailyRecordDTO(this);
                dto.setUserId(sunnyHomeOnlineUser);
                dto.setBalance(record.getBalance());
                dto.setTotalConsumption(record.getTotalConsumption());
                dto.setGridConsumption(record.getGridConsumption());
                dto.setGridFeedin(record.getGridFeedin());
                dto.setPanelEnergy(record.getPanelEnergy());
                dto.setAcEnergy(record.getAcEnergy());
                dto.setSelfConsumed(record.getSelfConsumed());
                dto.setEnergyPricePerKwh(record.getEnergyPricePerKwh());
                dto.setEnergyPricePerKwhSell(record.getEnergyPricePerKwhSell());
                dto.setTodaySpotEarnings(record.getTodaySpotEarnings());
                dto.setTodaySpotEarningsLocalCurrency(record.getTodaySpotEarningsLocalCurrency());
                dto.setTodaySpotSavingsLocalCurrency(record.getTodaySpotSavingsLocalCurrency());
                dto.setUpdatedTimestamp(record.getUpdatedTimestamp().toString());
                dto.setDate(record.getDate().toString());
                dailyRecordDTOList.add(dto);
            }
            Gson gson = new Gson();
            String json = gson.toJson(dailyRecordDTOList);
            String url = this.sunnyHomeOnlineUrl + "/data/" + sunnyHomeOnlineUser + "/save_daily_record";
            String response = this.sunnyHomeClickAPIManager.CallSunnyHomeClickAPI(token, url, json);
            if (response != null) {
                this.eventEntryManagerService.raiseEvent("Daily records sent to sunnyhome.click, response: " + response, EventEntry.EventType.INFO);
                NicePrinter.nicePrint((String)("SUNNYHOME ONLINE DATASENDER: Response from sunnyhome.click: " + response), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            }
        }
        catch (Exception e) {
            NicePrinter.nicePrint((String)("SUNNYHOME ONLINE DATASENDER: Error while sending daily records to sunnyhome.click: " + e.getMessage()), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            this.eventEntryManagerService.raiseEvent("Error while sending daily records to sunnyhome.click: " + e.getMessage(), EventEntry.EventType.ERROR);
        }
    }
}

