/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.database;

import java.io.FileWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DatabaseExportService {
    private final JdbcTemplate jdbcTemplate;

    @Autowired
    public DatabaseExportService(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public String exportDatabase(String exportFilePath, String ... excludedTables) throws IOException {
        List result = this.jdbcTemplate.queryForList("SCRIPT");
        HashSet<String> excludedTableSet = new HashSet<String>();
        for (String tableName : excludedTables) {
            excludedTableSet.add(tableName.toUpperCase());
        }
        Pattern insertPattern = Pattern.compile("^INSERT INTO \"(?:.+?)\".\"(.+?)\" ");
        try (FileWriter writer = new FileWriter(exportFilePath);){
            for (Map row : result) {
                String tableName;
                String scriptLine = row.get("SCRIPT").toString();
                Matcher matcher = insertPattern.matcher(scriptLine);
                boolean shouldWriteLine = false;
                if (matcher.find() && !excludedTableSet.contains(tableName = matcher.group(1).toUpperCase())) {
                    shouldWriteLine = true;
                }
                if (!shouldWriteLine) continue;
                writer.write(scriptLine + "\n");
            }
        }
        return exportFilePath;
    }

    @Transactional
    public void importDatabase(String importFilePath, String ... excludedTables) {
        try {
            System.out.println("Clearing the tables " + importFilePath);
            this.clearTables(excludedTables);
            System.out.println("Importing database from " + importFilePath);
            this.jdbcTemplate.execute("SET REFERENTIAL_INTEGRITY FALSE;");
            String sql = "RUNSCRIPT FROM './data/" + importFilePath + "'";
            this.jdbcTemplate.execute(sql);
            this.jdbcTemplate.execute("SET REFERENTIAL_INTEGRITY TRUE;");
        }
        catch (Exception e) {
            System.out.println("Error importing database: " + e.getMessage());
            throw new RuntimeException("Error importing database: " + e.getMessage(), e);
        }
    }

    private void clearTables(String ... excludedTables) {
        HashSet<String> excludedSet = new HashSet<String>(List.of(excludedTables));
        List tables = this.jdbcTemplate.queryForList("SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA='PUBLIC'", String.class);
        tables.stream().filter(tableName -> !excludedSet.contains(tableName)).forEach(tableName -> this.jdbcTemplate.update("DELETE FROM " + tableName));
    }
}

