/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.collectors.otherinfocollectors;

import cz.snyll.sunny.convenience.NicePrinter;
import cz.snyll.sunny.services.SunnyConfigurationService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class UserVerificationCollector {
    private final SunnyConfigurationService sunnyConfigurationService;
    private final RestTemplate restTemplate;
    private final String sunnyHomeOnlineUrl;

    public UserVerificationCollector(SunnyConfigurationService sunnyConfigurationService, RestTemplate restTemplate, @Value(value="${sunnyhomeonline.url}") String sunnyHomeOnlineUrl) {
        this.sunnyConfigurationService = sunnyConfigurationService;
        this.restTemplate = restTemplate;
        this.sunnyHomeOnlineUrl = sunnyHomeOnlineUrl;
    }

    @Scheduled(fixedDelay=600000L)
    public void userVerification() {
        try {
            String currentUser = this.sunnyConfigurationService.getSetting("sunnyhome_click_user");
            String finalUrl = this.sunnyHomeOnlineUrl + "/users/" + currentUser + "/verify_user";
            String token = this.sunnyConfigurationService.getSetting("sunnyhome_click_token");
            if (currentUser == null || token == null || currentUser.isEmpty() || token.isEmpty()) {
                this.sunnyConfigurationService.saveSetting("user_verified", "False");
                NicePrinter.nicePrint((String)"USER VERIFICATION: flag set to false", (String)this.sunnyConfigurationService.getSetting("debug_mode"));
                return;
            }
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setBearerAuth(token);
            HttpEntity entity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(finalUrl, HttpMethod.GET, entity, String.class, new Object[0]);
            if (response.getStatusCode() != HttpStatusCode.valueOf((int)200)) {
                NicePrinter.nicePrint((String)"USER VERIFICATION: flag set to false", (String)this.sunnyConfigurationService.getSetting("debug_mode"));
                this.sunnyConfigurationService.saveSetting("user_verified", "False");
            } else {
                NicePrinter.nicePrint((String)"USER VERIFICATION: flag set to true", (String)this.sunnyConfigurationService.getSetting("debug_mode"));
                this.sunnyConfigurationService.saveSetting("user_verified", "True");
            }
        }
        catch (Exception e) {
            NicePrinter.nicePrint((String)("USER VERIFICATION: Error verifying SunnyHome.Click user: " + e.getMessage()), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
        }
    }
}

