/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.collectors.otherinfocollectors;

import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.domain.InfoData;
import cz.snyll.sunny.services.EventEntryManagerService;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.collectors.DataCollectorAbstractService;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class LocalIpCollector
extends DataCollectorAbstractService {
    private final EventEntryManagerService eventEntryManagerService;

    public LocalIpCollector(InfoDataManagerService infoDataManagerService, EventEntryManagerService eventEntryManagerService) {
        super(infoDataManagerService);
        this.eventEntryManagerService = eventEntryManagerService;
    }

    @Scheduled(fixedDelay=100000L)
    public void scheduledCollection() {
        this.collectData();
    }

    public HashMap<String, Map.Entry<String, String>> collectData() {
        try {
            String localIpAddress = this.resolveLocalIpAddress();
            InfoData infoData = new InfoData("local_ip_address", localIpAddress, "", 880000);
            this.saveinfodata(infoData);
        }
        catch (Exception e) {
            this.eventEntryManagerService.raiseEvent("LOCAL IP COLLECTING: There was an issue with collecting local IP address: " + e.getMessage(), EventEntry.EventType.ERROR, 60);
        }
        return new HashMap<String, Map.Entry<String, String>>();
    }

    private String resolveLocalIpAddress() throws UnknownHostException {
        String envHostIp = System.getenv("HOST_IP");
        if (envHostIp != null && !envHostIp.isEmpty()) {
            return envHostIp;
        }
        String detectedIpAddress = this.getDetectedLocalIpAddress();
        return detectedIpAddress != null && !detectedIpAddress.isEmpty() ? detectedIpAddress : InetAddress.getLocalHost().getHostAddress();
    }

    private String getDetectedLocalIpAddress() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                if (networkInterface.isLoopback() || !networkInterface.isUp()) continue;
                Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress inetAddress = addresses.nextElement();
                    if (!(inetAddress instanceof Inet4Address)) continue;
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (Exception e) {
            this.eventEntryManagerService.raiseEvent("LOCAL IP COLLECTING: Error scanning network interfaces: " + e.getMessage(), EventEntry.EventType.ERROR, 60);
        }
        return null;
    }
}

