/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.collectors.inverterCollectors;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import cz.snyll.sunny.convenience.NicePrinter;
import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.domain.inverter.Inverter;
import cz.snyll.sunny.domain.inverter.LocalAPIDetails;
import cz.snyll.sunny.invertermaps.InverterMappingConfigurationFactory;
import cz.snyll.sunny.repositories.InverterRepository;
import cz.snyll.sunny.services.EventEntryManagerService;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.InverterCollectorAbstractService;
import cz.snyll.sunny.services.SunnyConfigurationService;
import cz.snyll.sunny.services.collectors.inverterCollectors.SolaxCalculateValues;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Scope(value="prototype")
public class DataCollectorInverterSolaxApi
extends InverterCollectorAbstractService {
    private static final Logger log = LoggerFactory.getLogger(DataCollectorInverterSolaxApi.class);
    private final EventEntryManagerService eventEntryManagerService;
    private final SunnyConfigurationService sunnyConfigurationService;
    private final InverterMappingConfigurationFactory inverterMappingConfigurationFactory;
    private final RestTemplate restTemplate;
    private final InfoDataManagerService infoDataManagerService;
    private final InverterRepository inverterRepository;

    @Autowired
    public DataCollectorInverterSolaxApi(InfoDataManagerService infoDataManagerService, InverterMappingConfigurationFactory inverterMappingConfigurationFactory, SunnyConfigurationService sunnyConfigurationService, EventEntryManagerService eventEntryManagerService, InverterRepository inverterRepository) {
        super(infoDataManagerService, inverterRepository);
        this.inverterMappingConfigurationFactory = inverterMappingConfigurationFactory;
        this.sunnyConfigurationService = sunnyConfigurationService;
        this.eventEntryManagerService = eventEntryManagerService;
        this.infoDataManagerService = infoDataManagerService;
        SimpleClientHttpRequestFactory clientHttpRequestFactory = new SimpleClientHttpRequestFactory();
        clientHttpRequestFactory.setConnectTimeout(5000);
        clientHttpRequestFactory.setReadTimeout(5000);
        this.restTemplate = new RestTemplate((ClientHttpRequestFactory)clientHttpRequestFactory);
        this.inverterRepository = inverterRepository;
    }

    public String callSolaxInverter(String ip, String password, String optType) {
        try {
            HttpEntity entity = DataCollectorInverterSolaxApi.getMultiValueMapHttpEntity((String)password, (String)optType);
            ResponseEntity response = this.restTemplate.exchange("http://" + ip + "/", HttpMethod.POST, entity, String.class, new Object[0]);
            return (String)response.getBody();
        }
        catch (Exception e) {
            this.eventEntryManagerService.raiseEvent("Solax inverter did not return any data: " + e.getMessage(), EventEntry.EventType.ERROR);
            NicePrinter.nicePrint((String)("Solax inverter did not return any data: " + e.getMessage()), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            return "";
        }
    }

    private static HttpEntity<MultiValueMap<String, String>> getMultiValueMapHttpEntity(String password, String optType) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("'X-Forwarded-For'", "'5.8.8.8'");
        LinkedMultiValueMap postData = new LinkedMultiValueMap();
        postData.add((Object)"optType", (Object)optType);
        postData.add((Object)"pwd", (Object)password);
        return new HttpEntity((Object)postData, (MultiValueMap)headers);
    }

    public HashMap<String, Map.Entry<String, String>> collectData() {
        HashMap dataMap;
        block12: {
            if (this.inverter == null) {
                NicePrinter.nicePrint((String)("Inverter is null, not collecting data on instance " + this), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
                return new HashMap<String, Map.Entry<String, String>>();
            }
            NicePrinter.nicePrint((String)"Collecting data from Solax inverter", (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            LocalAPIDetails connectionDetails = (LocalAPIDetails)this.inverter.getConnectionDetails();
            String localIp = connectionDetails.getIp();
            String localPassword = connectionDetails.getLocalPassword();
            NicePrinter.nicePrint((String)("Local IP: " + localIp + "; Local password: " + localPassword), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
            if (localIp == null || localPassword == null || localIp.isEmpty() || localPassword.isEmpty()) {
                this.eventEntryManagerService.raiseEvent("{datacollectorinverter.notconfigured_error}", EventEntry.EventType.ERROR, 60);
                return new HashMap<String, Map.Entry<String, String>>();
            }
            dataMap = new HashMap();
            try {
                String response = this.callSolaxInverter(localIp, localPassword, "ReadRealTimeData");
                ObjectMapper mapper = ((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true)).build();
                JsonNode jsonResponseWhole = mapper.readTree(response);
                NicePrinter.nicePrint((String)("Collecting inverter data: " + jsonResponseWhole.toString()), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
                String WifiSN = jsonResponseWhole.get("sn") == null ? jsonResponseWhole.get("SN").textValue() : jsonResponseWhole.get("sn").textValue();
                dataMap.put("solax_wifi_serial_number", new AbstractMap.SimpleEntry<String, String>(WifiSN, ""));
                String WifiVersion = jsonResponseWhole.get("ver").textValue();
                dataMap.put("solax_wifi_firmware_version", new AbstractMap.SimpleEntry<String, String>(WifiVersion, ""));
                JsonNode informationNode = jsonResponseWhole.get("Information");
                String inverterSN = "";
                if (informationNode.isArray()) {
                    inverterSN = jsonResponseWhole.get("type").isTextual() ? informationNode.get(3).textValue() : informationNode.get(2).textValue();
                    dataMap.put("solax_inverter_serial_number", new AbstractMap.SimpleEntry<String, String>(inverterSN, ""));
                    String armVersion = informationNode.get(6).asText();
                    dataMap.put("solax_inverter_arm_version", new AbstractMap.SimpleEntry<String, String>(armVersion, ""));
                    String dspVersion = informationNode.get(4).asText();
                    dataMap.put("solax_inverter_dsp_version", new AbstractMap.SimpleEntry<String, String>(dspVersion, ""));
                }
                Map apiMapperString = this.inverterMappingConfigurationFactory.getInverterConfig(inverterSN, Inverter.CommunicationType.LocalAPI).getInverterMap();
                HashMap apiMapper = this.getFinalMap(apiMapperString);
                Map apiMapperSettingsString = this.inverterMappingConfigurationFactory.getInverterSettingsConfig(inverterSN, this.inverter.getConnectionDetails().getCommunicationType()).getInverterMap();
                HashMap apiMapperSettings = this.getFinalMap(apiMapperSettingsString);
                JsonNode jsonResponseData = jsonResponseWhole.get("Data");
                try {
                    if (jsonResponseData.isArray()) {
                        dataMap.putAll(this.parseValues(jsonResponseData, apiMapper));
                        NicePrinter.nicePrint((String)("Collecting inverter data 1: " + dataMap), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
                        SolaxCalculateValues.calculateValues((HashMap)dataMap, (InfoDataManagerService)this.infoDataManagerService, (Inverter)this.inverter);
                        NicePrinter.nicePrint((String)("Collecting inverter data: " + dataMap), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
                    }
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.debug("SOLAX: Solax inverter data not loaded because of an exception: {}", (Object)e.getMessage());
                    }
                    this.eventEntryManagerService.raiseEvent("SOLAX: Solax inverter data not loaded because of an exception: " + e.getMessage(), EventEntry.EventType.ERROR, 60);
                }
                Thread.sleep(500L);
                String response_settings = this.callSolaxInverter(localIp, localPassword, "ReadSetData");
                JsonNode jsonResponseData_settings = mapper.readTree(response_settings);
                try {
                    if (jsonResponseData_settings.isArray()) {
                        NicePrinter.nicePrint((String)("Collecting inverter settings: " + jsonResponseData_settings), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
                        dataMap.putAll(this.parseValues(jsonResponseData_settings, apiMapperSettings));
                        break block12;
                    }
                    NicePrinter.nicePrint((String)"Collecting inverter settings: not an array", (String)this.sunnyConfigurationService.getSetting("debug_mode"));
                }
                catch (Exception e) {
                    log.warn("SOLAX: Solax inverter settings not loaded because of an exception: {}", (Object)e.getMessage(), (Object)e);
                    this.eventEntryManagerService.raiseEvent("SOLAX: Solax inverter settings not loaded because of an exception: " + e.getMessage(), EventEntry.EventType.ERROR, 60);
                }
            }
            catch (Exception e) {
                NicePrinter.nicePrint((String)("Issue while connecting to the Inverter. Error: " + e.getMessage()), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
                this.eventEntryManagerService.raiseEvent("SOLAX: Solax inverter request threw en exception: " + e.getMessage(), EventEntry.EventType.ERROR, 60);
            }
        }
        dataMap = this.prependInverterId(dataMap);
        this.saveinfodata(dataMap);
        return dataMap;
    }

    public void setInverter(Inverter inverter) {
        this.inverter = inverter;
        NicePrinter.nicePrint((String)("Setting inverter: " + inverter + "; on instance: " + this), (String)this.sunnyConfigurationService.getSetting("debug_mode"));
    }
}

