/*
 * Decompiled with CFR 0.152.
 */
package cz.snyll.sunny.services.collectors.energyPricesCollectors;

import cz.snyll.sunny.domain.EventEntry;
import cz.snyll.sunny.services.EventEntryManagerService;
import cz.snyll.sunny.services.InfoDataManagerService;
import cz.snyll.sunny.services.SunnyConfigurationService;
import cz.snyll.sunny.services.collectors.DataCollectorAbstractService;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class DataCollectorEurToCzk
extends DataCollectorAbstractService {
    private final RestTemplate restTemplate;
    private final EventEntryManagerService eventEntryManagerService;

    public DataCollectorEurToCzk(InfoDataManagerService infoDataManagerService, SunnyConfigurationService sunnyConfigurationService, RestTemplateBuilder restTemplateBuilder, EventEntryManagerService eventEntryManagerService) {
        super(infoDataManagerService);
        this.restTemplate = restTemplateBuilder.setConnectTimeout(Duration.ofSeconds(15L)).setReadTimeout(Duration.ofSeconds(15L)).build();
        this.eventEntryManagerService = eventEntryManagerService;
    }

    @Scheduled(fixedDelay=300000L)
    public void scheduledCollection() {
        this.collectData();
    }

    public HashMap<String, Map.Entry<String, String>> collectData() {
        try {
            String[] lines;
            HashMap<String, AbstractMap.SimpleEntry<String, String>> dataMap = new HashMap<String, AbstractMap.SimpleEntry<String, String>>();
            String url = "https://www.cnb.cz/cs/financni_trhy/devizovy_trh/kurzy_devizoveho_trhu/denni_kurz.txt";
            String response = (String)this.restTemplate.getForObject(url, String.class, new Object[0]);
            for (String line : lines = response.split("\n")) {
                String[] parts;
                if (!line.startsWith("EMU") || !(parts = line.split("\\|"))[3].equals("EUR")) continue;
                dataMap.put("euro_to_czk", new AbstractMap.SimpleEntry<String, String>(parts[4].replace(",", "."), "EUR/CZK"));
                break;
            }
            this.saveinfodata(dataMap);
        }
        catch (Exception e) {
            this.eventEntryManagerService.raiseEvent("Error while collecting data from CNB website: " + e.getMessage(), EventEntry.EventType.ERROR, 60);
        }
        return new HashMap<String, Map.Entry<String, String>>();
    }
}

